(defproject miazan/om-stuff "1.0-SNAPSHOT"
  :dependencies [[org.clojure/clojure "1.7.0-beta3"]
                 [org.clojure/clojurescript "1.7.170"]
                 [org.clojure/core.async "0.2.374"]
                 [prismatic/schema "1.0.3"]
                 [bidi "1.21.1"]
                 [hiccups "0.3.0"]
                 [cljsjs/react-with-addons "0.13.3-0"]
                 [bidi "1.21.1"]
                 [cljs-http "0.1.37"]
                 [xeric/om-test "1.0-SNAPSHOT"]
                 [com.taoensso/tower "3.0.2"
                  :exclusions [com.taoensso/encore]]
                 [com.taoensso/encore "1.28.0"]
                 [kioo "0.4.1" :exclusions [om org.omcljs/om cljsjs/react]]
                 [org.omcljs/om "0.8.8" :exclusions [org.clojure/clojure
                                                     org.clojure.clojurescript
                                                     cljsjs/react]]]
  :target-path "target/%s"
  :plugins
  [[lein-cljsbuild "1.1.1"]
   [cider/cider-nrepl "0.9.0-20150616.120440-43" :exclusions [org.clojure/tools.nrepl]]
   [lein-doo "0.1.6-SNAPSHOT"]
   [lein-ancient "0.6.2"
    :exclusions [org.clojure/clojure org.clojure/tools.reader org.clojure/data.xml]]]

  ;:repositories
  ;[["releases" {:url "http://54.148.5.140:8081/nexus/content/repositories/releases"
  ;              :username :env/syn_repo_username
  ;              :password :env/syn_repo_password :checksum :ignore}]
  ; ["snapshots" {:url "http://54.148.5.140:8081/nexus/content/repositories/snapshots"
  ;               :username :env/syn_repo_username
  ;               :password :env/syn_repo_password :checksum :ignore}]]
  :doo {:paths {:phantom "scripts/phantomjs.sh"}}
  :cljsbuild {
              :builds [{:id "dev"
                        :source-paths ["src" "test"]
                        :compiler {
                                   :output-to "target/survey_cljs.js"
                                   :output-dir "target/out"
                                   :optimizations :none
                                   :source-map true}}

                       {:id "test"
                        :source-paths ["src" "test" "test-resources"]
                        :compiler {
                                   :output-dir "target/cljs/out"
                                   :output-to "target/cljs/testable.js"
                                   :optimizations :none
                                   :main 'om-stuff.test-runner
                                   :pretty-print true}}]})
