(defproject miazan/om-stuff "0.2-SNAPSHOT"
  :dependencies [[org.clojure/clojure "1.7.0-beta3"]
                 [org.clojure/clojurescript "1.7.170"]
                 [org.clojure/core.async "0.2.374"]
                 [prismatic/schema "1.0.3"]
                 [bidi "1.21.1"]
                 [cljsjs/react-with-addons "0.13.3-0"]
                 [bidi "1.21.1"]
                 [xeric/om-test "1.0-SNAPSHOT"]
                 [kioo "0.4.1" :exclusions [om org.omcljs/om cljsjs/react]]
                 [org.omcljs/om "0.8.8" :exclusions [org.clojure/clojure
                                                     org.clojure.clojurescript
                                                     cljsjs/react]]]
  :target-path "target/%s"
  :plugins
  [[lein-cljsbuild "1.1.1"]
   [cider/cider-nrepl "0.9.0-20150616.120440-43" :exclusions [org.clojure/tools.nrepl]]
   [lein-doo "0.1.6-SNAPSHOT"]
   [lein-ancient "0.6.2"
    :exclusions [org.clojure/clojure org.clojure/tools.reader org.clojure/data.xml]]]

  :repositories
  [["releases" {:url "http://apps.xeric.net/nexus/content/repositories/releases"
               :username :env/xeric_repo_username
               :password :env/xeric_repo_password :checksum :ignore}]
  ["snapshots" {:url "http://apps.xeric.net/nexus/content/repositories/snapshots"
                :username :env/xeric_repo_username
                :password :env/xeric_repo_password :checksum :ignore}]]
  :doo {:paths {:phantom "scripts/phantomjs.sh"}}
  :cljsbuild {
              :builds [{:id "dev"
                        :source-paths ["src" "test"]
                        :compiler {
                                   :output-to "target/survey_cljs.js"
                                   :output-dir "target/out"
                                   :optimizations :none
                                   :source-map true}}

                       {:id "test"
                        :source-paths ["src" "test" "test-resources"]
                        :compiler {
                                   :output-dir "target/cljs/out"
                                   :output-to "target/cljs/testable.js"
                                   :optimizations :none
                                   :main 'om-stuff.test-runner
                                   :pretty-print true}}]})
