(ns metosin.system)

(defn invoke-lifecycle-fn [lifecycle-fn-name state subsys-ns]
  (let [s (symbol subsys-ns lifecycle-fn-name)]
    (if-let [f (resolve s)]
      (f state)
      (do
        (println "WARNING: Missing sub-system lifecycle function:" s)
        state))))

(defn start-subsystems! [system-state sub-systems & [initial-state]]
  (reset! system-state (reduce (partial invoke-lifecycle-fn "start-subsys!") (or initial-state {}) sub-systems)))

(defn stop-subsystems! [system-state sub-systems & [initial-state]]
  (reset! system-state (reduce (partial invoke-lifecycle-fn "stop-subsys!") (merge @system-state initial-state) (reverse sub-systems))))

(defmacro defsystem [subsys-nss]
  (doseq [missing (remove resolve (mapcat (fn [subsys-ns] [(symbol subsys-ns "start-subsys!") (symbol subsys-ns "stop-subsys!")]) (map name subsys-nss)))]
    (println "WARNING: Missing sub-system lifecycle function:" missing))
  `(do
     (def ~'system         ~(vec (map name subsys-nss)))
     (def ~'system-state   (atom nil))
     (def ~'start-system!  (partial start-subsystems! ~'system-state ~'system))
     (def ~'stop-system!   (partial stop-subsystems! ~'system-state ~'system))))
