(ns spec-tools.spec
  (:refer-clojure :exclude [any? some? number? integer? int? pos-int? neg-int? nat-int?
                            float? double? boolean? string? ident? simple-ident? qualified-ident?
                            keyword? simple-keyword? qualified-keyword? symbol? simple-symbol?
                            qualified-symbol? uuid? uri? bigdec? inst? seqable? indexed?
                            map? vector? list? seq? char? set? nil? false? true? zero?
                            rational? coll? empty? associative? sequential? ratio? bytes?
                            #?@(:cljs [Inst Keyword UUID])])
  (:require [spec-tools.core :as st]))

(def any? (st/spec clojure.core/any?))
(def some? (st/spec clojure.core/some?))
(def number? (st/spec clojure.core/number?))
(def integer? (st/spec clojure.core/integer?))
(def int? (st/spec clojure.core/int?))
(def pos-int? (st/spec clojure.core/pos-int?))
(def neg-int? (st/spec clojure.core/neg-int?))
(def nat-int? (st/spec clojure.core/nat-int?))
(def float? (st/spec clojure.core/float?))
(def double? (st/spec clojure.core/double?))
(def boolean? (st/spec clojure.core/boolean?))
(def string? (st/spec clojure.core/string?))
(def ident? (st/spec clojure.core/ident?))
(def simple-ident? (st/spec clojure.core/simple-ident?))
(def qualified-ident? (st/spec clojure.core/qualified-ident?))
(def keyword? (st/spec clojure.core/keyword?))
(def simple-keyword? (st/spec clojure.core/simple-keyword?))
(def qualified-keyword? (st/spec clojure.core/qualified-keyword?))
(def symbol? (st/spec clojure.core/symbol?))
(def simple-symbol? (st/spec clojure.core/simple-symbol?))
(def qualified-symbol? (st/spec clojure.core/qualified-symbol?))
(def uuid? (st/spec clojure.core/uuid?))
#?(:clj (def uri? (st/spec clojure.core/uri?)))
#?(:clj (def bigdec? (st/spec clojure.core/bigdec?)))
(def inst? (st/spec clojure.core/inst?))
(def seqable? (st/spec clojure.core/seqable?))
(def indexed? (st/spec clojure.core/indexed?))
(def map? (st/spec clojure.core/map?))
(def vector? (st/spec clojure.core/vector?))
(def list? (st/spec clojure.core/list?))
(def seq? (st/spec clojure.core/seq?))
(def char? (st/spec clojure.core/char?))
(def set? (st/spec clojure.core/set?))
(def nil? (st/spec clojure.core/nil?))
(def false? (st/spec clojure.core/false?))
(def true? (st/spec clojure.core/true?))
(def zero? (st/spec clojure.core/zero?))
#?(:clj (def rational? (st/spec clojure.core/rational?)))
(def coll? (st/spec clojure.core/coll?))
(def empty? (st/spec clojure.core/empty?))
(def associative? (st/spec clojure.core/associative?))
(def sequential? (st/spec clojure.core/sequential?))
#?(:clj (def ratio? (st/spec clojure.core/ratio?)))
#?(:clj (def bytes? (st/spec clojure.core/bytes?)))

;;
;; spec resolution
;;

(defmulti resolve-spec identity :default ::default)
(defmethod resolve-spec ::default [_] nil)

(defmethod resolve-spec clojure.core/any? [_] any?)
(defmethod resolve-spec clojure.core/some? [_] some?)
(defmethod resolve-spec clojure.core/number? [_] number?)
(defmethod resolve-spec clojure.core/integer? [_] integer?)
(defmethod resolve-spec clojure.core/int? [_] int?)
(defmethod resolve-spec clojure.core/pos-int? [_] pos-int?)
(defmethod resolve-spec clojure.core/neg-int? [_] neg-int?)
(defmethod resolve-spec clojure.core/nat-int? [_] nat-int?)
(defmethod resolve-spec clojure.core/float? [_] float?)
(defmethod resolve-spec clojure.core/double? [_] double?)
(defmethod resolve-spec clojure.core/boolean? [_] boolean?)
(defmethod resolve-spec clojure.core/string? [_] string?)
(defmethod resolve-spec clojure.core/ident? [_] ident?)
(defmethod resolve-spec clojure.core/simple-ident? [_] simple-ident?)
(defmethod resolve-spec clojure.core/qualified-ident? [_] qualified-ident?)
(defmethod resolve-spec clojure.core/keyword? [_] keyword?)
(defmethod resolve-spec clojure.core/simple-keyword? [_] simple-keyword?)
(defmethod resolve-spec clojure.core/qualified-keyword? [_] qualified-keyword?)
(defmethod resolve-spec clojure.core/symbol? [_] symbol?)
(defmethod resolve-spec clojure.core/simple-symbol? [_] simple-symbol?)
(defmethod resolve-spec clojure.core/qualified-symbol? [_] qualified-symbol?)
(defmethod resolve-spec clojure.core/uuid? [_] uuid?)
#?(:clj (defmethod resolve-spec clojure.core/uri? [_] uri?))
#?(:clj (defmethod resolve-spec clojure.core/bigdec? [_] bigdec?))
(defmethod resolve-spec clojure.core/inst? [_] inst?)
(defmethod resolve-spec clojure.core/seqable? [_] seqable?)
(defmethod resolve-spec clojure.core/indexed? [_] indexed?)
(defmethod resolve-spec clojure.core/map? [_] map?)
(defmethod resolve-spec clojure.core/vector? [_] vector?)
(defmethod resolve-spec clojure.core/list? [_] list?)
(defmethod resolve-spec clojure.core/seq? [_] seq?)
(defmethod resolve-spec clojure.core/char? [_] char?)
(defmethod resolve-spec clojure.core/set? [_] set?)
(defmethod resolve-spec clojure.core/nil? [_] nil?)
(defmethod resolve-spec clojure.core/false? [_] false?)
(defmethod resolve-spec clojure.core/true? [_] true?)
(defmethod resolve-spec clojure.core/zero? [_] zero?)
#?(:clj (defmethod resolve-spec clojure.core/rational? [_] rational?))
(defmethod resolve-spec clojure.core/coll? [_] coll?)
(defmethod resolve-spec clojure.core/empty? [_] empty?)
(defmethod resolve-spec clojure.core/associative? [_] associative?)
(defmethod resolve-spec clojure.core/sequential? [_] sequential?)
#?(:clj (defmethod resolve-spec clojure.core/ratio? [_] ratio?))
#?(:clj (defmethod resolve-spec clojure.core/bytes? [_] bytes?))
