(ns pohjavirta.util
  (:import (java.util.function Supplier)
           (clojure.lang IDeref)))

(set! *warn-on-reflection* true)

(defmacro thread-local [& body]
  `(let [tl# (ThreadLocal/withInitial
               (reify Supplier
                 (get [_] ~@body)))]
     (reify IDeref
       (deref [_] (.get tl#)))))
