(ns bat-test.main
  (:require [bat-test.api :as api]
            [clojure.java.io :as io]
            [clojure.tools.cli :as cli]
            [clojure.string :as str]
            [clojure.spec.alpha :as s]))

(def cli-opts
  [["-h" "--help"]
   ["-a" "--auto" "Enable file watcher"]
   [nil "--source-paths PATHS" "List of LESS source paths, comma separated"
    :default ["src"]
    :parse-fn (fn [x]
                (str/split x #","))]])

(defn help-text [options-summary]
(str "Run clojure.test tests.

Changed namespaces are reloaded using clojure.tools.namespace.
Only tests in changed or affected namespaces are run.

Usage: program-name [options]

Options:
" options-summary))

(defn -main [& args]
  (let [{:keys [options summary errors]} (cli/parse-opts args cli-opts)
        {:keys [help]} options]
    (cond
      errors (println (str/join "\n" errors))
      help (println (help-text summary))
      :else (api/build options))))

