/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class W3CDom {
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public org.w3c.dom.Document fromJsoup(Document in) {
        Validate.notNull(in);
        try {
            this.factory.setNamespaceAware(true);
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            org.w3c.dom.Document out = builder.newDocument();
            this.convert(in, out);
            return out;
        }
        catch (ParserConfigurationException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public void convert(Document in, org.w3c.dom.Document out) {
        if (!StringUtil.isBlank(in.location())) {
            out.setDocumentURI(in.location());
        }
        org.jsoup.nodes.Element rootEl = in.child(0);
        NodeTraversor.traverse((NodeVisitor)new W3CBuilder(out), rootEl);
    }

    public String asString(org.w3c.dom.Document doc2) {
        try {
            DOMSource domSource = new DOMSource(doc2);
            StringWriter writer2 = new StringWriter();
            StreamResult result = new StreamResult(writer2);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer2.toString();
        }
        catch (TransformerException e2) {
            throw new IllegalStateException(e2);
        }
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "xmlns";
        private static final String xmlnsPrefix = "xmlns:";
        private final org.w3c.dom.Document doc;
        private final Stack<HashMap<String, String>> namespacesStack = new Stack();
        private Element dest;

        public W3CBuilder(org.w3c.dom.Document doc2) {
            this.doc = doc2;
            this.namespacesStack.push(new HashMap());
        }

        @Override
        public void head(Node source2, int depth) {
            this.namespacesStack.push(new HashMap(this.namespacesStack.peek()));
            if (source2 instanceof org.jsoup.nodes.Element) {
                org.jsoup.nodes.Element sourceEl = (org.jsoup.nodes.Element)source2;
                String prefix = this.updateNamespaces(sourceEl);
                String namespace2 = this.namespacesStack.peek().get(prefix);
                Element el = this.doc.createElementNS(namespace2, sourceEl.tagName());
                this.copyAttributes(sourceEl, el);
                if (this.dest == null) {
                    this.doc.appendChild(el);
                } else {
                    this.dest.appendChild(el);
                }
                this.dest = el;
            } else if (source2 instanceof TextNode) {
                TextNode sourceText = (TextNode)source2;
                Text text = this.doc.createTextNode(sourceText.getWholeText());
                this.dest.appendChild(text);
            } else if (source2 instanceof org.jsoup.nodes.Comment) {
                org.jsoup.nodes.Comment sourceComment = (org.jsoup.nodes.Comment)source2;
                Comment comment2 = this.doc.createComment(sourceComment.getData());
                this.dest.appendChild(comment2);
            } else if (source2 instanceof DataNode) {
                DataNode sourceData = (DataNode)source2;
                Text node2 = this.doc.createTextNode(sourceData.getWholeData());
                this.dest.appendChild(node2);
            }
        }

        @Override
        public void tail(Node source2, int depth) {
            if (source2 instanceof org.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = (Element)this.dest.getParentNode();
            }
            this.namespacesStack.pop();
        }

        private void copyAttributes(Node source2, Element el) {
            for (Attribute attribute : source2.attributes()) {
                String key2 = attribute.getKey().replaceAll("[^-a-zA-Z0-9_:.]", "");
                if (!key2.matches("[a-zA-Z_:][-a-zA-Z0-9_:.]*")) continue;
                el.setAttribute(key2, attribute.getValue());
            }
        }

        private String updateNamespaces(org.jsoup.nodes.Element el) {
            Attributes attributes = el.attributes();
            for (Attribute attr : attributes) {
                String prefix;
                String key2 = attr.getKey();
                if (key2.equals(xmlnsKey)) {
                    prefix = "";
                } else {
                    if (!key2.startsWith(xmlnsPrefix)) continue;
                    prefix = key2.substring(xmlnsPrefix.length());
                }
                this.namespacesStack.peek().put(prefix, attr.getValue());
            }
            int pos = el.tagName().indexOf(":");
            return pos > 0 ? el.tagName().substring(0, pos) : "";
        }
    }
}

