/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.Stack;

public final class PathRecordingDependencyVisitor
implements DependencyVisitor {
    private final DependencyFilter filter;
    private final List<List<DependencyNode>> paths;
    private final Stack<DependencyNode> parents;
    private final Map<DependencyNode, Object> visited;
    private final boolean excludeChildrenOfMatches;

    public PathRecordingDependencyVisitor(DependencyFilter filter2) {
        this(filter2, true);
    }

    public PathRecordingDependencyVisitor(DependencyFilter filter2, boolean excludeChildrenOfMatches) {
        this.filter = filter2;
        this.excludeChildrenOfMatches = excludeChildrenOfMatches;
        this.paths = new ArrayList<List<DependencyNode>>();
        this.parents = new Stack();
        this.visited = new IdentityHashMap<DependencyNode, Object>(128);
    }

    public DependencyFilter getFilter() {
        return this.filter;
    }

    public List<List<DependencyNode>> getPaths() {
        return this.paths;
    }

    @Override
    public boolean visitEnter(DependencyNode node2) {
        boolean accept2 = this.filter == null || this.filter.accept(node2, this.parents);
        this.parents.push(node2);
        if (accept2) {
            DependencyNode[] path2 = new DependencyNode[this.parents.size()];
            int n = this.parents.size();
            for (int i = 0; i < n; ++i) {
                path2[n - i - 1] = this.parents.get(i);
            }
            this.paths.add(Arrays.asList(path2));
            if (this.excludeChildrenOfMatches) {
                return false;
            }
        }
        return this.visited.put(node2, Boolean.TRUE) == null;
    }

    @Override
    public boolean visitLeave(DependencyNode node2) {
        this.parents.pop();
        this.visited.remove(node2);
        return true;
    }
}

