/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.maven.wagon.TransferFailedException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlFileListParser {
    private static final Pattern APACHE_INDEX_SKIP = Pattern.compile("\\?[CDMNS]=.*");
    private static final Pattern URLS_WITH_PATHS = Pattern.compile("/[^/]*/");
    private static final Pattern URLS_TO_PARENT = Pattern.compile("\\.\\./");
    private static final Pattern MAILTO_URLS = Pattern.compile("mailto:.*");
    private static final Pattern[] SKIPS = new Pattern[]{APACHE_INDEX_SKIP, URLS_WITH_PATHS, URLS_TO_PARENT, MAILTO_URLS};

    public static List<String> parseFileList(String baseurl, InputStream stream) throws TransferFailedException {
        try {
            URI baseURI = new URI(baseurl);
            String content = IOUtils.toString(stream, "utf-8");
            Document doc2 = Jsoup.parse(content, baseurl);
            Elements links = doc2.select("a[href]");
            HashSet<String> results = new HashSet<String>();
            for (Element link : links) {
                String clean;
                String target = link.attr("href");
                if (target == null || !HtmlFileListParser.isAcceptableLink(clean = HtmlFileListParser.cleanLink(baseURI, target))) continue;
                results.add(clean);
            }
            return new ArrayList<String>(results);
        }
        catch (URISyntaxException e2) {
            throw new TransferFailedException("Unable to parse as base URI: " + baseurl, e2);
        }
        catch (IOException e3) {
            throw new TransferFailedException("I/O error reading HTML listing of artifacts: " + e3.getMessage(), e3);
        }
    }

    private static String cleanLink(URI baseURI, String link) {
        if (link == null || link.length() == 0) {
            return "";
        }
        String ret = link;
        try {
            URI relativeURI;
            URI linkuri = new URI(ret);
            if (link.startsWith("/")) {
                linkuri = baseURI.resolve(linkuri);
            }
            if ((ret = (relativeURI = baseURI.relativize(linkuri).normalize()).toASCIIString()).startsWith(baseURI.getPath())) {
                ret = ret.substring(baseURI.getPath().length());
            }
            ret = URLDecoder.decode(ret, "UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    private static boolean isAcceptableLink(String link) {
        if (link == null || link.length() == 0) {
            return false;
        }
        for (Pattern pattern : SKIPS) {
            if (!pattern.matcher(link).find()) continue;
            return false;
        }
        return true;
    }
}

