/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.xml.XMLEncode;
import org.apache.maven.shared.utils.xml.XMLWriter;

public class PrettyPrintXMLWriter
implements XMLWriter {
    private static final char[] CLOSE_1 = "/>".toCharArray();
    private static final char[] CLOSE_2 = "</".toCharArray();
    private static final char[] DEFAULT_LINE_INDENT = new char[]{' ', ' '};
    private PrintWriter writer;
    private ArrayList<String> elementStack = new ArrayList();
    private boolean processingElement = false;
    private boolean documentStarted = false;
    private boolean endOnSameLine = false;
    private int depth = 0;
    private char[] lineIndent;
    private char[] lineSeparator;
    private String encoding;
    private String docType;

    public PrettyPrintXMLWriter(PrintWriter writer2, String lineIndent) {
        this(writer2, lineIndent, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer2, String lineIndent) {
        this(new PrintWriter(writer2), lineIndent);
    }

    public PrettyPrintXMLWriter(PrintWriter writer2) {
        this(writer2, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer2) {
        this(new PrintWriter(writer2));
    }

    public PrettyPrintXMLWriter(PrintWriter writer2, String lineIndent, String encoding2, String doctype) {
        this(writer2, lineIndent.toCharArray(), Os.LINE_SEP.toCharArray(), encoding2, doctype);
    }

    public PrettyPrintXMLWriter(Writer writer2, String lineIndent, String encoding2, String doctype) {
        this(new PrintWriter(writer2), lineIndent, encoding2, doctype);
    }

    public PrettyPrintXMLWriter(PrintWriter writer2, String encoding2, String doctype) {
        this(writer2, DEFAULT_LINE_INDENT, Os.LINE_SEP.toCharArray(), encoding2, doctype);
    }

    public PrettyPrintXMLWriter(Writer writer2, String encoding2, String doctype) {
        this(new PrintWriter(writer2), encoding2, doctype);
    }

    public PrettyPrintXMLWriter(PrintWriter writer2, String lineIndent, String lineSeparator, String encoding2, String doctype) {
        this(writer2, lineIndent.toCharArray(), lineSeparator.toCharArray(), encoding2, doctype);
    }

    private PrettyPrintXMLWriter(PrintWriter writer2, char[] lineIndent, char[] lineSeparator, String encoding2, String doctype) {
        this.writer = writer2;
        this.lineIndent = lineIndent;
        this.lineSeparator = lineSeparator;
        this.encoding = encoding2;
        this.docType = doctype;
        this.depth = 0;
        assert (!writer2.checkError()) : "Unexpected error state PrintWriter passed to PrettyPrintXMLWriter.";
    }

    @Override
    public void addAttribute(String key2, String value) throws IOException {
        if (!this.processingElement) {
            throw new IllegalStateException("currently processing no element");
        }
        this.writer.write(32);
        this.writer.write(key2);
        this.writer.write(61);
        XMLEncode.xmlEncodeTextAsPCDATA(value, true, '\"', this.writer);
        if (this.writer.checkError()) {
            throw new IOException("Failure adding attribute '" + key2 + "' with value '" + value + "'");
        }
    }

    @Override
    public void setEncoding(String encoding2) {
        if (this.documentStarted) {
            throw new IllegalStateException("Document headers already written!");
        }
        this.encoding = encoding2;
    }

    @Override
    public void setDocType(String docType) {
        if (this.documentStarted) {
            throw new IllegalStateException("Document headers already written!");
        }
        this.docType = docType;
    }

    public void setLineSeparator(String lineSeparator) {
        if (this.documentStarted) {
            throw new IllegalStateException("Document headers already written!");
        }
        this.lineSeparator = lineSeparator.toCharArray();
    }

    public void setLineIndenter(String lineIndentParameter) {
        if (this.documentStarted) {
            throw new IllegalStateException("Document headers already written!");
        }
        this.lineIndent = lineIndentParameter.toCharArray();
    }

    @Override
    public void startElement(String elementName) throws IOException {
        boolean firstLine = this.ensureDocumentStarted();
        this.completePreviouslyOpenedElement();
        if (!firstLine) {
            this.newLine();
        }
        this.writer.write(60);
        this.writer.write(elementName);
        if (this.writer.checkError()) {
            throw new IOException("Failure starting element '" + elementName + "'.");
        }
        this.processingElement = true;
        this.elementStack.add(this.depth++, elementName);
    }

    @Override
    public void writeText(String text) throws IOException {
        this.ensureDocumentStarted();
        this.completePreviouslyOpenedElement();
        XMLEncode.xmlEncodeText(text, this.writer);
        this.endOnSameLine = true;
        if (this.writer.checkError()) {
            throw new IOException("Failure writing text.");
        }
    }

    @Override
    public void writeMarkup(String markup) throws IOException {
        this.ensureDocumentStarted();
        this.completePreviouslyOpenedElement();
        this.writer.write(markup);
        if (this.writer.checkError()) {
            throw new IOException("Failure writing markup.");
        }
    }

    @Override
    public void endElement() throws IOException {
        String chars2 = this.elementStack.get(--this.depth);
        if (this.processingElement) {
            this.writer.write(CLOSE_1);
            this.processingElement = false;
        } else {
            if (!this.endOnSameLine) {
                this.newLine();
            }
            this.writer.write(CLOSE_2);
            this.writer.write(chars2);
            this.writer.write(62);
        }
        this.endOnSameLine = false;
        if (this.writer.checkError()) {
            throw new IOException("Failure ending element.");
        }
    }

    private boolean ensureDocumentStarted() {
        if (!this.documentStarted) {
            if (this.docType != null || this.encoding != null) {
                this.writeDocumentHeader();
            }
            this.documentStarted = true;
            return true;
        }
        return false;
    }

    private void writeDocumentHeader() {
        this.writer.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.writer.write(" encoding=\"");
            this.writer.write(this.encoding);
            this.writer.write(34);
        }
        this.writer.write("?>");
        this.newLine();
        if (this.docType != null) {
            this.newLine();
            this.writer.write("<!DOCTYPE ");
            this.writer.write(this.docType);
            this.writer.write(62);
        }
    }

    private void newLine() {
        this.writer.write(this.lineSeparator);
        for (int i = 0; i < this.depth; ++i) {
            this.writer.write(this.lineIndent);
        }
    }

    private void completePreviouslyOpenedElement() {
        if (this.processingElement) {
            this.writer.write(62);
            this.processingElement = false;
        }
    }
}

