
# The beauty of oz markdown

Imagine you're writing a lovely little markdown file, when suddenly, you need a data visualization.

With oz, this magical code

    ```edn hiccup
    [:ul
     [:li "foo"]
     [:li "bar"]]
    ```

Turns into this

```edn hiccup
[:ul
 [:li "foo"]
 [:li "bar"]]
```

The real magic here is in the code class specification `edn vega-lite`.
It's possible to replace `edn` with `json`, and `vega` with `vega-lite` as appropriate.
Additionally, these classes can be hyphenated for compatibility with editors/parsers that have problems with multiple class specifications (e.g. `edn-vega-lite`)

Note that embedding all of your data into a vega/vega-lite spec directly as `:values` may be untenable for larger data sets.
In these cases, the recommended solution is to post your data to a GitHub gist, or elsewhere online where you can refer to it using the `:url` syntax (e.g. `{:data {:url "https://your.data.url/path"} ...}`).

