goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_27708 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_27708(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_27746 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_27746(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__26758 = coll;
var G__26759 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__26758,G__26759) : shadow.dom.lazy_native_coll_seq.call(null,G__26758,G__26759));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__26786 = arguments.length;
switch (G__26786) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__26789 = arguments.length;
switch (G__26789) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__26791 = arguments.length;
switch (G__26791) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__26793 = arguments.length;
switch (G__26793) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__26796 = arguments.length;
switch (G__26796) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__26800 = arguments.length;
switch (G__26800) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e26802){if((e26802 instanceof Object)){
var e = e26802;
return console.log("didnt support attachEvent",el,e);
} else {
throw e26802;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__26803 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__26804 = null;
var count__26805 = (0);
var i__26806 = (0);
while(true){
if((i__26806 < count__26805)){
var el = chunk__26804.cljs$core$IIndexed$_nth$arity$2(null,i__26806);
var handler_27816__$1 = ((function (seq__26803,chunk__26804,count__26805,i__26806,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__26803,chunk__26804,count__26805,i__26806,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_27816__$1);


var G__27819 = seq__26803;
var G__27820 = chunk__26804;
var G__27821 = count__26805;
var G__27822 = (i__26806 + (1));
seq__26803 = G__27819;
chunk__26804 = G__27820;
count__26805 = G__27821;
i__26806 = G__27822;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26803);
if(temp__5735__auto__){
var seq__26803__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26803__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__26803__$1);
var G__27831 = cljs.core.chunk_rest(seq__26803__$1);
var G__27832 = c__4556__auto__;
var G__27833 = cljs.core.count(c__4556__auto__);
var G__27834 = (0);
seq__26803 = G__27831;
chunk__26804 = G__27832;
count__26805 = G__27833;
i__26806 = G__27834;
continue;
} else {
var el = cljs.core.first(seq__26803__$1);
var handler_27836__$1 = ((function (seq__26803,chunk__26804,count__26805,i__26806,el,seq__26803__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__26803,chunk__26804,count__26805,i__26806,el,seq__26803__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_27836__$1);


var G__27838 = cljs.core.next(seq__26803__$1);
var G__27839 = null;
var G__27840 = (0);
var G__27841 = (0);
seq__26803 = G__27838;
chunk__26804 = G__27839;
count__26805 = G__27840;
i__26806 = G__27841;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__26814 = arguments.length;
switch (G__26814) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__26823 = cljs.core.seq(events);
var chunk__26824 = null;
var count__26825 = (0);
var i__26826 = (0);
while(true){
if((i__26826 < count__26825)){
var vec__26843 = chunk__26824.cljs$core$IIndexed$_nth$arity$2(null,i__26826);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26843,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26843,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__27860 = seq__26823;
var G__27861 = chunk__26824;
var G__27862 = count__26825;
var G__27863 = (i__26826 + (1));
seq__26823 = G__27860;
chunk__26824 = G__27861;
count__26825 = G__27862;
i__26826 = G__27863;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26823);
if(temp__5735__auto__){
var seq__26823__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26823__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__26823__$1);
var G__27866 = cljs.core.chunk_rest(seq__26823__$1);
var G__27867 = c__4556__auto__;
var G__27868 = cljs.core.count(c__4556__auto__);
var G__27869 = (0);
seq__26823 = G__27866;
chunk__26824 = G__27867;
count__26825 = G__27868;
i__26826 = G__27869;
continue;
} else {
var vec__26855 = cljs.core.first(seq__26823__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26855,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26855,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__27872 = cljs.core.next(seq__26823__$1);
var G__27873 = null;
var G__27874 = (0);
var G__27875 = (0);
seq__26823 = G__27872;
chunk__26824 = G__27873;
count__26825 = G__27874;
i__26826 = G__27875;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__26869 = cljs.core.seq(styles);
var chunk__26870 = null;
var count__26871 = (0);
var i__26872 = (0);
while(true){
if((i__26872 < count__26871)){
var vec__26895 = chunk__26870.cljs$core$IIndexed$_nth$arity$2(null,i__26872);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26895,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26895,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__27885 = seq__26869;
var G__27886 = chunk__26870;
var G__27887 = count__26871;
var G__27888 = (i__26872 + (1));
seq__26869 = G__27885;
chunk__26870 = G__27886;
count__26871 = G__27887;
i__26872 = G__27888;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__26869);
if(temp__5735__auto__){
var seq__26869__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26869__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__26869__$1);
var G__27893 = cljs.core.chunk_rest(seq__26869__$1);
var G__27894 = c__4556__auto__;
var G__27895 = cljs.core.count(c__4556__auto__);
var G__27896 = (0);
seq__26869 = G__27893;
chunk__26870 = G__27894;
count__26871 = G__27895;
i__26872 = G__27896;
continue;
} else {
var vec__26901 = cljs.core.first(seq__26869__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26901,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26901,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__27899 = cljs.core.next(seq__26869__$1);
var G__27900 = null;
var G__27901 = (0);
var G__27902 = (0);
seq__26869 = G__27899;
chunk__26870 = G__27900;
count__26871 = G__27901;
i__26872 = G__27902;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__26913_27905 = key;
var G__26913_27906__$1 = (((G__26913_27905 instanceof cljs.core.Keyword))?G__26913_27905.fqn:null);
switch (G__26913_27906__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_27929 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_27929,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_27929,"aria-");
}
})())){
el.setAttribute(ks_27929,value);
} else {
(el[ks_27929] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__26947){
var map__26948 = p__26947;
var map__26948__$1 = (((((!((map__26948 == null))))?(((((map__26948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26948.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26948):map__26948);
var props = map__26948__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26948__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__26950 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26950,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26950,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26950,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__26953 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__26953,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__26953;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__26956 = arguments.length;
switch (G__26956) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__26961){
var vec__26963 = p__26961;
var seq__26964 = cljs.core.seq(vec__26963);
var first__26965 = cljs.core.first(seq__26964);
var seq__26964__$1 = cljs.core.next(seq__26964);
var nn = first__26965;
var first__26965__$1 = cljs.core.first(seq__26964__$1);
var seq__26964__$2 = cljs.core.next(seq__26964__$1);
var np = first__26965__$1;
var nc = seq__26964__$2;
var node = vec__26963;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__26971 = nn;
var G__26972 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__26971,G__26972) : create_fn.call(null,G__26971,G__26972));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__26974 = nn;
var G__26975 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__26974,G__26975) : create_fn.call(null,G__26974,G__26975));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__26983 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26983,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26983,(1),null);
var seq__26986_27979 = cljs.core.seq(node_children);
var chunk__26987_27980 = null;
var count__26988_27981 = (0);
var i__26989_27982 = (0);
while(true){
if((i__26989_27982 < count__26988_27981)){
var child_struct_27983 = chunk__26987_27980.cljs$core$IIndexed$_nth$arity$2(null,i__26989_27982);
var children_27984 = shadow.dom.dom_node(child_struct_27983);
if(cljs.core.seq_QMARK_(children_27984)){
var seq__27046_27987 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_27984));
var chunk__27048_27988 = null;
var count__27049_27989 = (0);
var i__27050_27990 = (0);
while(true){
if((i__27050_27990 < count__27049_27989)){
var child_27991 = chunk__27048_27988.cljs$core$IIndexed$_nth$arity$2(null,i__27050_27990);
if(cljs.core.truth_(child_27991)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_27991);


var G__27992 = seq__27046_27987;
var G__27993 = chunk__27048_27988;
var G__27994 = count__27049_27989;
var G__27995 = (i__27050_27990 + (1));
seq__27046_27987 = G__27992;
chunk__27048_27988 = G__27993;
count__27049_27989 = G__27994;
i__27050_27990 = G__27995;
continue;
} else {
var G__27997 = seq__27046_27987;
var G__27998 = chunk__27048_27988;
var G__27999 = count__27049_27989;
var G__28000 = (i__27050_27990 + (1));
seq__27046_27987 = G__27997;
chunk__27048_27988 = G__27998;
count__27049_27989 = G__27999;
i__27050_27990 = G__28000;
continue;
}
} else {
var temp__5735__auto___28001 = cljs.core.seq(seq__27046_27987);
if(temp__5735__auto___28001){
var seq__27046_28002__$1 = temp__5735__auto___28001;
if(cljs.core.chunked_seq_QMARK_(seq__27046_28002__$1)){
var c__4556__auto___28004 = cljs.core.chunk_first(seq__27046_28002__$1);
var G__28005 = cljs.core.chunk_rest(seq__27046_28002__$1);
var G__28006 = c__4556__auto___28004;
var G__28007 = cljs.core.count(c__4556__auto___28004);
var G__28008 = (0);
seq__27046_27987 = G__28005;
chunk__27048_27988 = G__28006;
count__27049_27989 = G__28007;
i__27050_27990 = G__28008;
continue;
} else {
var child_28009 = cljs.core.first(seq__27046_28002__$1);
if(cljs.core.truth_(child_28009)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_28009);


var G__28010 = cljs.core.next(seq__27046_28002__$1);
var G__28011 = null;
var G__28012 = (0);
var G__28013 = (0);
seq__27046_27987 = G__28010;
chunk__27048_27988 = G__28011;
count__27049_27989 = G__28012;
i__27050_27990 = G__28013;
continue;
} else {
var G__28014 = cljs.core.next(seq__27046_28002__$1);
var G__28015 = null;
var G__28016 = (0);
var G__28017 = (0);
seq__27046_27987 = G__28014;
chunk__27048_27988 = G__28015;
count__27049_27989 = G__28016;
i__27050_27990 = G__28017;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_27984);
}


var G__28019 = seq__26986_27979;
var G__28020 = chunk__26987_27980;
var G__28021 = count__26988_27981;
var G__28022 = (i__26989_27982 + (1));
seq__26986_27979 = G__28019;
chunk__26987_27980 = G__28020;
count__26988_27981 = G__28021;
i__26989_27982 = G__28022;
continue;
} else {
var temp__5735__auto___28023 = cljs.core.seq(seq__26986_27979);
if(temp__5735__auto___28023){
var seq__26986_28024__$1 = temp__5735__auto___28023;
if(cljs.core.chunked_seq_QMARK_(seq__26986_28024__$1)){
var c__4556__auto___28026 = cljs.core.chunk_first(seq__26986_28024__$1);
var G__28027 = cljs.core.chunk_rest(seq__26986_28024__$1);
var G__28028 = c__4556__auto___28026;
var G__28029 = cljs.core.count(c__4556__auto___28026);
var G__28030 = (0);
seq__26986_27979 = G__28027;
chunk__26987_27980 = G__28028;
count__26988_27981 = G__28029;
i__26989_27982 = G__28030;
continue;
} else {
var child_struct_28031 = cljs.core.first(seq__26986_28024__$1);
var children_28032 = shadow.dom.dom_node(child_struct_28031);
if(cljs.core.seq_QMARK_(children_28032)){
var seq__27064_28033 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_28032));
var chunk__27066_28034 = null;
var count__27067_28035 = (0);
var i__27068_28036 = (0);
while(true){
if((i__27068_28036 < count__27067_28035)){
var child_28039 = chunk__27066_28034.cljs$core$IIndexed$_nth$arity$2(null,i__27068_28036);
if(cljs.core.truth_(child_28039)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_28039);


var G__28042 = seq__27064_28033;
var G__28043 = chunk__27066_28034;
var G__28044 = count__27067_28035;
var G__28045 = (i__27068_28036 + (1));
seq__27064_28033 = G__28042;
chunk__27066_28034 = G__28043;
count__27067_28035 = G__28044;
i__27068_28036 = G__28045;
continue;
} else {
var G__28046 = seq__27064_28033;
var G__28047 = chunk__27066_28034;
var G__28048 = count__27067_28035;
var G__28049 = (i__27068_28036 + (1));
seq__27064_28033 = G__28046;
chunk__27066_28034 = G__28047;
count__27067_28035 = G__28048;
i__27068_28036 = G__28049;
continue;
}
} else {
var temp__5735__auto___28052__$1 = cljs.core.seq(seq__27064_28033);
if(temp__5735__auto___28052__$1){
var seq__27064_28053__$1 = temp__5735__auto___28052__$1;
if(cljs.core.chunked_seq_QMARK_(seq__27064_28053__$1)){
var c__4556__auto___28054 = cljs.core.chunk_first(seq__27064_28053__$1);
var G__28057 = cljs.core.chunk_rest(seq__27064_28053__$1);
var G__28058 = c__4556__auto___28054;
var G__28059 = cljs.core.count(c__4556__auto___28054);
var G__28060 = (0);
seq__27064_28033 = G__28057;
chunk__27066_28034 = G__28058;
count__27067_28035 = G__28059;
i__27068_28036 = G__28060;
continue;
} else {
var child_28064 = cljs.core.first(seq__27064_28053__$1);
if(cljs.core.truth_(child_28064)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_28064);


var G__28067 = cljs.core.next(seq__27064_28053__$1);
var G__28068 = null;
var G__28069 = (0);
var G__28070 = (0);
seq__27064_28033 = G__28067;
chunk__27066_28034 = G__28068;
count__27067_28035 = G__28069;
i__27068_28036 = G__28070;
continue;
} else {
var G__28073 = cljs.core.next(seq__27064_28053__$1);
var G__28074 = null;
var G__28075 = (0);
var G__28076 = (0);
seq__27064_28033 = G__28073;
chunk__27066_28034 = G__28074;
count__27067_28035 = G__28075;
i__27068_28036 = G__28076;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_28032);
}


var G__28079 = cljs.core.next(seq__26986_28024__$1);
var G__28080 = null;
var G__28081 = (0);
var G__28082 = (0);
seq__26986_27979 = G__28079;
chunk__26987_27980 = G__28080;
count__26988_27981 = G__28081;
i__26989_27982 = G__28082;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__27079 = cljs.core.seq(node);
var chunk__27080 = null;
var count__27081 = (0);
var i__27082 = (0);
while(true){
if((i__27082 < count__27081)){
var n = chunk__27080.cljs$core$IIndexed$_nth$arity$2(null,i__27082);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__28096 = seq__27079;
var G__28097 = chunk__27080;
var G__28098 = count__27081;
var G__28099 = (i__27082 + (1));
seq__27079 = G__28096;
chunk__27080 = G__28097;
count__27081 = G__28098;
i__27082 = G__28099;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__27079);
if(temp__5735__auto__){
var seq__27079__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27079__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__27079__$1);
var G__28102 = cljs.core.chunk_rest(seq__27079__$1);
var G__28103 = c__4556__auto__;
var G__28104 = cljs.core.count(c__4556__auto__);
var G__28105 = (0);
seq__27079 = G__28102;
chunk__27080 = G__28103;
count__27081 = G__28104;
i__27082 = G__28105;
continue;
} else {
var n = cljs.core.first(seq__27079__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__28108 = cljs.core.next(seq__27079__$1);
var G__28109 = null;
var G__28110 = (0);
var G__28111 = (0);
seq__27079 = G__28108;
chunk__27080 = G__28109;
count__27081 = G__28110;
i__27082 = G__28111;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__27085 = arguments.length;
switch (G__27085) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__27087 = arguments.length;
switch (G__27087) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__27108 = arguments.length;
switch (G__27108) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28153 = arguments.length;
var i__4737__auto___28157 = (0);
while(true){
if((i__4737__auto___28157 < len__4736__auto___28153)){
args__4742__auto__.push((arguments[i__4737__auto___28157]));

var G__28159 = (i__4737__auto___28157 + (1));
i__4737__auto___28157 = G__28159;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__27134_28160 = cljs.core.seq(nodes);
var chunk__27135_28161 = null;
var count__27136_28162 = (0);
var i__27137_28163 = (0);
while(true){
if((i__27137_28163 < count__27136_28162)){
var node_28165 = chunk__27135_28161.cljs$core$IIndexed$_nth$arity$2(null,i__27137_28163);
fragment.appendChild(shadow.dom._to_dom(node_28165));


var G__28167 = seq__27134_28160;
var G__28168 = chunk__27135_28161;
var G__28169 = count__27136_28162;
var G__28170 = (i__27137_28163 + (1));
seq__27134_28160 = G__28167;
chunk__27135_28161 = G__28168;
count__27136_28162 = G__28169;
i__27137_28163 = G__28170;
continue;
} else {
var temp__5735__auto___28172 = cljs.core.seq(seq__27134_28160);
if(temp__5735__auto___28172){
var seq__27134_28173__$1 = temp__5735__auto___28172;
if(cljs.core.chunked_seq_QMARK_(seq__27134_28173__$1)){
var c__4556__auto___28174 = cljs.core.chunk_first(seq__27134_28173__$1);
var G__28175 = cljs.core.chunk_rest(seq__27134_28173__$1);
var G__28176 = c__4556__auto___28174;
var G__28177 = cljs.core.count(c__4556__auto___28174);
var G__28178 = (0);
seq__27134_28160 = G__28175;
chunk__27135_28161 = G__28176;
count__27136_28162 = G__28177;
i__27137_28163 = G__28178;
continue;
} else {
var node_28179 = cljs.core.first(seq__27134_28173__$1);
fragment.appendChild(shadow.dom._to_dom(node_28179));


var G__28180 = cljs.core.next(seq__27134_28173__$1);
var G__28181 = null;
var G__28182 = (0);
var G__28183 = (0);
seq__27134_28160 = G__28180;
chunk__27135_28161 = G__28181;
count__27136_28162 = G__28182;
i__27137_28163 = G__28183;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq27129){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27129));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__27153_28187 = cljs.core.seq(scripts);
var chunk__27154_28188 = null;
var count__27155_28189 = (0);
var i__27156_28190 = (0);
while(true){
if((i__27156_28190 < count__27155_28189)){
var vec__27168_28191 = chunk__27154_28188.cljs$core$IIndexed$_nth$arity$2(null,i__27156_28190);
var script_tag_28192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27168_28191,(0),null);
var script_body_28193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27168_28191,(1),null);
eval(script_body_28193);


var G__28195 = seq__27153_28187;
var G__28196 = chunk__27154_28188;
var G__28197 = count__27155_28189;
var G__28198 = (i__27156_28190 + (1));
seq__27153_28187 = G__28195;
chunk__27154_28188 = G__28196;
count__27155_28189 = G__28197;
i__27156_28190 = G__28198;
continue;
} else {
var temp__5735__auto___28199 = cljs.core.seq(seq__27153_28187);
if(temp__5735__auto___28199){
var seq__27153_28200__$1 = temp__5735__auto___28199;
if(cljs.core.chunked_seq_QMARK_(seq__27153_28200__$1)){
var c__4556__auto___28202 = cljs.core.chunk_first(seq__27153_28200__$1);
var G__28203 = cljs.core.chunk_rest(seq__27153_28200__$1);
var G__28204 = c__4556__auto___28202;
var G__28205 = cljs.core.count(c__4556__auto___28202);
var G__28206 = (0);
seq__27153_28187 = G__28203;
chunk__27154_28188 = G__28204;
count__27155_28189 = G__28205;
i__27156_28190 = G__28206;
continue;
} else {
var vec__27172_28208 = cljs.core.first(seq__27153_28200__$1);
var script_tag_28209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27172_28208,(0),null);
var script_body_28210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27172_28208,(1),null);
eval(script_body_28210);


var G__28211 = cljs.core.next(seq__27153_28200__$1);
var G__28212 = null;
var G__28213 = (0);
var G__28214 = (0);
seq__27153_28187 = G__28211;
chunk__27154_28188 = G__28212;
count__27155_28189 = G__28213;
i__27156_28190 = G__28214;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__27178){
var vec__27180 = p__27178;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27180,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27180,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__27193 = arguments.length;
switch (G__27193) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__27223 = cljs.core.seq(style_keys);
var chunk__27224 = null;
var count__27225 = (0);
var i__27226 = (0);
while(true){
if((i__27226 < count__27225)){
var it = chunk__27224.cljs$core$IIndexed$_nth$arity$2(null,i__27226);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__28229 = seq__27223;
var G__28230 = chunk__27224;
var G__28231 = count__27225;
var G__28232 = (i__27226 + (1));
seq__27223 = G__28229;
chunk__27224 = G__28230;
count__27225 = G__28231;
i__27226 = G__28232;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__27223);
if(temp__5735__auto__){
var seq__27223__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27223__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__27223__$1);
var G__28240 = cljs.core.chunk_rest(seq__27223__$1);
var G__28241 = c__4556__auto__;
var G__28242 = cljs.core.count(c__4556__auto__);
var G__28243 = (0);
seq__27223 = G__28240;
chunk__27224 = G__28241;
count__27225 = G__28242;
i__27226 = G__28243;
continue;
} else {
var it = cljs.core.first(seq__27223__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__28245 = cljs.core.next(seq__27223__$1);
var G__28246 = null;
var G__28247 = (0);
var G__28248 = (0);
seq__27223 = G__28245;
chunk__27224 = G__28246;
count__27225 = G__28247;
i__27226 = G__28248;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27232,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27244 = k27232;
var G__27244__$1 = (((G__27244 instanceof cljs.core.Keyword))?G__27244.fqn:null);
switch (G__27244__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27232,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__27249){
var vec__27251 = p__27249;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27251,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27251,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27231){
var self__ = this;
var G__27231__$1 = this;
return (new cljs.core.RecordIter((0),G__27231__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27233,other27234){
var self__ = this;
var this27233__$1 = this;
return (((!((other27234 == null)))) && ((this27233__$1.constructor === other27234.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27233__$1.x,other27234.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27233__$1.y,other27234.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27233__$1.__extmap,other27234.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27231){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27277 = cljs.core.keyword_identical_QMARK_;
var expr__27278 = k__4388__auto__;
if(cljs.core.truth_((pred__27277.cljs$core$IFn$_invoke$arity$2 ? pred__27277.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__27278) : pred__27277.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__27278)))){
return (new shadow.dom.Coordinate(G__27231,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__27277.cljs$core$IFn$_invoke$arity$2 ? pred__27277.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__27278) : pred__27277.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__27278)))){
return (new shadow.dom.Coordinate(self__.x,G__27231,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__27231),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27231){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__27231,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__27238){
var extmap__4419__auto__ = (function (){var G__27296 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27238,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__27238)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27296);
} else {
return G__27296;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__27238),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__27238),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27308,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27319 = k27308;
var G__27319__$1 = (((G__27319 instanceof cljs.core.Keyword))?G__27319.fqn:null);
switch (G__27319__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27308,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__27323){
var vec__27325 = p__27323;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27325,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27325,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27307){
var self__ = this;
var G__27307__$1 = this;
return (new cljs.core.RecordIter((0),G__27307__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27309,other27310){
var self__ = this;
var this27309__$1 = this;
return (((!((other27310 == null)))) && ((this27309__$1.constructor === other27310.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27309__$1.w,other27310.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27309__$1.h,other27310.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27309__$1.__extmap,other27310.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27307){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27332 = cljs.core.keyword_identical_QMARK_;
var expr__27333 = k__4388__auto__;
if(cljs.core.truth_((pred__27332.cljs$core$IFn$_invoke$arity$2 ? pred__27332.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__27333) : pred__27332.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__27333)))){
return (new shadow.dom.Size(G__27307,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__27332.cljs$core$IFn$_invoke$arity$2 ? pred__27332.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__27333) : pred__27332.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__27333)))){
return (new shadow.dom.Size(self__.w,G__27307,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__27307),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27307){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__27307,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__27311){
var extmap__4419__auto__ = (function (){var G__27336 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27311,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__27311)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27336);
} else {
return G__27336;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__27311),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__27311),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__28375 = (i + (1));
var G__28376 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__28375;
ret = G__28376;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__27356){
var vec__27357 = p__27356;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27357,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27357,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__27369 = arguments.length;
switch (G__27369) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__28384 = ps;
var G__28385 = (i + (1));
el__$1 = G__28384;
i = G__28385;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__27431 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27431,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27431,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27431,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__27437_28395 = cljs.core.seq(props);
var chunk__27438_28396 = null;
var count__27439_28397 = (0);
var i__27440_28398 = (0);
while(true){
if((i__27440_28398 < count__27439_28397)){
var vec__27472_28400 = chunk__27438_28396.cljs$core$IIndexed$_nth$arity$2(null,i__27440_28398);
var k_28401 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27472_28400,(0),null);
var v_28402 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27472_28400,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_28401);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_28401),v_28402);


var G__28406 = seq__27437_28395;
var G__28407 = chunk__27438_28396;
var G__28408 = count__27439_28397;
var G__28409 = (i__27440_28398 + (1));
seq__27437_28395 = G__28406;
chunk__27438_28396 = G__28407;
count__27439_28397 = G__28408;
i__27440_28398 = G__28409;
continue;
} else {
var temp__5735__auto___28413 = cljs.core.seq(seq__27437_28395);
if(temp__5735__auto___28413){
var seq__27437_28415__$1 = temp__5735__auto___28413;
if(cljs.core.chunked_seq_QMARK_(seq__27437_28415__$1)){
var c__4556__auto___28416 = cljs.core.chunk_first(seq__27437_28415__$1);
var G__28417 = cljs.core.chunk_rest(seq__27437_28415__$1);
var G__28418 = c__4556__auto___28416;
var G__28419 = cljs.core.count(c__4556__auto___28416);
var G__28420 = (0);
seq__27437_28395 = G__28417;
chunk__27438_28396 = G__28418;
count__27439_28397 = G__28419;
i__27440_28398 = G__28420;
continue;
} else {
var vec__27490_28421 = cljs.core.first(seq__27437_28415__$1);
var k_28422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27490_28421,(0),null);
var v_28423 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27490_28421,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_28422);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_28422),v_28423);


var G__28424 = cljs.core.next(seq__27437_28415__$1);
var G__28425 = null;
var G__28426 = (0);
var G__28427 = (0);
seq__27437_28395 = G__28424;
chunk__27438_28396 = G__28425;
count__27439_28397 = G__28426;
i__27440_28398 = G__28427;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__27506 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27506,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27506,(1),null);
var seq__27510_28429 = cljs.core.seq(node_children);
var chunk__27512_28430 = null;
var count__27513_28431 = (0);
var i__27514_28432 = (0);
while(true){
if((i__27514_28432 < count__27513_28431)){
var child_struct_28433 = chunk__27512_28430.cljs$core$IIndexed$_nth$arity$2(null,i__27514_28432);
if((!((child_struct_28433 == null)))){
if(typeof child_struct_28433 === 'string'){
var text_28437 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_28437),child_struct_28433].join(''));
} else {
var children_28439 = shadow.dom.svg_node(child_struct_28433);
if(cljs.core.seq_QMARK_(children_28439)){
var seq__27557_28442 = cljs.core.seq(children_28439);
var chunk__27559_28443 = null;
var count__27560_28444 = (0);
var i__27561_28445 = (0);
while(true){
if((i__27561_28445 < count__27560_28444)){
var child_28449 = chunk__27559_28443.cljs$core$IIndexed$_nth$arity$2(null,i__27561_28445);
if(cljs.core.truth_(child_28449)){
node.appendChild(child_28449);


var G__28451 = seq__27557_28442;
var G__28452 = chunk__27559_28443;
var G__28453 = count__27560_28444;
var G__28454 = (i__27561_28445 + (1));
seq__27557_28442 = G__28451;
chunk__27559_28443 = G__28452;
count__27560_28444 = G__28453;
i__27561_28445 = G__28454;
continue;
} else {
var G__28455 = seq__27557_28442;
var G__28456 = chunk__27559_28443;
var G__28457 = count__27560_28444;
var G__28458 = (i__27561_28445 + (1));
seq__27557_28442 = G__28455;
chunk__27559_28443 = G__28456;
count__27560_28444 = G__28457;
i__27561_28445 = G__28458;
continue;
}
} else {
var temp__5735__auto___28468 = cljs.core.seq(seq__27557_28442);
if(temp__5735__auto___28468){
var seq__27557_28472__$1 = temp__5735__auto___28468;
if(cljs.core.chunked_seq_QMARK_(seq__27557_28472__$1)){
var c__4556__auto___28473 = cljs.core.chunk_first(seq__27557_28472__$1);
var G__28474 = cljs.core.chunk_rest(seq__27557_28472__$1);
var G__28475 = c__4556__auto___28473;
var G__28476 = cljs.core.count(c__4556__auto___28473);
var G__28477 = (0);
seq__27557_28442 = G__28474;
chunk__27559_28443 = G__28475;
count__27560_28444 = G__28476;
i__27561_28445 = G__28477;
continue;
} else {
var child_28478 = cljs.core.first(seq__27557_28472__$1);
if(cljs.core.truth_(child_28478)){
node.appendChild(child_28478);


var G__28484 = cljs.core.next(seq__27557_28472__$1);
var G__28485 = null;
var G__28486 = (0);
var G__28487 = (0);
seq__27557_28442 = G__28484;
chunk__27559_28443 = G__28485;
count__27560_28444 = G__28486;
i__27561_28445 = G__28487;
continue;
} else {
var G__28488 = cljs.core.next(seq__27557_28472__$1);
var G__28489 = null;
var G__28490 = (0);
var G__28491 = (0);
seq__27557_28442 = G__28488;
chunk__27559_28443 = G__28489;
count__27560_28444 = G__28490;
i__27561_28445 = G__28491;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_28439);
}
}


var G__28492 = seq__27510_28429;
var G__28493 = chunk__27512_28430;
var G__28494 = count__27513_28431;
var G__28495 = (i__27514_28432 + (1));
seq__27510_28429 = G__28492;
chunk__27512_28430 = G__28493;
count__27513_28431 = G__28494;
i__27514_28432 = G__28495;
continue;
} else {
var G__28497 = seq__27510_28429;
var G__28498 = chunk__27512_28430;
var G__28499 = count__27513_28431;
var G__28500 = (i__27514_28432 + (1));
seq__27510_28429 = G__28497;
chunk__27512_28430 = G__28498;
count__27513_28431 = G__28499;
i__27514_28432 = G__28500;
continue;
}
} else {
var temp__5735__auto___28501 = cljs.core.seq(seq__27510_28429);
if(temp__5735__auto___28501){
var seq__27510_28502__$1 = temp__5735__auto___28501;
if(cljs.core.chunked_seq_QMARK_(seq__27510_28502__$1)){
var c__4556__auto___28504 = cljs.core.chunk_first(seq__27510_28502__$1);
var G__28505 = cljs.core.chunk_rest(seq__27510_28502__$1);
var G__28506 = c__4556__auto___28504;
var G__28507 = cljs.core.count(c__4556__auto___28504);
var G__28508 = (0);
seq__27510_28429 = G__28505;
chunk__27512_28430 = G__28506;
count__27513_28431 = G__28507;
i__27514_28432 = G__28508;
continue;
} else {
var child_struct_28509 = cljs.core.first(seq__27510_28502__$1);
if((!((child_struct_28509 == null)))){
if(typeof child_struct_28509 === 'string'){
var text_28511 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_28511),child_struct_28509].join(''));
} else {
var children_28512 = shadow.dom.svg_node(child_struct_28509);
if(cljs.core.seq_QMARK_(children_28512)){
var seq__27572_28513 = cljs.core.seq(children_28512);
var chunk__27574_28514 = null;
var count__27575_28515 = (0);
var i__27576_28516 = (0);
while(true){
if((i__27576_28516 < count__27575_28515)){
var child_28517 = chunk__27574_28514.cljs$core$IIndexed$_nth$arity$2(null,i__27576_28516);
if(cljs.core.truth_(child_28517)){
node.appendChild(child_28517);


var G__28519 = seq__27572_28513;
var G__28520 = chunk__27574_28514;
var G__28521 = count__27575_28515;
var G__28522 = (i__27576_28516 + (1));
seq__27572_28513 = G__28519;
chunk__27574_28514 = G__28520;
count__27575_28515 = G__28521;
i__27576_28516 = G__28522;
continue;
} else {
var G__28523 = seq__27572_28513;
var G__28524 = chunk__27574_28514;
var G__28525 = count__27575_28515;
var G__28526 = (i__27576_28516 + (1));
seq__27572_28513 = G__28523;
chunk__27574_28514 = G__28524;
count__27575_28515 = G__28525;
i__27576_28516 = G__28526;
continue;
}
} else {
var temp__5735__auto___28527__$1 = cljs.core.seq(seq__27572_28513);
if(temp__5735__auto___28527__$1){
var seq__27572_28528__$1 = temp__5735__auto___28527__$1;
if(cljs.core.chunked_seq_QMARK_(seq__27572_28528__$1)){
var c__4556__auto___28529 = cljs.core.chunk_first(seq__27572_28528__$1);
var G__28531 = cljs.core.chunk_rest(seq__27572_28528__$1);
var G__28532 = c__4556__auto___28529;
var G__28533 = cljs.core.count(c__4556__auto___28529);
var G__28534 = (0);
seq__27572_28513 = G__28531;
chunk__27574_28514 = G__28532;
count__27575_28515 = G__28533;
i__27576_28516 = G__28534;
continue;
} else {
var child_28535 = cljs.core.first(seq__27572_28528__$1);
if(cljs.core.truth_(child_28535)){
node.appendChild(child_28535);


var G__28536 = cljs.core.next(seq__27572_28528__$1);
var G__28537 = null;
var G__28538 = (0);
var G__28539 = (0);
seq__27572_28513 = G__28536;
chunk__27574_28514 = G__28537;
count__27575_28515 = G__28538;
i__27576_28516 = G__28539;
continue;
} else {
var G__28540 = cljs.core.next(seq__27572_28528__$1);
var G__28541 = null;
var G__28542 = (0);
var G__28543 = (0);
seq__27572_28513 = G__28540;
chunk__27574_28514 = G__28541;
count__27575_28515 = G__28542;
i__27576_28516 = G__28543;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_28512);
}
}


var G__28544 = cljs.core.next(seq__27510_28502__$1);
var G__28545 = null;
var G__28546 = (0);
var G__28547 = (0);
seq__27510_28429 = G__28544;
chunk__27512_28430 = G__28545;
count__27513_28431 = G__28546;
i__27514_28432 = G__28547;
continue;
} else {
var G__28548 = cljs.core.next(seq__27510_28502__$1);
var G__28549 = null;
var G__28550 = (0);
var G__28551 = (0);
seq__27510_28429 = G__28548;
chunk__27512_28430 = G__28549;
count__27513_28431 = G__28550;
i__27514_28432 = G__28551;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28560 = arguments.length;
var i__4737__auto___28561 = (0);
while(true){
if((i__4737__auto___28561 < len__4736__auto___28560)){
args__4742__auto__.push((arguments[i__4737__auto___28561]));

var G__28562 = (i__4737__auto___28561 + (1));
i__4737__auto___28561 = G__28562;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq27601){
var G__27603 = cljs.core.first(seq27601);
var seq27601__$1 = cljs.core.next(seq27601);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27603,seq27601__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__27614 = arguments.length;
switch (G__27614) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__26554__auto___28587 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__26555__auto__ = (function (){var switch__26370__auto__ = (function (state_27647){
var state_val_27651 = (state_27647[(1)]);
if((state_val_27651 === (1))){
var state_27647__$1 = state_27647;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27647__$1,(2),once_or_cleanup);
} else {
if((state_val_27651 === (2))){
var inst_27638 = (state_27647[(2)]);
var inst_27641 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_27647__$1 = (function (){var statearr_27663 = state_27647;
(statearr_27663[(7)] = inst_27638);

return statearr_27663;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27647__$1,inst_27641);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__26371__auto__ = null;
var shadow$dom$state_machine__26371__auto____0 = (function (){
var statearr_27666 = [null,null,null,null,null,null,null,null];
(statearr_27666[(0)] = shadow$dom$state_machine__26371__auto__);

(statearr_27666[(1)] = (1));

return statearr_27666;
});
var shadow$dom$state_machine__26371__auto____1 = (function (state_27647){
while(true){
var ret_value__26372__auto__ = (function (){try{while(true){
var result__26373__auto__ = switch__26370__auto__(state_27647);
if(cljs.core.keyword_identical_QMARK_(result__26373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26373__auto__;
}
break;
}
}catch (e27669){var ex__26374__auto__ = e27669;
var statearr_27672_28598 = state_27647;
(statearr_27672_28598[(2)] = ex__26374__auto__);


if(cljs.core.seq((state_27647[(4)]))){
var statearr_27675_28599 = state_27647;
(statearr_27675_28599[(1)] = cljs.core.first((state_27647[(4)])));

} else {
throw ex__26374__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28600 = state_27647;
state_27647 = G__28600;
continue;
} else {
return ret_value__26372__auto__;
}
break;
}
});
shadow$dom$state_machine__26371__auto__ = function(state_27647){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__26371__auto____0.call(this);
case 1:
return shadow$dom$state_machine__26371__auto____1.call(this,state_27647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__26371__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__26371__auto____0;
shadow$dom$state_machine__26371__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__26371__auto____1;
return shadow$dom$state_machine__26371__auto__;
})()
})();
var state__26556__auto__ = (function (){var statearr_27680 = f__26555__auto__();
(statearr_27680[(6)] = c__26554__auto___28587);

return statearr_27680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26556__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
