goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
goog.require('shadow.cljs.devtools.client.websocket');
goog.require('shadow.cljs.devtools.client.shared');
goog.require('shadow.remote.runtime.api');
goog.require('shadow.remote.runtime.shared');
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___35226 = arguments.length;
var i__4737__auto___35227 = (0);
while(true){
if((i__4737__auto___35227 < len__4736__auto___35226)){
args__4742__auto__.push((arguments[i__4737__auto___35227]));

var G__35228 = (i__4737__auto___35227 + (1));
i__4737__auto___35227 = G__35228;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
if(cljs.core.seq(shadow.cljs.devtools.client.env.log_style)){
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%cshadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),shadow.cljs.devtools.client.env.log_style], null),args)));
} else {
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('')], null),args)));
}
}));

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq35078){
var G__35079 = cljs.core.first(seq35078);
var seq35078__$1 = cljs.core.next(seq35078);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35079,seq35078__$1);
}));

shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__35081 = cljs.core.seq(sources);
var chunk__35082 = null;
var count__35083 = (0);
var i__35084 = (0);
while(true){
if((i__35084 < count__35083)){
var map__35099 = chunk__35082.cljs$core$IIndexed$_nth$arity$2(null,i__35084);
var map__35099__$1 = (((((!((map__35099 == null))))?(((((map__35099.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35099.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35099):map__35099);
var src = map__35099__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35099__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35099__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35099__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35099__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e35101){var e_35229 = e35101;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_35229);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_35229.message)].join('')));
}

var G__35230 = seq__35081;
var G__35231 = chunk__35082;
var G__35232 = count__35083;
var G__35233 = (i__35084 + (1));
seq__35081 = G__35230;
chunk__35082 = G__35231;
count__35083 = G__35232;
i__35084 = G__35233;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__35081);
if(temp__5735__auto__){
var seq__35081__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35081__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__35081__$1);
var G__35234 = cljs.core.chunk_rest(seq__35081__$1);
var G__35235 = c__4556__auto__;
var G__35236 = cljs.core.count(c__4556__auto__);
var G__35237 = (0);
seq__35081 = G__35234;
chunk__35082 = G__35235;
count__35083 = G__35236;
i__35084 = G__35237;
continue;
} else {
var map__35102 = cljs.core.first(seq__35081__$1);
var map__35102__$1 = (((((!((map__35102 == null))))?(((((map__35102.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35102.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35102):map__35102);
var src = map__35102__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35102__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35102__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35102__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35102__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e35104){var e_35238 = e35104;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_35238);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_35238.message)].join('')));
}

var G__35239 = cljs.core.next(seq__35081__$1);
var G__35240 = null;
var G__35241 = (0);
var G__35242 = (0);
seq__35081 = G__35239;
chunk__35082 = G__35240;
count__35083 = G__35241;
i__35084 = G__35242;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return null;
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__35106 = cljs.core.seq(js_requires);
var chunk__35107 = null;
var count__35108 = (0);
var i__35109 = (0);
while(true){
if((i__35109 < count__35108)){
var js_ns = chunk__35107.cljs$core$IIndexed$_nth$arity$2(null,i__35109);
var require_str_35243 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_35243);


var G__35244 = seq__35106;
var G__35245 = chunk__35107;
var G__35246 = count__35108;
var G__35247 = (i__35109 + (1));
seq__35106 = G__35244;
chunk__35107 = G__35245;
count__35108 = G__35246;
i__35109 = G__35247;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__35106);
if(temp__5735__auto__){
var seq__35106__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35106__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__35106__$1);
var G__35248 = cljs.core.chunk_rest(seq__35106__$1);
var G__35249 = c__4556__auto__;
var G__35250 = cljs.core.count(c__4556__auto__);
var G__35251 = (0);
seq__35106 = G__35248;
chunk__35107 = G__35249;
count__35108 = G__35250;
i__35109 = G__35251;
continue;
} else {
var js_ns = cljs.core.first(seq__35106__$1);
var require_str_35252 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_35252);


var G__35253 = cljs.core.next(seq__35106__$1);
var G__35254 = null;
var G__35255 = (0);
var G__35256 = (0);
seq__35106 = G__35253;
chunk__35107 = G__35254;
count__35108 = G__35255;
i__35109 = G__35256;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(runtime,p__35111){
var map__35112 = p__35111;
var map__35112__$1 = (((((!((map__35112 == null))))?(((((map__35112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35112.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35112):map__35112);
var msg = map__35112__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35112__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35112__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4529__auto__ = (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35114(s__35115){
return (new cljs.core.LazySeq(null,(function (){
var s__35115__$1 = s__35115;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__35115__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var map__35120 = cljs.core.first(xs__6292__auto__);
var map__35120__$1 = (((((!((map__35120 == null))))?(((((map__35120.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35120.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35120):map__35120);
var src = map__35120__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35120__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35120__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4525__auto__ = ((function (s__35115__$1,map__35120,map__35120__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__35112,map__35112__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35114_$_iter__35116(s__35117){
return (new cljs.core.LazySeq(null,((function (s__35115__$1,map__35120,map__35120__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__35112,map__35112__$1,msg,info,reload_info){
return (function (){
var s__35117__$1 = s__35117;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__35117__$1);
if(temp__5735__auto____$1){
var s__35117__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__35117__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__35117__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__35119 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__35118 = (0);
while(true){
if((i__35118 < size__4528__auto__)){
var warning = cljs.core._nth(c__4527__auto__,i__35118);
cljs.core.chunk_append(b__35119,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__35257 = (i__35118 + (1));
i__35118 = G__35257;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35119),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35114_$_iter__35116(cljs.core.chunk_rest(s__35117__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35119),null);
}
} else {
var warning = cljs.core.first(s__35117__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35114_$_iter__35116(cljs.core.rest(s__35117__$2)));
}
} else {
return null;
}
break;
}
});})(s__35115__$1,map__35120,map__35120__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__35112,map__35112__$1,msg,info,reload_info))
,null,null));
});})(s__35115__$1,map__35120,map__35120__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__35112,map__35112__$1,msg,info,reload_info))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(warnings));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35114(cljs.core.rest(s__35115__$1)));
} else {
var G__35258 = cljs.core.rest(s__35115__$1);
s__35115__$1 = G__35258;
continue;
}
} else {
var G__35259 = cljs.core.rest(s__35115__$1);
s__35115__$1 = G__35259;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(info));
})()));
var seq__35122_35260 = cljs.core.seq(warnings);
var chunk__35123_35261 = null;
var count__35124_35262 = (0);
var i__35125_35263 = (0);
while(true){
if((i__35125_35263 < count__35124_35262)){
var map__35131_35264 = chunk__35123_35261.cljs$core$IIndexed$_nth$arity$2(null,i__35125_35263);
var map__35131_35265__$1 = (((((!((map__35131_35264 == null))))?(((((map__35131_35264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35131_35264.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35131_35264):map__35131_35264);
var w_35266 = map__35131_35265__$1;
var msg_35267__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35131_35265__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_35268 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35131_35265__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_35269 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35131_35265__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_35270 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35131_35265__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_35270)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_35268),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_35269),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_35267__$1)].join(''));


var G__35271 = seq__35122_35260;
var G__35272 = chunk__35123_35261;
var G__35273 = count__35124_35262;
var G__35274 = (i__35125_35263 + (1));
seq__35122_35260 = G__35271;
chunk__35123_35261 = G__35272;
count__35124_35262 = G__35273;
i__35125_35263 = G__35274;
continue;
} else {
var temp__5735__auto___35275 = cljs.core.seq(seq__35122_35260);
if(temp__5735__auto___35275){
var seq__35122_35276__$1 = temp__5735__auto___35275;
if(cljs.core.chunked_seq_QMARK_(seq__35122_35276__$1)){
var c__4556__auto___35277 = cljs.core.chunk_first(seq__35122_35276__$1);
var G__35278 = cljs.core.chunk_rest(seq__35122_35276__$1);
var G__35279 = c__4556__auto___35277;
var G__35280 = cljs.core.count(c__4556__auto___35277);
var G__35281 = (0);
seq__35122_35260 = G__35278;
chunk__35123_35261 = G__35279;
count__35124_35262 = G__35280;
i__35125_35263 = G__35281;
continue;
} else {
var map__35133_35282 = cljs.core.first(seq__35122_35276__$1);
var map__35133_35283__$1 = (((((!((map__35133_35282 == null))))?(((((map__35133_35282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35133_35282.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35133_35282):map__35133_35282);
var w_35284 = map__35133_35283__$1;
var msg_35285__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35133_35283__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_35286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35133_35283__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_35287 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35133_35283__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_35288 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35133_35283__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_35288)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_35286),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_35287),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_35285__$1)].join(''));


var G__35289 = cljs.core.next(seq__35122_35276__$1);
var G__35290 = null;
var G__35291 = (0);
var G__35292 = (0);
seq__35122_35260 = G__35289;
chunk__35123_35261 = G__35290;
count__35124_35262 = G__35291;
i__35125_35263 = G__35292;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = shadow.cljs.devtools.client.env.filter_reload_sources(info,reload_info);
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(cljs.core.seq(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("reloading code but no :after-load hooks are configured!",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks"], 0));
}

return shadow.cljs.devtools.client.shared.load_sources(runtime,sources_to_get,(function (p1__35110_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__35110_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
}));
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(new$,(1));
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old,rel_new)) || (clojure.string.starts_with_QMARK_(old,[rel_new,"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not(node_uri.hasDomain())))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs,new$)){
return new$;
} else {
return false;
}
} else {
return false;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_update = (function shadow$cljs$devtools$client$browser$handle_asset_update(p__35135){
var map__35136 = p__35135;
var map__35136__$1 = (((((!((map__35136 == null))))?(((((map__35136.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35136.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35136):map__35136);
var msg = map__35136__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35136__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__35138 = cljs.core.seq(updates);
var chunk__35140 = null;
var count__35141 = (0);
var i__35142 = (0);
while(true){
if((i__35142 < count__35141)){
var path = chunk__35140.cljs$core$IIndexed$_nth$arity$2(null,i__35142);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__35170_35293 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__35173_35294 = null;
var count__35174_35295 = (0);
var i__35175_35296 = (0);
while(true){
if((i__35175_35296 < count__35174_35295)){
var node_35297 = chunk__35173_35294.cljs$core$IIndexed$_nth$arity$2(null,i__35175_35296);
var path_match_35298 = shadow.cljs.devtools.client.browser.match_paths(node_35297.getAttribute("href"),path);
if(cljs.core.truth_(path_match_35298)){
var new_link_35299 = (function (){var G__35180 = node_35297.cloneNode(true);
G__35180.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_35298),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__35180;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_35298], 0));

goog.dom.insertSiblingAfter(new_link_35299,node_35297);

goog.dom.removeNode(node_35297);


var G__35300 = seq__35170_35293;
var G__35301 = chunk__35173_35294;
var G__35302 = count__35174_35295;
var G__35303 = (i__35175_35296 + (1));
seq__35170_35293 = G__35300;
chunk__35173_35294 = G__35301;
count__35174_35295 = G__35302;
i__35175_35296 = G__35303;
continue;
} else {
var G__35304 = seq__35170_35293;
var G__35305 = chunk__35173_35294;
var G__35306 = count__35174_35295;
var G__35307 = (i__35175_35296 + (1));
seq__35170_35293 = G__35304;
chunk__35173_35294 = G__35305;
count__35174_35295 = G__35306;
i__35175_35296 = G__35307;
continue;
}
} else {
var temp__5735__auto___35308 = cljs.core.seq(seq__35170_35293);
if(temp__5735__auto___35308){
var seq__35170_35309__$1 = temp__5735__auto___35308;
if(cljs.core.chunked_seq_QMARK_(seq__35170_35309__$1)){
var c__4556__auto___35310 = cljs.core.chunk_first(seq__35170_35309__$1);
var G__35311 = cljs.core.chunk_rest(seq__35170_35309__$1);
var G__35312 = c__4556__auto___35310;
var G__35313 = cljs.core.count(c__4556__auto___35310);
var G__35314 = (0);
seq__35170_35293 = G__35311;
chunk__35173_35294 = G__35312;
count__35174_35295 = G__35313;
i__35175_35296 = G__35314;
continue;
} else {
var node_35315 = cljs.core.first(seq__35170_35309__$1);
var path_match_35316 = shadow.cljs.devtools.client.browser.match_paths(node_35315.getAttribute("href"),path);
if(cljs.core.truth_(path_match_35316)){
var new_link_35317 = (function (){var G__35181 = node_35315.cloneNode(true);
G__35181.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_35316),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__35181;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_35316], 0));

goog.dom.insertSiblingAfter(new_link_35317,node_35315);

goog.dom.removeNode(node_35315);


var G__35318 = cljs.core.next(seq__35170_35309__$1);
var G__35319 = null;
var G__35320 = (0);
var G__35321 = (0);
seq__35170_35293 = G__35318;
chunk__35173_35294 = G__35319;
count__35174_35295 = G__35320;
i__35175_35296 = G__35321;
continue;
} else {
var G__35322 = cljs.core.next(seq__35170_35309__$1);
var G__35323 = null;
var G__35324 = (0);
var G__35325 = (0);
seq__35170_35293 = G__35322;
chunk__35173_35294 = G__35323;
count__35174_35295 = G__35324;
i__35175_35296 = G__35325;
continue;
}
}
} else {
}
}
break;
}


var G__35326 = seq__35138;
var G__35327 = chunk__35140;
var G__35328 = count__35141;
var G__35329 = (i__35142 + (1));
seq__35138 = G__35326;
chunk__35140 = G__35327;
count__35141 = G__35328;
i__35142 = G__35329;
continue;
} else {
var G__35330 = seq__35138;
var G__35331 = chunk__35140;
var G__35332 = count__35141;
var G__35333 = (i__35142 + (1));
seq__35138 = G__35330;
chunk__35140 = G__35331;
count__35141 = G__35332;
i__35142 = G__35333;
continue;
}
} else {
var temp__5735__auto__ = cljs.core.seq(seq__35138);
if(temp__5735__auto__){
var seq__35138__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35138__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__35138__$1);
var G__35334 = cljs.core.chunk_rest(seq__35138__$1);
var G__35335 = c__4556__auto__;
var G__35336 = cljs.core.count(c__4556__auto__);
var G__35337 = (0);
seq__35138 = G__35334;
chunk__35140 = G__35335;
count__35141 = G__35336;
i__35142 = G__35337;
continue;
} else {
var path = cljs.core.first(seq__35138__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__35182_35338 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__35185_35339 = null;
var count__35186_35340 = (0);
var i__35187_35341 = (0);
while(true){
if((i__35187_35341 < count__35186_35340)){
var node_35342 = chunk__35185_35339.cljs$core$IIndexed$_nth$arity$2(null,i__35187_35341);
var path_match_35343 = shadow.cljs.devtools.client.browser.match_paths(node_35342.getAttribute("href"),path);
if(cljs.core.truth_(path_match_35343)){
var new_link_35344 = (function (){var G__35192 = node_35342.cloneNode(true);
G__35192.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_35343),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__35192;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_35343], 0));

goog.dom.insertSiblingAfter(new_link_35344,node_35342);

goog.dom.removeNode(node_35342);


var G__35345 = seq__35182_35338;
var G__35346 = chunk__35185_35339;
var G__35347 = count__35186_35340;
var G__35348 = (i__35187_35341 + (1));
seq__35182_35338 = G__35345;
chunk__35185_35339 = G__35346;
count__35186_35340 = G__35347;
i__35187_35341 = G__35348;
continue;
} else {
var G__35349 = seq__35182_35338;
var G__35350 = chunk__35185_35339;
var G__35351 = count__35186_35340;
var G__35352 = (i__35187_35341 + (1));
seq__35182_35338 = G__35349;
chunk__35185_35339 = G__35350;
count__35186_35340 = G__35351;
i__35187_35341 = G__35352;
continue;
}
} else {
var temp__5735__auto___35353__$1 = cljs.core.seq(seq__35182_35338);
if(temp__5735__auto___35353__$1){
var seq__35182_35354__$1 = temp__5735__auto___35353__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35182_35354__$1)){
var c__4556__auto___35355 = cljs.core.chunk_first(seq__35182_35354__$1);
var G__35356 = cljs.core.chunk_rest(seq__35182_35354__$1);
var G__35357 = c__4556__auto___35355;
var G__35358 = cljs.core.count(c__4556__auto___35355);
var G__35359 = (0);
seq__35182_35338 = G__35356;
chunk__35185_35339 = G__35357;
count__35186_35340 = G__35358;
i__35187_35341 = G__35359;
continue;
} else {
var node_35360 = cljs.core.first(seq__35182_35354__$1);
var path_match_35361 = shadow.cljs.devtools.client.browser.match_paths(node_35360.getAttribute("href"),path);
if(cljs.core.truth_(path_match_35361)){
var new_link_35362 = (function (){var G__35193 = node_35360.cloneNode(true);
G__35193.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_35361),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__35193;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_35361], 0));

goog.dom.insertSiblingAfter(new_link_35362,node_35360);

goog.dom.removeNode(node_35360);


var G__35363 = cljs.core.next(seq__35182_35354__$1);
var G__35364 = null;
var G__35365 = (0);
var G__35366 = (0);
seq__35182_35338 = G__35363;
chunk__35185_35339 = G__35364;
count__35186_35340 = G__35365;
i__35187_35341 = G__35366;
continue;
} else {
var G__35367 = cljs.core.next(seq__35182_35354__$1);
var G__35368 = null;
var G__35369 = (0);
var G__35370 = (0);
seq__35182_35338 = G__35367;
chunk__35185_35339 = G__35368;
count__35186_35340 = G__35369;
i__35187_35341 = G__35370;
continue;
}
}
} else {
}
}
break;
}


var G__35371 = cljs.core.next(seq__35138__$1);
var G__35372 = null;
var G__35373 = (0);
var G__35374 = (0);
seq__35138 = G__35371;
chunk__35140 = G__35372;
count__35141 = G__35373;
i__35142 = G__35374;
continue;
} else {
var G__35375 = cljs.core.next(seq__35138__$1);
var G__35376 = null;
var G__35377 = (0);
var G__35378 = (0);
seq__35138 = G__35375;
chunk__35140 = G__35376;
count__35141 = G__35377;
i__35142 = G__35378;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.global_eval = (function shadow$cljs$devtools$client$browser$global_eval(js){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("undefined",typeof(module))){
return eval(js);
} else {
return (0,eval)(js);;
}
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(runtime,p__35194){
var map__35195 = p__35194;
var map__35195__$1 = (((((!((map__35195 == null))))?(((((map__35195.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35195.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35195):map__35195);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35195__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
return shadow.cljs.devtools.client.shared.load_sources(runtime,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),(function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

return shadow.cljs.devtools.client.browser.devtools_msg("ready!");
}));
});
shadow.cljs.devtools.client.browser.client_info = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"host","host",-1558485167),(cljs.core.truth_(goog.global.document)?new cljs.core.Keyword(null,"browser","browser",828191719):new cljs.core.Keyword(null,"browser-worker","browser-worker",1638998282)),new cljs.core.Keyword(null,"user-agent","user-agent",1220426212),[(cljs.core.truth_(goog.userAgent.OPERA)?"Opera":(cljs.core.truth_(goog.userAgent.product.CHROME)?"Chrome":(cljs.core.truth_(goog.userAgent.IE)?"MSIE":(cljs.core.truth_(goog.userAgent.EDGE)?"Edge":(cljs.core.truth_(goog.userAgent.GECKO)?"Firefox":(cljs.core.truth_(goog.userAgent.SAFARI)?"Safari":(cljs.core.truth_(goog.userAgent.WEBKIT)?"Webkit":null)))))))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.userAgent.VERSION)," [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.userAgent.PLATFORM),"]"].join(''),new cljs.core.Keyword(null,"dom","dom",-1236537922),(!((goog.global.document == null)))], null);
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.ws_was_welcome_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.ws_was_welcome_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
}
if(((shadow.cljs.devtools.client.env.enabled) && ((shadow.cljs.devtools.client.env.worker_client_id > (0))))){
(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$remote$runtime$api$IEvalJS$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$remote$runtime$api$IEvalJS$_js_eval$arity$2 = (function (this$,code){
var this$__$1 = this;
return shadow.cljs.devtools.client.browser.global_eval(code);
}));

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$cljs$devtools$client$shared$IHostSpecific$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$cljs$devtools$client$shared$IHostSpecific$do_invoke$arity$2 = (function (this$,p__35197){
var map__35198 = p__35197;
var map__35198__$1 = (((((!((map__35198 == null))))?(((((map__35198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35198.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35198):map__35198);
var _ = map__35198__$1;
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35198__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var this$__$1 = this;
return shadow.cljs.devtools.client.browser.global_eval(js);
}));

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$cljs$devtools$client$shared$IHostSpecific$do_repl_init$arity$4 = (function (runtime,p__35200,done,error){
var map__35201 = p__35200;
var map__35201__$1 = (((((!((map__35201 == null))))?(((((map__35201.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35201.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35201):map__35201);
var repl_sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35201__$1,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535));
var runtime__$1 = this;
return shadow.cljs.devtools.client.shared.load_sources(runtime__$1,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_,repl_sources)),(function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}));
}));

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$cljs$devtools$client$shared$IHostSpecific$do_repl_require$arity$4 = (function (runtime,p__35203,done,error){
var map__35204 = p__35203;
var map__35204__$1 = (((((!((map__35204 == null))))?(((((map__35204.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35204.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35204):map__35204);
var msg = map__35204__$1;
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35204__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35204__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35204__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var runtime__$1 = this;
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__35206){
var map__35207 = p__35206;
var map__35207__$1 = (((((!((map__35207 == null))))?(((((map__35207.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35207.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35207):map__35207);
var src = map__35207__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35207__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4115__auto__ = shadow.cljs.devtools.client.env.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__4115__auto__;
}
}),sources));
if(cljs.core.not(cljs.core.seq(sources_to_load))){
var G__35209 = cljs.core.PersistentVector.EMPTY;
return (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(G__35209) : done.call(null,G__35209));
} else {
return shadow.remote.runtime.shared.call.cljs$core$IFn$_invoke$arity$3(runtime__$1,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"cljs-load-sources","cljs-load-sources",-1458295962),new cljs.core.Keyword(null,"to","to",192099007),shadow.cljs.devtools.client.env.worker_client_id,new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources_to_load)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cljs-sources","cljs-sources",31121610),(function (p__35210){
var map__35211 = p__35210;
var map__35211__$1 = (((((!((map__35211 == null))))?(((((map__35211.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35211.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35211):map__35211);
var msg__$1 = map__35211__$1;
var sources__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35211__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
try{shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(sources_to_load) : done.call(null,sources_to_load));
}catch (e35213){var ex = e35213;
return (error.cljs$core$IFn$_invoke$arity$1 ? error.cljs$core$IFn$_invoke$arity$1(ex) : error.call(null,ex));
}})], null));
}
}));

shadow.cljs.devtools.client.shared.add_plugin_BANG_(new cljs.core.Keyword("shadow.cljs.devtools.client.browser","client","shadow.cljs.devtools.client.browser/client",-1461019282),cljs.core.PersistentHashSet.EMPTY,(function (p__35214){
var map__35215 = p__35214;
var map__35215__$1 = (((((!((map__35215 == null))))?(((((map__35215.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35215.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35215):map__35215);
var env = map__35215__$1;
var runtime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35215__$1,new cljs.core.Keyword(null,"runtime","runtime",-1331573996));
var svc = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"runtime","runtime",-1331573996),runtime], null);
shadow.remote.runtime.api.add_extension(runtime,new cljs.core.Keyword("shadow.cljs.devtools.client.browser","client","shadow.cljs.devtools.client.browser/client",-1461019282),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-welcome","on-welcome",1895317125),(function (){
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.ws_was_welcome_ref,true);

shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

shadow.cljs.devtools.client.env.patch_goog_BANG_();

return shadow.cljs.devtools.client.browser.devtools_msg(["#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state-ref","state-ref",2127874952).cljs$core$IFn$_invoke$arity$1(runtime))))," ready!"].join(''));
}),new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814),(function (e){
if(cljs.core.truth_(cljs.core.deref(shadow.cljs.devtools.client.browser.ws_was_welcome_ref))){
shadow.cljs.devtools.client.hud.connection_error("The Websocket connection was closed!");

return cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.ws_was_welcome_ref,false);
} else {
return null;
}
}),new cljs.core.Keyword(null,"on-reconnect","on-reconnect",1239988702),(function (e){
return shadow.cljs.devtools.client.hud.connection_error("Reconnecting ...");
}),new cljs.core.Keyword(null,"ops","ops",1237330063),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"access-denied","access-denied",959449406),(function (msg){
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.ws_was_welcome_ref,false);

return shadow.cljs.devtools.client.hud.connection_error(["Stale Output! Your loaded JS was not produced by the running shadow-cljs instance."," Is the watch for this build running?"].join(''));
}),new cljs.core.Keyword(null,"cljs-runtime-init","cljs-runtime-init",1305890232),(function (msg){
return shadow.cljs.devtools.client.browser.repl_init(runtime,msg);
}),new cljs.core.Keyword(null,"cljs-asset-update","cljs-asset-update",1224093028),(function (p__35217){
var map__35218 = p__35217;
var map__35218__$1 = (((((!((map__35218 == null))))?(((((map__35218.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35218.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35218):map__35218);
var msg = map__35218__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35218__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
return shadow.cljs.devtools.client.browser.handle_asset_update(msg);
}),new cljs.core.Keyword(null,"cljs-build-configure","cljs-build-configure",-2089891268),(function (msg){
return null;
}),new cljs.core.Keyword(null,"cljs-build-start","cljs-build-start",-725781241),(function (msg){
shadow.cljs.devtools.client.hud.hud_hide();

shadow.cljs.devtools.client.hud.load_start();

return shadow.cljs.devtools.client.env.run_custom_notify_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(msg,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"build-start","build-start",-959649480)));
}),new cljs.core.Keyword(null,"cljs-build-complete","cljs-build-complete",273626153),(function (msg){
var msg__$1 = shadow.cljs.devtools.client.env.add_warnings_to_info(msg);
shadow.cljs.devtools.client.hud.hud_warnings(msg__$1);

shadow.cljs.devtools.client.browser.handle_build_complete(runtime,msg__$1);

return shadow.cljs.devtools.client.env.run_custom_notify_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(msg__$1,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"build-complete","build-complete",-501868472)));
}),new cljs.core.Keyword(null,"cljs-build-failure","cljs-build-failure",1718154990),(function (msg){
shadow.cljs.devtools.client.hud.load_end();

shadow.cljs.devtools.client.hud.hud_error(msg);

return shadow.cljs.devtools.client.env.run_custom_notify_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(msg,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"build-failure","build-failure",-2107487466)));
}),new cljs.core.Keyword("shadow.cljs.devtools.client.env","worker-notify","shadow.cljs.devtools.client.env/worker-notify",-1456820670),(function (p__35220){
var map__35221 = p__35220;
var map__35221__$1 = (((((!((map__35221 == null))))?(((((map__35221.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35221.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35221):map__35221);
var event_op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35221__$1,new cljs.core.Keyword(null,"event-op","event-op",200358057));
var client_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35221__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"client-disconnect","client-disconnect",640227957),event_op)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(client_id,shadow.cljs.devtools.client.env.worker_client_id)))){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

return shadow.cljs.devtools.client.hud.connection_error("The watch for this build was stopped!");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"client-connect","client-connect",-1113973888),event_op)){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

return shadow.cljs.devtools.client.hud.connection_error("The watch for this build was restarted. Reload required!");
} else {
return null;
}
}
})], null)], null));

return svc;
}),(function (p__35223){
var map__35224 = p__35223;
var map__35224__$1 = (((((!((map__35224 == null))))?(((((map__35224.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35224.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35224):map__35224);
var svc = map__35224__$1;
var runtime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35224__$1,new cljs.core.Keyword(null,"runtime","runtime",-1331573996));
return shadow.remote.runtime.api.del_extension(runtime,new cljs.core.Keyword("shadow.cljs.devtools.client.browser","client","shadow.cljs.devtools.client.browser/client",-1461019282));
}));

shadow.cljs.devtools.client.shared.init_runtime_BANG_(shadow.cljs.devtools.client.browser.client_info,shadow.cljs.devtools.client.websocket.start,shadow.cljs.devtools.client.websocket.send,shadow.cljs.devtools.client.websocket.stop);
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
