goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__34837__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__34148 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__34149 = cljs.core.seq(vec__34148);
var first__34150 = cljs.core.first(seq__34149);
var seq__34149__$1 = cljs.core.next(seq__34149);
var tag = first__34150;
var body = seq__34149__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.first(body),cljs.core.first(args)], 0))], null),cljs.core.rest(body));
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.first(args)], null),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__34837 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34847__i = 0, G__34847__a = new Array(arguments.length -  0);
while (G__34847__i < G__34847__a.length) {G__34847__a[G__34847__i] = arguments[G__34847__i + 0]; ++G__34847__i;}
  args = new cljs.core.IndexedSeq(G__34847__a,0,null);
} 
return G__34837__delegate.call(this,args);};
G__34837.cljs$lang$maxFixedArity = 0;
G__34837.cljs$lang$applyTo = (function (arglist__34848){
var args = cljs.core.seq(arglist__34848);
return G__34837__delegate(args);
});
G__34837.cljs$core$IFn$_invoke$arity$variadic = G__34837__delegate;
return G__34837;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__4529__auto__ = (function sablono$core$update_arglists_$_iter__34157(s__34158){
return (new cljs.core.LazySeq(null,(function (){
var s__34158__$1 = s__34158;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__34158__$1);
if(temp__5735__auto__){
var s__34158__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34158__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__34158__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__34160 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__34159 = (0);
while(true){
if((i__34159 < size__4528__auto__)){
var args = cljs.core._nth(c__4527__auto__,i__34159);
cljs.core.chunk_append(b__34160,cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__34851 = (i__34159 + (1));
i__34159 = G__34851;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34160),sablono$core$update_arglists_$_iter__34157(cljs.core.chunk_rest(s__34158__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34160),null);
}
} else {
var args = cljs.core.first(s__34158__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__34157(cljs.core.rest(s__34158__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34853 = arguments.length;
var i__4737__auto___34854 = (0);
while(true){
if((i__4737__auto___34854 < len__4736__auto___34853)){
args__4742__auto__.push((arguments[i__4737__auto___34854]));

var G__34855 = (i__4737__auto___34854 + (1));
i__4737__auto___34854 = G__34855;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__4529__auto__ = (function sablono$core$iter__34211(s__34212){
return (new cljs.core.LazySeq(null,(function (){
var s__34212__$1 = s__34212;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__34212__$1);
if(temp__5735__auto__){
var s__34212__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34212__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__34212__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__34214 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__34213 = (0);
while(true){
if((i__34213 < size__4528__auto__)){
var style = cljs.core._nth(c__4527__auto__,i__34213);
cljs.core.chunk_append(b__34214,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__34864 = (i__34213 + (1));
i__34213 = G__34864;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34214),sablono$core$iter__34211(cljs.core.chunk_rest(s__34212__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34214),null);
}
} else {
var style = cljs.core.first(s__34212__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__34211(cljs.core.rest(s__34212__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(styles);
}));

(sablono.core.include_css.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(sablono.core.include_css.cljs$lang$applyTo = (function (seq34208){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34208));
}));

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to34228 = (function sablono$core$link_to34228(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34879 = arguments.length;
var i__4737__auto___34880 = (0);
while(true){
if((i__4737__auto___34880 < len__4736__auto___34879)){
args__4742__auto__.push((arguments[i__4737__auto___34880]));

var G__34881 = (i__4737__auto___34880 + (1));
i__4737__auto___34880 = G__34881;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to34228.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sablono.core.link_to34228.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([url], 0))], null),content], null);
}));

(sablono.core.link_to34228.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.link_to34228.cljs$lang$applyTo = (function (seq34232){
var G__34233 = cljs.core.first(seq34232);
var seq34232__$1 = cljs.core.next(seq34232);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34233,seq34232__$1);
}));


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to34228);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to34254 = (function sablono$core$mail_to34254(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34889 = arguments.length;
var i__4737__auto___34890 = (0);
while(true){
if((i__4737__auto___34890 < len__4736__auto___34889)){
args__4742__auto__.push((arguments[i__4737__auto___34890]));

var G__34892 = (i__4737__auto___34890 + (1));
i__4737__auto___34890 = G__34892;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to34254.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sablono.core.mail_to34254.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__34269){
var vec__34271 = p__34269;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34271,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__4126__auto__ = content;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return e_mail;
}
})()], null);
}));

(sablono.core.mail_to34254.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.mail_to34254.cljs$lang$applyTo = (function (seq34256){
var G__34257 = cljs.core.first(seq34256);
var seq34256__$1 = cljs.core.next(seq34256);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34257,seq34256__$1);
}));


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to34254);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list34278 = (function sablono$core$unordered_list34278(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4529__auto__ = (function sablono$core$unordered_list34278_$_iter__34282(s__34283){
return (new cljs.core.LazySeq(null,(function (){
var s__34283__$1 = s__34283;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__34283__$1);
if(temp__5735__auto__){
var s__34283__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34283__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__34283__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__34285 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__34284 = (0);
while(true){
if((i__34284 < size__4528__auto__)){
var x = cljs.core._nth(c__4527__auto__,i__34284);
cljs.core.chunk_append(b__34285,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__34902 = (i__34284 + (1));
i__34284 = G__34902;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34285),sablono$core$unordered_list34278_$_iter__34282(cljs.core.chunk_rest(s__34283__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34285),null);
}
} else {
var x = cljs.core.first(s__34283__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list34278_$_iter__34282(cljs.core.rest(s__34283__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list34278);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list34309 = (function sablono$core$ordered_list34309(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4529__auto__ = (function sablono$core$ordered_list34309_$_iter__34314(s__34315){
return (new cljs.core.LazySeq(null,(function (){
var s__34315__$1 = s__34315;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__34315__$1);
if(temp__5735__auto__){
var s__34315__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34315__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__34315__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__34317 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__34316 = (0);
while(true){
if((i__34316 < size__4528__auto__)){
var x = cljs.core._nth(c__4527__auto__,i__34316);
cljs.core.chunk_append(b__34317,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__34907 = (i__34316 + (1));
i__34316 = G__34907;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34317),sablono$core$ordered_list34309_$_iter__34314(cljs.core.chunk_rest(s__34315__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34317),null);
}
} else {
var x = cljs.core.first(s__34315__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list34309_$_iter__34314(cljs.core.rest(s__34315__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list34309);
/**
 * Create an image element.
 */
sablono.core.image34343 = (function sablono$core$image34343(var_args){
var G__34349 = arguments.length;
switch (G__34349) {
case 1:
return sablono.core.image34343.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image34343.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.image34343.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0))], null)], null);
}));

(sablono.core.image34343.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0)),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
}));

(sablono.core.image34343.cljs$lang$maxFixedArity = 2);


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image34343);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__34363_SHARP_,p2__34364_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34363_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__34364_SHARP_),"]"].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__34373_SHARP_,p2__34374_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34373_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__34374_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(var_args){
var G__34390 = arguments.length;
switch (G__34390) {
case 2:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4126__auto__ = value;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$lang$maxFixedArity = 3);

/**
 * Creates a color input field.
 */
sablono.core.color_field34399 = (function sablono$core$color_field34399(var_args){
var G__34406 = arguments.length;
switch (G__34406) {
case 1:
return sablono.core.color_field34399.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field34399.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.color_field34399.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__34112__auto__);
}));

(sablono.core.color_field34399.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.color_field34399.cljs$lang$maxFixedArity = 2);


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field34399);

/**
 * Creates a date input field.
 */
sablono.core.date_field34412 = (function sablono$core$date_field34412(var_args){
var G__34415 = arguments.length;
switch (G__34415) {
case 1:
return sablono.core.date_field34412.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field34412.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.date_field34412.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__34112__auto__);
}));

(sablono.core.date_field34412.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.date_field34412.cljs$lang$maxFixedArity = 2);


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field34412);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field34426 = (function sablono$core$datetime_field34426(var_args){
var G__34434 = arguments.length;
switch (G__34434) {
case 1:
return sablono.core.datetime_field34426.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field34426.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_field34426.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__34112__auto__);
}));

(sablono.core.datetime_field34426.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.datetime_field34426.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field34426);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field34442 = (function sablono$core$datetime_local_field34442(var_args){
var G__34448 = arguments.length;
switch (G__34448) {
case 1:
return sablono.core.datetime_local_field34442.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field34442.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_local_field34442.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__34112__auto__);
}));

(sablono.core.datetime_local_field34442.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.datetime_local_field34442.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field34442);

/**
 * Creates a email input field.
 */
sablono.core.email_field34461 = (function sablono$core$email_field34461(var_args){
var G__34465 = arguments.length;
switch (G__34465) {
case 1:
return sablono.core.email_field34461.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field34461.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.email_field34461.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__34112__auto__);
}));

(sablono.core.email_field34461.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.email_field34461.cljs$lang$maxFixedArity = 2);


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field34461);

/**
 * Creates a file input field.
 */
sablono.core.file_field34475 = (function sablono$core$file_field34475(var_args){
var G__34485 = arguments.length;
switch (G__34485) {
case 1:
return sablono.core.file_field34475.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field34475.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.file_field34475.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__34112__auto__);
}));

(sablono.core.file_field34475.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.file_field34475.cljs$lang$maxFixedArity = 2);


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field34475);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field34500 = (function sablono$core$hidden_field34500(var_args){
var G__34507 = arguments.length;
switch (G__34507) {
case 1:
return sablono.core.hidden_field34500.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field34500.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.hidden_field34500.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__34112__auto__);
}));

(sablono.core.hidden_field34500.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.hidden_field34500.cljs$lang$maxFixedArity = 2);


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field34500);

/**
 * Creates a month input field.
 */
sablono.core.month_field34527 = (function sablono$core$month_field34527(var_args){
var G__34538 = arguments.length;
switch (G__34538) {
case 1:
return sablono.core.month_field34527.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field34527.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.month_field34527.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__34112__auto__);
}));

(sablono.core.month_field34527.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.month_field34527.cljs$lang$maxFixedArity = 2);


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field34527);

/**
 * Creates a number input field.
 */
sablono.core.number_field34546 = (function sablono$core$number_field34546(var_args){
var G__34552 = arguments.length;
switch (G__34552) {
case 1:
return sablono.core.number_field34546.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field34546.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.number_field34546.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__34112__auto__);
}));

(sablono.core.number_field34546.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.number_field34546.cljs$lang$maxFixedArity = 2);


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field34546);

/**
 * Creates a password input field.
 */
sablono.core.password_field34565 = (function sablono$core$password_field34565(var_args){
var G__34569 = arguments.length;
switch (G__34569) {
case 1:
return sablono.core.password_field34565.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field34565.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.password_field34565.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__34112__auto__);
}));

(sablono.core.password_field34565.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.password_field34565.cljs$lang$maxFixedArity = 2);


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field34565);

/**
 * Creates a range input field.
 */
sablono.core.range_field34576 = (function sablono$core$range_field34576(var_args){
var G__34584 = arguments.length;
switch (G__34584) {
case 1:
return sablono.core.range_field34576.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field34576.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.range_field34576.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__34112__auto__);
}));

(sablono.core.range_field34576.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.range_field34576.cljs$lang$maxFixedArity = 2);


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field34576);

/**
 * Creates a search input field.
 */
sablono.core.search_field34600 = (function sablono$core$search_field34600(var_args){
var G__34604 = arguments.length;
switch (G__34604) {
case 1:
return sablono.core.search_field34600.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field34600.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.search_field34600.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__34112__auto__);
}));

(sablono.core.search_field34600.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.search_field34600.cljs$lang$maxFixedArity = 2);


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field34600);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field34610 = (function sablono$core$tel_field34610(var_args){
var G__34621 = arguments.length;
switch (G__34621) {
case 1:
return sablono.core.tel_field34610.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field34610.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.tel_field34610.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__34112__auto__);
}));

(sablono.core.tel_field34610.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.tel_field34610.cljs$lang$maxFixedArity = 2);


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field34610);

/**
 * Creates a text input field.
 */
sablono.core.text_field34632 = (function sablono$core$text_field34632(var_args){
var G__34635 = arguments.length;
switch (G__34635) {
case 1:
return sablono.core.text_field34632.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field34632.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_field34632.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__34112__auto__);
}));

(sablono.core.text_field34632.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.text_field34632.cljs$lang$maxFixedArity = 2);


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field34632);

/**
 * Creates a time input field.
 */
sablono.core.time_field34650 = (function sablono$core$time_field34650(var_args){
var G__34654 = arguments.length;
switch (G__34654) {
case 1:
return sablono.core.time_field34650.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field34650.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.time_field34650.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__34112__auto__);
}));

(sablono.core.time_field34650.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.time_field34650.cljs$lang$maxFixedArity = 2);


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field34650);

/**
 * Creates a url input field.
 */
sablono.core.url_field34667 = (function sablono$core$url_field34667(var_args){
var G__34673 = arguments.length;
switch (G__34673) {
case 1:
return sablono.core.url_field34667.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field34667.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.url_field34667.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__34112__auto__);
}));

(sablono.core.url_field34667.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.url_field34667.cljs$lang$maxFixedArity = 2);


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field34667);

/**
 * Creates a week input field.
 */
sablono.core.week_field34679 = (function sablono$core$week_field34679(var_args){
var G__34686 = arguments.length;
switch (G__34686) {
case 1:
return sablono.core.week_field34679.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field34679.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.week_field34679.cljs$core$IFn$_invoke$arity$1 = (function (name__34112__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__34112__auto__);
}));

(sablono.core.week_field34679.cljs$core$IFn$_invoke$arity$2 = (function (name__34112__auto__,value__34113__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__34112__auto__,value__34113__auto__);
}));

(sablono.core.week_field34679.cljs$lang$maxFixedArity = 2);


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field34679);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box34695 = (function sablono$core$check_box34695(var_args){
var G__34697 = arguments.length;
switch (G__34697) {
case 1:
return sablono.core.check_box34695.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box34695.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box34695.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.check_box34695.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.check_box34695.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box34695.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box34695.cljs$lang$maxFixedArity = 3);


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box34695);
/**
 * Creates a radio button.
 */
sablono.core.radio_button34704 = (function sablono$core$radio_button34704(var_args){
var G__34711 = arguments.length;
switch (G__34711) {
case 1:
return sablono.core.radio_button34704.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button34704.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button34704.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.radio_button34704.cljs$core$IFn$_invoke$arity$1 = (function (group){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)))], null)], null);
}));

(sablono.core.radio_button34704.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0))),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button34704.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id([sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)),"-",sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button34704.cljs$lang$maxFixedArity = 3);


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button34704);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0)));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options34729 = (function sablono$core$select_options34729(coll){
var iter__4529__auto__ = (function sablono$core$select_options34729_$_iter__34732(s__34733){
return (new cljs.core.LazySeq(null,(function (){
var s__34733__$1 = s__34733;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__34733__$1);
if(temp__5735__auto__){
var s__34733__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34733__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__34733__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__34735 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__34734 = (0);
while(true){
if((i__34734 < size__4528__auto__)){
var x = cljs.core._nth(c__4527__auto__,i__34734);
cljs.core.chunk_append(b__34735,((cljs.core.sequential_QMARK_(x))?(function (){var vec__34740 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34740,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34740,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34740,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options34729.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options34729.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options34729.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__35027 = (i__34734 + (1));
i__34734 = G__35027;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34735),sablono$core$select_options34729_$_iter__34732(cljs.core.chunk_rest(s__34733__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34735),null);
}
} else {
var x = cljs.core.first(s__34733__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__34750 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34750,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34750,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34750,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options34729.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options34729.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options34729.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options34729_$_iter__34732(cljs.core.rest(s__34733__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
});

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options34729);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down34757 = (function sablono$core$drop_down34757(var_args){
var G__34765 = arguments.length;
switch (G__34765) {
case 2:
return sablono.core.drop_down34757.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down34757.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.drop_down34757.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down34757.cljs$core$IFn$_invoke$arity$3(name,options,null);
}));

(sablono.core.drop_down34757.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null),sablono.core.select_options(options,selected)], null);
}));

(sablono.core.drop_down34757.cljs$lang$maxFixedArity = 3);


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down34757);
/**
 * Creates a text area element.
 */
sablono.core.text_area34773 = (function sablono$core$text_area34773(var_args){
var G__34777 = arguments.length;
switch (G__34777) {
case 1:
return sablono.core.text_area34773.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area34773.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_area34773.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.text_area34773.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4126__auto__ = value;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.text_area34773.cljs$lang$maxFixedArity = 2);


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area34773);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label34785 = (function sablono$core$label34785(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label34785);
/**
 * Creates a submit button.
 */
sablono.core.submit_button34790 = (function sablono$core$submit_button34790(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button34790);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button34794 = (function sablono$core$reset_button34794(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button34794);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to34796 = (function sablono$core$form_to34796(var_args){
var args__4742__auto__ = [];
var len__4736__auto___35052 = arguments.length;
var i__4737__auto___35053 = (0);
while(true){
if((i__4737__auto___35053 < len__4736__auto___35052)){
args__4742__auto__.push((arguments[i__4737__auto___35053]));

var G__35056 = (i__4737__auto___35053 + (1));
i__4737__auto___35053 = G__35056;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to34796.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sablono.core.form_to34796.cljs$core$IFn$_invoke$arity$variadic = (function (p__34803,body){
var vec__34806 = p__34803;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34806,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34806,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
}));

(sablono.core.form_to34796.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.form_to34796.cljs$lang$applyTo = (function (seq34798){
var G__34799 = cljs.core.first(seq34798);
var seq34798__$1 = cljs.core.next(seq34798);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34799,seq34798__$1);
}));


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to34796);

//# sourceMappingURL=sablono.core.js.map
