goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__27165 = arguments.length;
switch (G__27165) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27172 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27172 = (function (f,blockable,meta27173){
this.f = f;
this.blockable = blockable;
this.meta27173 = meta27173;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27172.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27174,meta27173__$1){
var self__ = this;
var _27174__$1 = this;
return (new cljs.core.async.t_cljs$core$async27172(self__.f,self__.blockable,meta27173__$1));
}));

(cljs.core.async.t_cljs$core$async27172.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27174){
var self__ = this;
var _27174__$1 = this;
return self__.meta27173;
}));

(cljs.core.async.t_cljs$core$async27172.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27172.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async27172.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async27172.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async27172.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta27173","meta27173",-506429927,null)], null);
}));

(cljs.core.async.t_cljs$core$async27172.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27172.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27172");

(cljs.core.async.t_cljs$core$async27172.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async27172");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27172.
 */
cljs.core.async.__GT_t_cljs$core$async27172 = (function cljs$core$async$__GT_t_cljs$core$async27172(f__$1,blockable__$1,meta27173){
return (new cljs.core.async.t_cljs$core$async27172(f__$1,blockable__$1,meta27173));
});

}

return (new cljs.core.async.t_cljs$core$async27172(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__27190 = arguments.length;
switch (G__27190) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__27199 = arguments.length;
switch (G__27199) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__27207 = arguments.length;
switch (G__27207) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30131 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30131) : fn1.call(null,val_30131));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30131) : fn1.call(null,val_30131));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__27220 = arguments.length;
switch (G__27220) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___30145 = n;
var x_30146 = (0);
while(true){
if((x_30146 < n__4613__auto___30145)){
(a[x_30146] = x_30146);

var G__30151 = (x_30146 + (1));
x_30146 = G__30151;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27234 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27234 = (function (flag,meta27235){
this.flag = flag;
this.meta27235 = meta27235;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27234.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27236,meta27235__$1){
var self__ = this;
var _27236__$1 = this;
return (new cljs.core.async.t_cljs$core$async27234(self__.flag,meta27235__$1));
}));

(cljs.core.async.t_cljs$core$async27234.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27236){
var self__ = this;
var _27236__$1 = this;
return self__.meta27235;
}));

(cljs.core.async.t_cljs$core$async27234.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27234.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async27234.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async27234.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async27234.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta27235","meta27235",-1089559707,null)], null);
}));

(cljs.core.async.t_cljs$core$async27234.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27234.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27234");

(cljs.core.async.t_cljs$core$async27234.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async27234");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27234.
 */
cljs.core.async.__GT_t_cljs$core$async27234 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async27234(flag__$1,meta27235){
return (new cljs.core.async.t_cljs$core$async27234(flag__$1,meta27235));
});

}

return (new cljs.core.async.t_cljs$core$async27234(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27247 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27247 = (function (flag,cb,meta27248){
this.flag = flag;
this.cb = cb;
this.meta27248 = meta27248;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27247.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27249,meta27248__$1){
var self__ = this;
var _27249__$1 = this;
return (new cljs.core.async.t_cljs$core$async27247(self__.flag,self__.cb,meta27248__$1));
}));

(cljs.core.async.t_cljs$core$async27247.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27249){
var self__ = this;
var _27249__$1 = this;
return self__.meta27248;
}));

(cljs.core.async.t_cljs$core$async27247.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27247.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async27247.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async27247.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async27247.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta27248","meta27248",1324322367,null)], null);
}));

(cljs.core.async.t_cljs$core$async27247.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27247.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27247");

(cljs.core.async.t_cljs$core$async27247.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async27247");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27247.
 */
cljs.core.async.__GT_t_cljs$core$async27247 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async27247(flag__$1,cb__$1,meta27248){
return (new cljs.core.async.t_cljs$core$async27247(flag__$1,cb__$1,meta27248));
});

}

return (new cljs.core.async.t_cljs$core$async27247(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__27263_SHARP_){
var G__27279 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27263_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__27279) : fret.call(null,G__27279));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__27264_SHARP_){
var G__27286 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27264_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__27286) : fret.call(null,G__27286));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30171 = (i + (1));
i = G__30171;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30177 = arguments.length;
var i__4737__auto___30178 = (0);
while(true){
if((i__4737__auto___30178 < len__4736__auto___30177)){
args__4742__auto__.push((arguments[i__4737__auto___30178]));

var G__30179 = (i__4737__auto___30178 + (1));
i__4737__auto___30178 = G__30179;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__27301){
var map__27302 = p__27301;
var map__27302__$1 = (((((!((map__27302 == null))))?(((((map__27302.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27302.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27302):map__27302);
var opts = map__27302__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq27299){
var G__27300 = cljs.core.first(seq27299);
var seq27299__$1 = cljs.core.next(seq27299);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27300,seq27299__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__27313 = arguments.length;
switch (G__27313) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__27074__auto___30191 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_27371){
var state_val_27372 = (state_27371[(1)]);
if((state_val_27372 === (7))){
var inst_27359 = (state_27371[(2)]);
var state_27371__$1 = state_27371;
var statearr_27373_30197 = state_27371__$1;
(statearr_27373_30197[(2)] = inst_27359);

(statearr_27373_30197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (1))){
var state_27371__$1 = state_27371;
var statearr_27378_30201 = state_27371__$1;
(statearr_27378_30201[(2)] = null);

(statearr_27378_30201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (4))){
var inst_27328 = (state_27371[(7)]);
var inst_27328__$1 = (state_27371[(2)]);
var inst_27330 = (inst_27328__$1 == null);
var state_27371__$1 = (function (){var statearr_27380 = state_27371;
(statearr_27380[(7)] = inst_27328__$1);

return statearr_27380;
})();
if(cljs.core.truth_(inst_27330)){
var statearr_27381_30214 = state_27371__$1;
(statearr_27381_30214[(1)] = (5));

} else {
var statearr_27382_30215 = state_27371__$1;
(statearr_27382_30215[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (13))){
var state_27371__$1 = state_27371;
var statearr_27383_30222 = state_27371__$1;
(statearr_27383_30222[(2)] = null);

(statearr_27383_30222[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (6))){
var inst_27328 = (state_27371[(7)]);
var state_27371__$1 = state_27371;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27371__$1,(11),to,inst_27328);
} else {
if((state_val_27372 === (3))){
var inst_27361 = (state_27371[(2)]);
var state_27371__$1 = state_27371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27371__$1,inst_27361);
} else {
if((state_val_27372 === (12))){
var state_27371__$1 = state_27371;
var statearr_27387_30228 = state_27371__$1;
(statearr_27387_30228[(2)] = null);

(statearr_27387_30228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (2))){
var state_27371__$1 = state_27371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27371__$1,(4),from);
} else {
if((state_val_27372 === (11))){
var inst_27346 = (state_27371[(2)]);
var state_27371__$1 = state_27371;
if(cljs.core.truth_(inst_27346)){
var statearr_27388_30229 = state_27371__$1;
(statearr_27388_30229[(1)] = (12));

} else {
var statearr_27389_30230 = state_27371__$1;
(statearr_27389_30230[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (9))){
var state_27371__$1 = state_27371;
var statearr_27390_30231 = state_27371__$1;
(statearr_27390_30231[(2)] = null);

(statearr_27390_30231[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (5))){
var state_27371__$1 = state_27371;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27391_30232 = state_27371__$1;
(statearr_27391_30232[(1)] = (8));

} else {
var statearr_27392_30233 = state_27371__$1;
(statearr_27392_30233[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (14))){
var inst_27357 = (state_27371[(2)]);
var state_27371__$1 = state_27371;
var statearr_27393_30234 = state_27371__$1;
(statearr_27393_30234[(2)] = inst_27357);

(statearr_27393_30234[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (10))){
var inst_27343 = (state_27371[(2)]);
var state_27371__$1 = state_27371;
var statearr_27394_30235 = state_27371__$1;
(statearr_27394_30235[(2)] = inst_27343);

(statearr_27394_30235[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27372 === (8))){
var inst_27337 = cljs.core.async.close_BANG_(to);
var state_27371__$1 = state_27371;
var statearr_27395_30236 = state_27371__$1;
(statearr_27395_30236[(2)] = inst_27337);

(statearr_27395_30236[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_27396 = [null,null,null,null,null,null,null,null];
(statearr_27396[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_27396[(1)] = (1));

return statearr_27396;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_27371){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_27371);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e27397){var ex__26718__auto__ = e27397;
var statearr_27398_30240 = state_27371;
(statearr_27398_30240[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_27371[(4)]))){
var statearr_27399_30241 = state_27371;
(statearr_27399_30241[(1)] = cljs.core.first((state_27371[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30242 = state_27371;
state_27371 = G__30242;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_27371){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_27371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_27400 = f__27075__auto__();
(statearr_27400[(6)] = c__27074__auto___30191);

return statearr_27400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__27413){
var vec__27414 = p__27413;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27414,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27414,(1),null);
var job = vec__27414;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__27074__auto___30261 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_27421){
var state_val_27422 = (state_27421[(1)]);
if((state_val_27422 === (1))){
var state_27421__$1 = state_27421;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27421__$1,(2),res,v);
} else {
if((state_val_27422 === (2))){
var inst_27418 = (state_27421[(2)]);
var inst_27419 = cljs.core.async.close_BANG_(res);
var state_27421__$1 = (function (){var statearr_27423 = state_27421;
(statearr_27423[(7)] = inst_27418);

return statearr_27423;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27421__$1,inst_27419);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0 = (function (){
var statearr_27424 = [null,null,null,null,null,null,null,null];
(statearr_27424[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__);

(statearr_27424[(1)] = (1));

return statearr_27424;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1 = (function (state_27421){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_27421);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e27425){var ex__26718__auto__ = e27425;
var statearr_27426_30269 = state_27421;
(statearr_27426_30269[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_27421[(4)]))){
var statearr_27427_30270 = state_27421;
(statearr_27427_30270[(1)] = cljs.core.first((state_27421[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30271 = state_27421;
state_27421 = G__30271;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = function(state_27421){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1.call(this,state_27421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_27431 = f__27075__auto__();
(statearr_27431[(6)] = c__27074__auto___30261);

return statearr_27431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__27432){
var vec__27433 = p__27432;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27433,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27433,(1),null);
var job = vec__27433;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___30278 = n;
var __30279 = (0);
while(true){
if((__30279 < n__4613__auto___30278)){
var G__27443_30280 = type;
var G__27443_30281__$1 = (((G__27443_30280 instanceof cljs.core.Keyword))?G__27443_30280.fqn:null);
switch (G__27443_30281__$1) {
case "compute":
var c__27074__auto___30283 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30279,c__27074__auto___30283,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async){
return (function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = ((function (__30279,c__27074__auto___30283,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async){
return (function (state_27464){
var state_val_27465 = (state_27464[(1)]);
if((state_val_27465 === (1))){
var state_27464__$1 = state_27464;
var statearr_27469_30289 = state_27464__$1;
(statearr_27469_30289[(2)] = null);

(statearr_27469_30289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27465 === (2))){
var state_27464__$1 = state_27464;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27464__$1,(4),jobs);
} else {
if((state_val_27465 === (3))){
var inst_27462 = (state_27464[(2)]);
var state_27464__$1 = state_27464;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27464__$1,inst_27462);
} else {
if((state_val_27465 === (4))){
var inst_27451 = (state_27464[(2)]);
var inst_27452 = process(inst_27451);
var state_27464__$1 = state_27464;
if(cljs.core.truth_(inst_27452)){
var statearr_27476_30296 = state_27464__$1;
(statearr_27476_30296[(1)] = (5));

} else {
var statearr_27477_30297 = state_27464__$1;
(statearr_27477_30297[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27465 === (5))){
var state_27464__$1 = state_27464;
var statearr_27478_30298 = state_27464__$1;
(statearr_27478_30298[(2)] = null);

(statearr_27478_30298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27465 === (6))){
var state_27464__$1 = state_27464;
var statearr_27479_30302 = state_27464__$1;
(statearr_27479_30302[(2)] = null);

(statearr_27479_30302[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27465 === (7))){
var inst_27460 = (state_27464[(2)]);
var state_27464__$1 = state_27464;
var statearr_27480_30303 = state_27464__$1;
(statearr_27480_30303[(2)] = inst_27460);

(statearr_27480_30303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30279,c__27074__auto___30283,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async))
;
return ((function (__30279,switch__26714__auto__,c__27074__auto___30283,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0 = (function (){
var statearr_27481 = [null,null,null,null,null,null,null];
(statearr_27481[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__);

(statearr_27481[(1)] = (1));

return statearr_27481;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1 = (function (state_27464){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_27464);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e27482){var ex__26718__auto__ = e27482;
var statearr_27483_30311 = state_27464;
(statearr_27483_30311[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_27464[(4)]))){
var statearr_27485_30315 = state_27464;
(statearr_27485_30315[(1)] = cljs.core.first((state_27464[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30318 = state_27464;
state_27464 = G__30318;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = function(state_27464){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1.call(this,state_27464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__;
})()
;})(__30279,switch__26714__auto__,c__27074__auto___30283,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async))
})();
var state__27076__auto__ = (function (){var statearr_27492 = f__27075__auto__();
(statearr_27492[(6)] = c__27074__auto___30283);

return statearr_27492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
});})(__30279,c__27074__auto___30283,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async))
);


break;
case "async":
var c__27074__auto___30319 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30279,c__27074__auto___30319,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async){
return (function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = ((function (__30279,c__27074__auto___30319,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async){
return (function (state_27505){
var state_val_27506 = (state_27505[(1)]);
if((state_val_27506 === (1))){
var state_27505__$1 = state_27505;
var statearr_27507_30324 = state_27505__$1;
(statearr_27507_30324[(2)] = null);

(statearr_27507_30324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27506 === (2))){
var state_27505__$1 = state_27505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27505__$1,(4),jobs);
} else {
if((state_val_27506 === (3))){
var inst_27503 = (state_27505[(2)]);
var state_27505__$1 = state_27505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27505__$1,inst_27503);
} else {
if((state_val_27506 === (4))){
var inst_27495 = (state_27505[(2)]);
var inst_27496 = async(inst_27495);
var state_27505__$1 = state_27505;
if(cljs.core.truth_(inst_27496)){
var statearr_27514_30328 = state_27505__$1;
(statearr_27514_30328[(1)] = (5));

} else {
var statearr_27515_30329 = state_27505__$1;
(statearr_27515_30329[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27506 === (5))){
var state_27505__$1 = state_27505;
var statearr_27516_30330 = state_27505__$1;
(statearr_27516_30330[(2)] = null);

(statearr_27516_30330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27506 === (6))){
var state_27505__$1 = state_27505;
var statearr_27517_30331 = state_27505__$1;
(statearr_27517_30331[(2)] = null);

(statearr_27517_30331[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27506 === (7))){
var inst_27501 = (state_27505[(2)]);
var state_27505__$1 = state_27505;
var statearr_27518_30332 = state_27505__$1;
(statearr_27518_30332[(2)] = inst_27501);

(statearr_27518_30332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30279,c__27074__auto___30319,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async))
;
return ((function (__30279,switch__26714__auto__,c__27074__auto___30319,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0 = (function (){
var statearr_27519 = [null,null,null,null,null,null,null];
(statearr_27519[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__);

(statearr_27519[(1)] = (1));

return statearr_27519;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1 = (function (state_27505){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_27505);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e27526){var ex__26718__auto__ = e27526;
var statearr_27527_30334 = state_27505;
(statearr_27527_30334[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_27505[(4)]))){
var statearr_27528_30336 = state_27505;
(statearr_27528_30336[(1)] = cljs.core.first((state_27505[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30341 = state_27505;
state_27505 = G__30341;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = function(state_27505){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1.call(this,state_27505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__;
})()
;})(__30279,switch__26714__auto__,c__27074__auto___30319,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async))
})();
var state__27076__auto__ = (function (){var statearr_27530 = f__27075__auto__();
(statearr_27530[(6)] = c__27074__auto___30319);

return statearr_27530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
});})(__30279,c__27074__auto___30319,G__27443_30280,G__27443_30281__$1,n__4613__auto___30278,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27443_30281__$1)].join('')));

}

var G__30345 = (__30279 + (1));
__30279 = G__30345;
continue;
} else {
}
break;
}

var c__27074__auto___30346 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_27553){
var state_val_27554 = (state_27553[(1)]);
if((state_val_27554 === (7))){
var inst_27549 = (state_27553[(2)]);
var state_27553__$1 = state_27553;
var statearr_27583_30348 = state_27553__$1;
(statearr_27583_30348[(2)] = inst_27549);

(statearr_27583_30348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27554 === (1))){
var state_27553__$1 = state_27553;
var statearr_27589_30349 = state_27553__$1;
(statearr_27589_30349[(2)] = null);

(statearr_27589_30349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27554 === (4))){
var inst_27533 = (state_27553[(7)]);
var inst_27533__$1 = (state_27553[(2)]);
var inst_27534 = (inst_27533__$1 == null);
var state_27553__$1 = (function (){var statearr_27590 = state_27553;
(statearr_27590[(7)] = inst_27533__$1);

return statearr_27590;
})();
if(cljs.core.truth_(inst_27534)){
var statearr_27591_30350 = state_27553__$1;
(statearr_27591_30350[(1)] = (5));

} else {
var statearr_27592_30351 = state_27553__$1;
(statearr_27592_30351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27554 === (6))){
var inst_27533 = (state_27553[(7)]);
var inst_27538 = (state_27553[(8)]);
var inst_27538__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_27540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27541 = [inst_27533,inst_27538__$1];
var inst_27542 = (new cljs.core.PersistentVector(null,2,(5),inst_27540,inst_27541,null));
var state_27553__$1 = (function (){var statearr_27594 = state_27553;
(statearr_27594[(8)] = inst_27538__$1);

return statearr_27594;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27553__$1,(8),jobs,inst_27542);
} else {
if((state_val_27554 === (3))){
var inst_27551 = (state_27553[(2)]);
var state_27553__$1 = state_27553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27553__$1,inst_27551);
} else {
if((state_val_27554 === (2))){
var state_27553__$1 = state_27553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27553__$1,(4),from);
} else {
if((state_val_27554 === (9))){
var inst_27546 = (state_27553[(2)]);
var state_27553__$1 = (function (){var statearr_27597 = state_27553;
(statearr_27597[(9)] = inst_27546);

return statearr_27597;
})();
var statearr_27598_30356 = state_27553__$1;
(statearr_27598_30356[(2)] = null);

(statearr_27598_30356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27554 === (5))){
var inst_27536 = cljs.core.async.close_BANG_(jobs);
var state_27553__$1 = state_27553;
var statearr_27599_30358 = state_27553__$1;
(statearr_27599_30358[(2)] = inst_27536);

(statearr_27599_30358[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27554 === (8))){
var inst_27538 = (state_27553[(8)]);
var inst_27544 = (state_27553[(2)]);
var state_27553__$1 = (function (){var statearr_27606 = state_27553;
(statearr_27606[(10)] = inst_27544);

return statearr_27606;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27553__$1,(9),results,inst_27538);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0 = (function (){
var statearr_27608 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27608[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__);

(statearr_27608[(1)] = (1));

return statearr_27608;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1 = (function (state_27553){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_27553);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e27609){var ex__26718__auto__ = e27609;
var statearr_27610_30361 = state_27553;
(statearr_27610_30361[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_27553[(4)]))){
var statearr_27611_30362 = state_27553;
(statearr_27611_30362[(1)] = cljs.core.first((state_27553[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30363 = state_27553;
state_27553 = G__30363;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = function(state_27553){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1.call(this,state_27553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_27619 = f__27075__auto__();
(statearr_27619[(6)] = c__27074__auto___30346);

return statearr_27619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


var c__27074__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_27662){
var state_val_27663 = (state_27662[(1)]);
if((state_val_27663 === (7))){
var inst_27658 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
var statearr_27670_30368 = state_27662__$1;
(statearr_27670_30368[(2)] = inst_27658);

(statearr_27670_30368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (20))){
var state_27662__$1 = state_27662;
var statearr_27671_30374 = state_27662__$1;
(statearr_27671_30374[(2)] = null);

(statearr_27671_30374[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (1))){
var state_27662__$1 = state_27662;
var statearr_27672_30382 = state_27662__$1;
(statearr_27672_30382[(2)] = null);

(statearr_27672_30382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (4))){
var inst_27624 = (state_27662[(7)]);
var inst_27624__$1 = (state_27662[(2)]);
var inst_27625 = (inst_27624__$1 == null);
var state_27662__$1 = (function (){var statearr_27677 = state_27662;
(statearr_27677[(7)] = inst_27624__$1);

return statearr_27677;
})();
if(cljs.core.truth_(inst_27625)){
var statearr_27678_30385 = state_27662__$1;
(statearr_27678_30385[(1)] = (5));

} else {
var statearr_27679_30386 = state_27662__$1;
(statearr_27679_30386[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (15))){
var inst_27640 = (state_27662[(8)]);
var state_27662__$1 = state_27662;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27662__$1,(18),to,inst_27640);
} else {
if((state_val_27663 === (21))){
var inst_27653 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
var statearr_27680_30394 = state_27662__$1;
(statearr_27680_30394[(2)] = inst_27653);

(statearr_27680_30394[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (13))){
var inst_27655 = (state_27662[(2)]);
var state_27662__$1 = (function (){var statearr_27686 = state_27662;
(statearr_27686[(9)] = inst_27655);

return statearr_27686;
})();
var statearr_27689_30396 = state_27662__$1;
(statearr_27689_30396[(2)] = null);

(statearr_27689_30396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (6))){
var inst_27624 = (state_27662[(7)]);
var state_27662__$1 = state_27662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27662__$1,(11),inst_27624);
} else {
if((state_val_27663 === (17))){
var inst_27648 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
if(cljs.core.truth_(inst_27648)){
var statearr_27700_30402 = state_27662__$1;
(statearr_27700_30402[(1)] = (19));

} else {
var statearr_27701_30403 = state_27662__$1;
(statearr_27701_30403[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (3))){
var inst_27660 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27662__$1,inst_27660);
} else {
if((state_val_27663 === (12))){
var inst_27634 = (state_27662[(10)]);
var state_27662__$1 = state_27662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27662__$1,(14),inst_27634);
} else {
if((state_val_27663 === (2))){
var state_27662__$1 = state_27662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27662__$1,(4),results);
} else {
if((state_val_27663 === (19))){
var state_27662__$1 = state_27662;
var statearr_27702_30404 = state_27662__$1;
(statearr_27702_30404[(2)] = null);

(statearr_27702_30404[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (11))){
var inst_27634 = (state_27662[(2)]);
var state_27662__$1 = (function (){var statearr_27707 = state_27662;
(statearr_27707[(10)] = inst_27634);

return statearr_27707;
})();
var statearr_27709_30412 = state_27662__$1;
(statearr_27709_30412[(2)] = null);

(statearr_27709_30412[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (9))){
var state_27662__$1 = state_27662;
var statearr_27717_30416 = state_27662__$1;
(statearr_27717_30416[(2)] = null);

(statearr_27717_30416[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (5))){
var state_27662__$1 = state_27662;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27727_30417 = state_27662__$1;
(statearr_27727_30417[(1)] = (8));

} else {
var statearr_27728_30418 = state_27662__$1;
(statearr_27728_30418[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (14))){
var inst_27640 = (state_27662[(8)]);
var inst_27640__$1 = (state_27662[(2)]);
var inst_27641 = (inst_27640__$1 == null);
var inst_27642 = cljs.core.not(inst_27641);
var state_27662__$1 = (function (){var statearr_27729 = state_27662;
(statearr_27729[(8)] = inst_27640__$1);

return statearr_27729;
})();
if(inst_27642){
var statearr_27734_30426 = state_27662__$1;
(statearr_27734_30426[(1)] = (15));

} else {
var statearr_27735_30427 = state_27662__$1;
(statearr_27735_30427[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (16))){
var state_27662__$1 = state_27662;
var statearr_27744_30430 = state_27662__$1;
(statearr_27744_30430[(2)] = false);

(statearr_27744_30430[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (10))){
var inst_27631 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
var statearr_27753_30434 = state_27662__$1;
(statearr_27753_30434[(2)] = inst_27631);

(statearr_27753_30434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (18))){
var inst_27645 = (state_27662[(2)]);
var state_27662__$1 = state_27662;
var statearr_27765_30435 = state_27662__$1;
(statearr_27765_30435[(2)] = inst_27645);

(statearr_27765_30435[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27663 === (8))){
var inst_27628 = cljs.core.async.close_BANG_(to);
var state_27662__$1 = state_27662;
var statearr_27767_30436 = state_27662__$1;
(statearr_27767_30436[(2)] = inst_27628);

(statearr_27767_30436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0 = (function (){
var statearr_27771 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27771[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__);

(statearr_27771[(1)] = (1));

return statearr_27771;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1 = (function (state_27662){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_27662);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e27772){var ex__26718__auto__ = e27772;
var statearr_27773_30445 = state_27662;
(statearr_27773_30445[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_27662[(4)]))){
var statearr_27775_30446 = state_27662;
(statearr_27775_30446[(1)] = cljs.core.first((state_27662[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30452 = state_27662;
state_27662 = G__30452;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__ = function(state_27662){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1.call(this,state_27662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_27777 = f__27075__auto__();
(statearr_27777[(6)] = c__27074__auto__);

return statearr_27777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));

return c__27074__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__27786 = arguments.length;
switch (G__27786) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__27790 = arguments.length;
switch (G__27790) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__27807 = arguments.length;
switch (G__27807) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__27074__auto___30483 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_27834){
var state_val_27835 = (state_27834[(1)]);
if((state_val_27835 === (7))){
var inst_27830 = (state_27834[(2)]);
var state_27834__$1 = state_27834;
var statearr_27836_30487 = state_27834__$1;
(statearr_27836_30487[(2)] = inst_27830);

(statearr_27836_30487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (1))){
var state_27834__$1 = state_27834;
var statearr_27837_30488 = state_27834__$1;
(statearr_27837_30488[(2)] = null);

(statearr_27837_30488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (4))){
var inst_27811 = (state_27834[(7)]);
var inst_27811__$1 = (state_27834[(2)]);
var inst_27812 = (inst_27811__$1 == null);
var state_27834__$1 = (function (){var statearr_27840 = state_27834;
(statearr_27840[(7)] = inst_27811__$1);

return statearr_27840;
})();
if(cljs.core.truth_(inst_27812)){
var statearr_27847_30489 = state_27834__$1;
(statearr_27847_30489[(1)] = (5));

} else {
var statearr_27848_30490 = state_27834__$1;
(statearr_27848_30490[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (13))){
var state_27834__$1 = state_27834;
var statearr_27849_30492 = state_27834__$1;
(statearr_27849_30492[(2)] = null);

(statearr_27849_30492[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (6))){
var inst_27811 = (state_27834[(7)]);
var inst_27817 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_27811) : p.call(null,inst_27811));
var state_27834__$1 = state_27834;
if(cljs.core.truth_(inst_27817)){
var statearr_27853_30493 = state_27834__$1;
(statearr_27853_30493[(1)] = (9));

} else {
var statearr_27854_30494 = state_27834__$1;
(statearr_27854_30494[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (3))){
var inst_27832 = (state_27834[(2)]);
var state_27834__$1 = state_27834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27834__$1,inst_27832);
} else {
if((state_val_27835 === (12))){
var state_27834__$1 = state_27834;
var statearr_27855_30498 = state_27834__$1;
(statearr_27855_30498[(2)] = null);

(statearr_27855_30498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (2))){
var state_27834__$1 = state_27834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27834__$1,(4),ch);
} else {
if((state_val_27835 === (11))){
var inst_27811 = (state_27834[(7)]);
var inst_27821 = (state_27834[(2)]);
var state_27834__$1 = state_27834;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27834__$1,(8),inst_27821,inst_27811);
} else {
if((state_val_27835 === (9))){
var state_27834__$1 = state_27834;
var statearr_27863_30502 = state_27834__$1;
(statearr_27863_30502[(2)] = tc);

(statearr_27863_30502[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (5))){
var inst_27814 = cljs.core.async.close_BANG_(tc);
var inst_27815 = cljs.core.async.close_BANG_(fc);
var state_27834__$1 = (function (){var statearr_27870 = state_27834;
(statearr_27870[(8)] = inst_27814);

return statearr_27870;
})();
var statearr_27871_30503 = state_27834__$1;
(statearr_27871_30503[(2)] = inst_27815);

(statearr_27871_30503[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (14))){
var inst_27828 = (state_27834[(2)]);
var state_27834__$1 = state_27834;
var statearr_27875_30507 = state_27834__$1;
(statearr_27875_30507[(2)] = inst_27828);

(statearr_27875_30507[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (10))){
var state_27834__$1 = state_27834;
var statearr_27876_30508 = state_27834__$1;
(statearr_27876_30508[(2)] = fc);

(statearr_27876_30508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27835 === (8))){
var inst_27823 = (state_27834[(2)]);
var state_27834__$1 = state_27834;
if(cljs.core.truth_(inst_27823)){
var statearr_27877_30509 = state_27834__$1;
(statearr_27877_30509[(1)] = (12));

} else {
var statearr_27878_30510 = state_27834__$1;
(statearr_27878_30510[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_27879 = [null,null,null,null,null,null,null,null,null];
(statearr_27879[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_27879[(1)] = (1));

return statearr_27879;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_27834){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_27834);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e27880){var ex__26718__auto__ = e27880;
var statearr_27881_30514 = state_27834;
(statearr_27881_30514[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_27834[(4)]))){
var statearr_27882_30515 = state_27834;
(statearr_27882_30515[(1)] = cljs.core.first((state_27834[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30516 = state_27834;
state_27834 = G__30516;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_27834){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_27834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_27887 = f__27075__auto__();
(statearr_27887[(6)] = c__27074__auto___30483);

return statearr_27887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__27074__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_27911){
var state_val_27912 = (state_27911[(1)]);
if((state_val_27912 === (7))){
var inst_27907 = (state_27911[(2)]);
var state_27911__$1 = state_27911;
var statearr_27918_30520 = state_27911__$1;
(statearr_27918_30520[(2)] = inst_27907);

(statearr_27918_30520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27912 === (1))){
var inst_27888 = init;
var inst_27889 = inst_27888;
var state_27911__$1 = (function (){var statearr_27921 = state_27911;
(statearr_27921[(7)] = inst_27889);

return statearr_27921;
})();
var statearr_27922_30521 = state_27911__$1;
(statearr_27922_30521[(2)] = null);

(statearr_27922_30521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27912 === (4))){
var inst_27892 = (state_27911[(8)]);
var inst_27892__$1 = (state_27911[(2)]);
var inst_27893 = (inst_27892__$1 == null);
var state_27911__$1 = (function (){var statearr_27928 = state_27911;
(statearr_27928[(8)] = inst_27892__$1);

return statearr_27928;
})();
if(cljs.core.truth_(inst_27893)){
var statearr_27929_30522 = state_27911__$1;
(statearr_27929_30522[(1)] = (5));

} else {
var statearr_27930_30523 = state_27911__$1;
(statearr_27930_30523[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27912 === (6))){
var inst_27889 = (state_27911[(7)]);
var inst_27896 = (state_27911[(9)]);
var inst_27892 = (state_27911[(8)]);
var inst_27896__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_27889,inst_27892) : f.call(null,inst_27889,inst_27892));
var inst_27897 = cljs.core.reduced_QMARK_(inst_27896__$1);
var state_27911__$1 = (function (){var statearr_27931 = state_27911;
(statearr_27931[(9)] = inst_27896__$1);

return statearr_27931;
})();
if(inst_27897){
var statearr_27932_30527 = state_27911__$1;
(statearr_27932_30527[(1)] = (8));

} else {
var statearr_27933_30528 = state_27911__$1;
(statearr_27933_30528[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27912 === (3))){
var inst_27909 = (state_27911[(2)]);
var state_27911__$1 = state_27911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27911__$1,inst_27909);
} else {
if((state_val_27912 === (2))){
var state_27911__$1 = state_27911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27911__$1,(4),ch);
} else {
if((state_val_27912 === (9))){
var inst_27896 = (state_27911[(9)]);
var inst_27889 = inst_27896;
var state_27911__$1 = (function (){var statearr_27934 = state_27911;
(statearr_27934[(7)] = inst_27889);

return statearr_27934;
})();
var statearr_27935_30530 = state_27911__$1;
(statearr_27935_30530[(2)] = null);

(statearr_27935_30530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27912 === (5))){
var inst_27889 = (state_27911[(7)]);
var state_27911__$1 = state_27911;
var statearr_27936_30531 = state_27911__$1;
(statearr_27936_30531[(2)] = inst_27889);

(statearr_27936_30531[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27912 === (10))){
var inst_27905 = (state_27911[(2)]);
var state_27911__$1 = state_27911;
var statearr_27951_30533 = state_27911__$1;
(statearr_27951_30533[(2)] = inst_27905);

(statearr_27951_30533[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27912 === (8))){
var inst_27896 = (state_27911[(9)]);
var inst_27901 = cljs.core.deref(inst_27896);
var state_27911__$1 = state_27911;
var statearr_27958_30544 = state_27911__$1;
(statearr_27958_30544[(2)] = inst_27901);

(statearr_27958_30544[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__26715__auto__ = null;
var cljs$core$async$reduce_$_state_machine__26715__auto____0 = (function (){
var statearr_27959 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27959[(0)] = cljs$core$async$reduce_$_state_machine__26715__auto__);

(statearr_27959[(1)] = (1));

return statearr_27959;
});
var cljs$core$async$reduce_$_state_machine__26715__auto____1 = (function (state_27911){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_27911);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e27960){var ex__26718__auto__ = e27960;
var statearr_27961_30545 = state_27911;
(statearr_27961_30545[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_27911[(4)]))){
var statearr_27962_30546 = state_27911;
(statearr_27962_30546[(1)] = cljs.core.first((state_27911[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30547 = state_27911;
state_27911 = G__30547;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__26715__auto__ = function(state_27911){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__26715__auto____1.call(this,state_27911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__26715__auto____0;
cljs$core$async$reduce_$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__26715__auto____1;
return cljs$core$async$reduce_$_state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_27963 = f__27075__auto__();
(statearr_27963[(6)] = c__27074__auto__);

return statearr_27963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));

return c__27074__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__27074__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_27969){
var state_val_27970 = (state_27969[(1)]);
if((state_val_27970 === (1))){
var inst_27964 = cljs.core.async.reduce(f__$1,init,ch);
var state_27969__$1 = state_27969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27969__$1,(2),inst_27964);
} else {
if((state_val_27970 === (2))){
var inst_27966 = (state_27969[(2)]);
var inst_27967 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_27966) : f__$1.call(null,inst_27966));
var state_27969__$1 = state_27969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27969__$1,inst_27967);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__26715__auto__ = null;
var cljs$core$async$transduce_$_state_machine__26715__auto____0 = (function (){
var statearr_27971 = [null,null,null,null,null,null,null];
(statearr_27971[(0)] = cljs$core$async$transduce_$_state_machine__26715__auto__);

(statearr_27971[(1)] = (1));

return statearr_27971;
});
var cljs$core$async$transduce_$_state_machine__26715__auto____1 = (function (state_27969){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_27969);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e27972){var ex__26718__auto__ = e27972;
var statearr_27973_30564 = state_27969;
(statearr_27973_30564[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_27969[(4)]))){
var statearr_27974_30567 = state_27969;
(statearr_27974_30567[(1)] = cljs.core.first((state_27969[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30578 = state_27969;
state_27969 = G__30578;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__26715__auto__ = function(state_27969){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__26715__auto____1.call(this,state_27969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__26715__auto____0;
cljs$core$async$transduce_$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__26715__auto____1;
return cljs$core$async$transduce_$_state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_27975 = f__27075__auto__();
(statearr_27975[(6)] = c__27074__auto__);

return statearr_27975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));

return c__27074__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__27978 = arguments.length;
switch (G__27978) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__27074__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_28006){
var state_val_28007 = (state_28006[(1)]);
if((state_val_28007 === (7))){
var inst_27988 = (state_28006[(2)]);
var state_28006__$1 = state_28006;
var statearr_28008_30587 = state_28006__$1;
(statearr_28008_30587[(2)] = inst_27988);

(statearr_28008_30587[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (1))){
var inst_27979 = cljs.core.seq(coll);
var inst_27980 = inst_27979;
var state_28006__$1 = (function (){var statearr_28009 = state_28006;
(statearr_28009[(7)] = inst_27980);

return statearr_28009;
})();
var statearr_28013_30588 = state_28006__$1;
(statearr_28013_30588[(2)] = null);

(statearr_28013_30588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (4))){
var inst_27980 = (state_28006[(7)]);
var inst_27983 = cljs.core.first(inst_27980);
var state_28006__$1 = state_28006;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28006__$1,(7),ch,inst_27983);
} else {
if((state_val_28007 === (13))){
var inst_28000 = (state_28006[(2)]);
var state_28006__$1 = state_28006;
var statearr_28014_30591 = state_28006__$1;
(statearr_28014_30591[(2)] = inst_28000);

(statearr_28014_30591[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (6))){
var inst_27991 = (state_28006[(2)]);
var state_28006__$1 = state_28006;
if(cljs.core.truth_(inst_27991)){
var statearr_28015_30601 = state_28006__$1;
(statearr_28015_30601[(1)] = (8));

} else {
var statearr_28016_30602 = state_28006__$1;
(statearr_28016_30602[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (3))){
var inst_28004 = (state_28006[(2)]);
var state_28006__$1 = state_28006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28006__$1,inst_28004);
} else {
if((state_val_28007 === (12))){
var state_28006__$1 = state_28006;
var statearr_28017_30603 = state_28006__$1;
(statearr_28017_30603[(2)] = null);

(statearr_28017_30603[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (2))){
var inst_27980 = (state_28006[(7)]);
var state_28006__$1 = state_28006;
if(cljs.core.truth_(inst_27980)){
var statearr_28018_30604 = state_28006__$1;
(statearr_28018_30604[(1)] = (4));

} else {
var statearr_28019_30605 = state_28006__$1;
(statearr_28019_30605[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (11))){
var inst_27997 = cljs.core.async.close_BANG_(ch);
var state_28006__$1 = state_28006;
var statearr_28023_30609 = state_28006__$1;
(statearr_28023_30609[(2)] = inst_27997);

(statearr_28023_30609[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (9))){
var state_28006__$1 = state_28006;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28024_30610 = state_28006__$1;
(statearr_28024_30610[(1)] = (11));

} else {
var statearr_28025_30611 = state_28006__$1;
(statearr_28025_30611[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (5))){
var inst_27980 = (state_28006[(7)]);
var state_28006__$1 = state_28006;
var statearr_28026_30612 = state_28006__$1;
(statearr_28026_30612[(2)] = inst_27980);

(statearr_28026_30612[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (10))){
var inst_28002 = (state_28006[(2)]);
var state_28006__$1 = state_28006;
var statearr_28027_30613 = state_28006__$1;
(statearr_28027_30613[(2)] = inst_28002);

(statearr_28027_30613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28007 === (8))){
var inst_27980 = (state_28006[(7)]);
var inst_27993 = cljs.core.next(inst_27980);
var inst_27980__$1 = inst_27993;
var state_28006__$1 = (function (){var statearr_28029 = state_28006;
(statearr_28029[(7)] = inst_27980__$1);

return statearr_28029;
})();
var statearr_28033_30614 = state_28006__$1;
(statearr_28033_30614[(2)] = null);

(statearr_28033_30614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_28036 = [null,null,null,null,null,null,null,null];
(statearr_28036[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_28036[(1)] = (1));

return statearr_28036;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_28006){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_28006);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e28037){var ex__26718__auto__ = e28037;
var statearr_28038_30615 = state_28006;
(statearr_28038_30615[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_28006[(4)]))){
var statearr_28040_30616 = state_28006;
(statearr_28040_30616[(1)] = cljs.core.first((state_28006[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30621 = state_28006;
state_28006 = G__30621;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_28006){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_28006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_28041 = f__27075__auto__();
(statearr_28041[(6)] = c__27074__auto__);

return statearr_28041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));

return c__27074__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__28043 = arguments.length;
switch (G__28043) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_30633 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_30633(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_30634 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_30634(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_30643 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_30643(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_30644 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_30644(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28061 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28061 = (function (ch,cs,meta28062){
this.ch = ch;
this.cs = cs;
this.meta28062 = meta28062;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28061.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28063,meta28062__$1){
var self__ = this;
var _28063__$1 = this;
return (new cljs.core.async.t_cljs$core$async28061(self__.ch,self__.cs,meta28062__$1));
}));

(cljs.core.async.t_cljs$core$async28061.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28063){
var self__ = this;
var _28063__$1 = this;
return self__.meta28062;
}));

(cljs.core.async.t_cljs$core$async28061.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28061.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async28061.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28061.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async28061.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async28061.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async28061.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta28062","meta28062",2037030123,null)], null);
}));

(cljs.core.async.t_cljs$core$async28061.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28061.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28061");

(cljs.core.async.t_cljs$core$async28061.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28061");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28061.
 */
cljs.core.async.__GT_t_cljs$core$async28061 = (function cljs$core$async$mult_$___GT_t_cljs$core$async28061(ch__$1,cs__$1,meta28062){
return (new cljs.core.async.t_cljs$core$async28061(ch__$1,cs__$1,meta28062));
});

}

return (new cljs.core.async.t_cljs$core$async28061(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__27074__auto___30658 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_28207){
var state_val_28208 = (state_28207[(1)]);
if((state_val_28208 === (7))){
var inst_28203 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
var statearr_28215_30659 = state_28207__$1;
(statearr_28215_30659[(2)] = inst_28203);

(statearr_28215_30659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (20))){
var inst_28105 = (state_28207[(7)]);
var inst_28117 = cljs.core.first(inst_28105);
var inst_28118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28117,(0),null);
var inst_28119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28117,(1),null);
var state_28207__$1 = (function (){var statearr_28216 = state_28207;
(statearr_28216[(8)] = inst_28118);

return statearr_28216;
})();
if(cljs.core.truth_(inst_28119)){
var statearr_28217_30660 = state_28207__$1;
(statearr_28217_30660[(1)] = (22));

} else {
var statearr_28219_30662 = state_28207__$1;
(statearr_28219_30662[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (27))){
var inst_28147 = (state_28207[(9)]);
var inst_28154 = (state_28207[(10)]);
var inst_28149 = (state_28207[(11)]);
var inst_28072 = (state_28207[(12)]);
var inst_28154__$1 = cljs.core._nth(inst_28147,inst_28149);
var inst_28155 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_28154__$1,inst_28072,done);
var state_28207__$1 = (function (){var statearr_28220 = state_28207;
(statearr_28220[(10)] = inst_28154__$1);

return statearr_28220;
})();
if(cljs.core.truth_(inst_28155)){
var statearr_28221_30664 = state_28207__$1;
(statearr_28221_30664[(1)] = (30));

} else {
var statearr_28222_30665 = state_28207__$1;
(statearr_28222_30665[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (1))){
var state_28207__$1 = state_28207;
var statearr_28223_30666 = state_28207__$1;
(statearr_28223_30666[(2)] = null);

(statearr_28223_30666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (24))){
var inst_28105 = (state_28207[(7)]);
var inst_28124 = (state_28207[(2)]);
var inst_28125 = cljs.core.next(inst_28105);
var inst_28083 = inst_28125;
var inst_28084 = null;
var inst_28085 = (0);
var inst_28086 = (0);
var state_28207__$1 = (function (){var statearr_28236 = state_28207;
(statearr_28236[(13)] = inst_28084);

(statearr_28236[(14)] = inst_28085);

(statearr_28236[(15)] = inst_28086);

(statearr_28236[(16)] = inst_28124);

(statearr_28236[(17)] = inst_28083);

return statearr_28236;
})();
var statearr_28243_30669 = state_28207__$1;
(statearr_28243_30669[(2)] = null);

(statearr_28243_30669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (39))){
var state_28207__$1 = state_28207;
var statearr_28263_30670 = state_28207__$1;
(statearr_28263_30670[(2)] = null);

(statearr_28263_30670[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (4))){
var inst_28072 = (state_28207[(12)]);
var inst_28072__$1 = (state_28207[(2)]);
var inst_28075 = (inst_28072__$1 == null);
var state_28207__$1 = (function (){var statearr_28265 = state_28207;
(statearr_28265[(12)] = inst_28072__$1);

return statearr_28265;
})();
if(cljs.core.truth_(inst_28075)){
var statearr_28266_30671 = state_28207__$1;
(statearr_28266_30671[(1)] = (5));

} else {
var statearr_28267_30672 = state_28207__$1;
(statearr_28267_30672[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (15))){
var inst_28084 = (state_28207[(13)]);
var inst_28085 = (state_28207[(14)]);
var inst_28086 = (state_28207[(15)]);
var inst_28083 = (state_28207[(17)]);
var inst_28101 = (state_28207[(2)]);
var inst_28102 = (inst_28086 + (1));
var tmp28255 = inst_28084;
var tmp28257 = inst_28085;
var tmp28258 = inst_28083;
var inst_28083__$1 = tmp28258;
var inst_28084__$1 = tmp28255;
var inst_28085__$1 = tmp28257;
var inst_28086__$1 = inst_28102;
var state_28207__$1 = (function (){var statearr_28274 = state_28207;
(statearr_28274[(18)] = inst_28101);

(statearr_28274[(13)] = inst_28084__$1);

(statearr_28274[(14)] = inst_28085__$1);

(statearr_28274[(15)] = inst_28086__$1);

(statearr_28274[(17)] = inst_28083__$1);

return statearr_28274;
})();
var statearr_28279_30674 = state_28207__$1;
(statearr_28279_30674[(2)] = null);

(statearr_28279_30674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (21))){
var inst_28128 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
var statearr_28285_30679 = state_28207__$1;
(statearr_28285_30679[(2)] = inst_28128);

(statearr_28285_30679[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (31))){
var inst_28154 = (state_28207[(10)]);
var inst_28158 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_28154);
var state_28207__$1 = state_28207;
var statearr_28286_30680 = state_28207__$1;
(statearr_28286_30680[(2)] = inst_28158);

(statearr_28286_30680[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (32))){
var inst_28147 = (state_28207[(9)]);
var inst_28148 = (state_28207[(19)]);
var inst_28149 = (state_28207[(11)]);
var inst_28146 = (state_28207[(20)]);
var inst_28160 = (state_28207[(2)]);
var inst_28161 = (inst_28149 + (1));
var tmp28282 = inst_28147;
var tmp28283 = inst_28148;
var tmp28284 = inst_28146;
var inst_28146__$1 = tmp28284;
var inst_28147__$1 = tmp28282;
var inst_28148__$1 = tmp28283;
var inst_28149__$1 = inst_28161;
var state_28207__$1 = (function (){var statearr_28287 = state_28207;
(statearr_28287[(9)] = inst_28147__$1);

(statearr_28287[(19)] = inst_28148__$1);

(statearr_28287[(11)] = inst_28149__$1);

(statearr_28287[(20)] = inst_28146__$1);

(statearr_28287[(21)] = inst_28160);

return statearr_28287;
})();
var statearr_28288_30683 = state_28207__$1;
(statearr_28288_30683[(2)] = null);

(statearr_28288_30683[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (40))){
var inst_28173 = (state_28207[(22)]);
var inst_28177 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_28173);
var state_28207__$1 = state_28207;
var statearr_28290_30689 = state_28207__$1;
(statearr_28290_30689[(2)] = inst_28177);

(statearr_28290_30689[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (33))){
var inst_28164 = (state_28207[(23)]);
var inst_28166 = cljs.core.chunked_seq_QMARK_(inst_28164);
var state_28207__$1 = state_28207;
if(inst_28166){
var statearr_28292_30690 = state_28207__$1;
(statearr_28292_30690[(1)] = (36));

} else {
var statearr_28293_30691 = state_28207__$1;
(statearr_28293_30691[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (13))){
var inst_28095 = (state_28207[(24)]);
var inst_28098 = cljs.core.async.close_BANG_(inst_28095);
var state_28207__$1 = state_28207;
var statearr_28294_30692 = state_28207__$1;
(statearr_28294_30692[(2)] = inst_28098);

(statearr_28294_30692[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (22))){
var inst_28118 = (state_28207[(8)]);
var inst_28121 = cljs.core.async.close_BANG_(inst_28118);
var state_28207__$1 = state_28207;
var statearr_28295_30693 = state_28207__$1;
(statearr_28295_30693[(2)] = inst_28121);

(statearr_28295_30693[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (36))){
var inst_28164 = (state_28207[(23)]);
var inst_28168 = cljs.core.chunk_first(inst_28164);
var inst_28169 = cljs.core.chunk_rest(inst_28164);
var inst_28170 = cljs.core.count(inst_28168);
var inst_28146 = inst_28169;
var inst_28147 = inst_28168;
var inst_28148 = inst_28170;
var inst_28149 = (0);
var state_28207__$1 = (function (){var statearr_28296 = state_28207;
(statearr_28296[(9)] = inst_28147);

(statearr_28296[(19)] = inst_28148);

(statearr_28296[(11)] = inst_28149);

(statearr_28296[(20)] = inst_28146);

return statearr_28296;
})();
var statearr_28297_30704 = state_28207__$1;
(statearr_28297_30704[(2)] = null);

(statearr_28297_30704[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (41))){
var inst_28164 = (state_28207[(23)]);
var inst_28179 = (state_28207[(2)]);
var inst_28180 = cljs.core.next(inst_28164);
var inst_28146 = inst_28180;
var inst_28147 = null;
var inst_28148 = (0);
var inst_28149 = (0);
var state_28207__$1 = (function (){var statearr_28299 = state_28207;
(statearr_28299[(9)] = inst_28147);

(statearr_28299[(19)] = inst_28148);

(statearr_28299[(25)] = inst_28179);

(statearr_28299[(11)] = inst_28149);

(statearr_28299[(20)] = inst_28146);

return statearr_28299;
})();
var statearr_28301_30725 = state_28207__$1;
(statearr_28301_30725[(2)] = null);

(statearr_28301_30725[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (43))){
var state_28207__$1 = state_28207;
var statearr_28302_30728 = state_28207__$1;
(statearr_28302_30728[(2)] = null);

(statearr_28302_30728[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (29))){
var inst_28188 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
var statearr_28303_30732 = state_28207__$1;
(statearr_28303_30732[(2)] = inst_28188);

(statearr_28303_30732[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (44))){
var inst_28200 = (state_28207[(2)]);
var state_28207__$1 = (function (){var statearr_28304 = state_28207;
(statearr_28304[(26)] = inst_28200);

return statearr_28304;
})();
var statearr_28305_30733 = state_28207__$1;
(statearr_28305_30733[(2)] = null);

(statearr_28305_30733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (6))){
var inst_28138 = (state_28207[(27)]);
var inst_28137 = cljs.core.deref(cs);
var inst_28138__$1 = cljs.core.keys(inst_28137);
var inst_28139 = cljs.core.count(inst_28138__$1);
var inst_28140 = cljs.core.reset_BANG_(dctr,inst_28139);
var inst_28145 = cljs.core.seq(inst_28138__$1);
var inst_28146 = inst_28145;
var inst_28147 = null;
var inst_28148 = (0);
var inst_28149 = (0);
var state_28207__$1 = (function (){var statearr_28309 = state_28207;
(statearr_28309[(9)] = inst_28147);

(statearr_28309[(19)] = inst_28148);

(statearr_28309[(28)] = inst_28140);

(statearr_28309[(11)] = inst_28149);

(statearr_28309[(27)] = inst_28138__$1);

(statearr_28309[(20)] = inst_28146);

return statearr_28309;
})();
var statearr_28310_30735 = state_28207__$1;
(statearr_28310_30735[(2)] = null);

(statearr_28310_30735[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (28))){
var inst_28146 = (state_28207[(20)]);
var inst_28164 = (state_28207[(23)]);
var inst_28164__$1 = cljs.core.seq(inst_28146);
var state_28207__$1 = (function (){var statearr_28311 = state_28207;
(statearr_28311[(23)] = inst_28164__$1);

return statearr_28311;
})();
if(inst_28164__$1){
var statearr_28312_30741 = state_28207__$1;
(statearr_28312_30741[(1)] = (33));

} else {
var statearr_28313_30742 = state_28207__$1;
(statearr_28313_30742[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (25))){
var inst_28148 = (state_28207[(19)]);
var inst_28149 = (state_28207[(11)]);
var inst_28151 = (inst_28149 < inst_28148);
var inst_28152 = inst_28151;
var state_28207__$1 = state_28207;
if(cljs.core.truth_(inst_28152)){
var statearr_28314_30744 = state_28207__$1;
(statearr_28314_30744[(1)] = (27));

} else {
var statearr_28315_30745 = state_28207__$1;
(statearr_28315_30745[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (34))){
var state_28207__$1 = state_28207;
var statearr_28316_30746 = state_28207__$1;
(statearr_28316_30746[(2)] = null);

(statearr_28316_30746[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (17))){
var state_28207__$1 = state_28207;
var statearr_28317_30747 = state_28207__$1;
(statearr_28317_30747[(2)] = null);

(statearr_28317_30747[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (3))){
var inst_28205 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28207__$1,inst_28205);
} else {
if((state_val_28208 === (12))){
var inst_28133 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
var statearr_28318_30753 = state_28207__$1;
(statearr_28318_30753[(2)] = inst_28133);

(statearr_28318_30753[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (2))){
var state_28207__$1 = state_28207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28207__$1,(4),ch);
} else {
if((state_val_28208 === (23))){
var state_28207__$1 = state_28207;
var statearr_28319_30757 = state_28207__$1;
(statearr_28319_30757[(2)] = null);

(statearr_28319_30757[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (35))){
var inst_28186 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
var statearr_28320_30759 = state_28207__$1;
(statearr_28320_30759[(2)] = inst_28186);

(statearr_28320_30759[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (19))){
var inst_28105 = (state_28207[(7)]);
var inst_28109 = cljs.core.chunk_first(inst_28105);
var inst_28110 = cljs.core.chunk_rest(inst_28105);
var inst_28111 = cljs.core.count(inst_28109);
var inst_28083 = inst_28110;
var inst_28084 = inst_28109;
var inst_28085 = inst_28111;
var inst_28086 = (0);
var state_28207__$1 = (function (){var statearr_28321 = state_28207;
(statearr_28321[(13)] = inst_28084);

(statearr_28321[(14)] = inst_28085);

(statearr_28321[(15)] = inst_28086);

(statearr_28321[(17)] = inst_28083);

return statearr_28321;
})();
var statearr_28322_30761 = state_28207__$1;
(statearr_28322_30761[(2)] = null);

(statearr_28322_30761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (11))){
var inst_28083 = (state_28207[(17)]);
var inst_28105 = (state_28207[(7)]);
var inst_28105__$1 = cljs.core.seq(inst_28083);
var state_28207__$1 = (function (){var statearr_28323 = state_28207;
(statearr_28323[(7)] = inst_28105__$1);

return statearr_28323;
})();
if(inst_28105__$1){
var statearr_28324_30762 = state_28207__$1;
(statearr_28324_30762[(1)] = (16));

} else {
var statearr_28325_30764 = state_28207__$1;
(statearr_28325_30764[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (9))){
var inst_28135 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
var statearr_28327_30766 = state_28207__$1;
(statearr_28327_30766[(2)] = inst_28135);

(statearr_28327_30766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (5))){
var inst_28081 = cljs.core.deref(cs);
var inst_28082 = cljs.core.seq(inst_28081);
var inst_28083 = inst_28082;
var inst_28084 = null;
var inst_28085 = (0);
var inst_28086 = (0);
var state_28207__$1 = (function (){var statearr_28328 = state_28207;
(statearr_28328[(13)] = inst_28084);

(statearr_28328[(14)] = inst_28085);

(statearr_28328[(15)] = inst_28086);

(statearr_28328[(17)] = inst_28083);

return statearr_28328;
})();
var statearr_28329_30770 = state_28207__$1;
(statearr_28329_30770[(2)] = null);

(statearr_28329_30770[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (14))){
var state_28207__$1 = state_28207;
var statearr_28330_30772 = state_28207__$1;
(statearr_28330_30772[(2)] = null);

(statearr_28330_30772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (45))){
var inst_28194 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
var statearr_28332_30775 = state_28207__$1;
(statearr_28332_30775[(2)] = inst_28194);

(statearr_28332_30775[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (26))){
var inst_28138 = (state_28207[(27)]);
var inst_28190 = (state_28207[(2)]);
var inst_28191 = cljs.core.seq(inst_28138);
var state_28207__$1 = (function (){var statearr_28333 = state_28207;
(statearr_28333[(29)] = inst_28190);

return statearr_28333;
})();
if(inst_28191){
var statearr_28334_30776 = state_28207__$1;
(statearr_28334_30776[(1)] = (42));

} else {
var statearr_28335_30777 = state_28207__$1;
(statearr_28335_30777[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (16))){
var inst_28105 = (state_28207[(7)]);
var inst_28107 = cljs.core.chunked_seq_QMARK_(inst_28105);
var state_28207__$1 = state_28207;
if(inst_28107){
var statearr_28336_30778 = state_28207__$1;
(statearr_28336_30778[(1)] = (19));

} else {
var statearr_28337_30779 = state_28207__$1;
(statearr_28337_30779[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (38))){
var inst_28183 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
var statearr_28338_30787 = state_28207__$1;
(statearr_28338_30787[(2)] = inst_28183);

(statearr_28338_30787[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (30))){
var state_28207__$1 = state_28207;
var statearr_28339_30788 = state_28207__$1;
(statearr_28339_30788[(2)] = null);

(statearr_28339_30788[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (10))){
var inst_28084 = (state_28207[(13)]);
var inst_28086 = (state_28207[(15)]);
var inst_28094 = cljs.core._nth(inst_28084,inst_28086);
var inst_28095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28094,(0),null);
var inst_28096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28094,(1),null);
var state_28207__$1 = (function (){var statearr_28342 = state_28207;
(statearr_28342[(24)] = inst_28095);

return statearr_28342;
})();
if(cljs.core.truth_(inst_28096)){
var statearr_28344_30791 = state_28207__$1;
(statearr_28344_30791[(1)] = (13));

} else {
var statearr_28345_30792 = state_28207__$1;
(statearr_28345_30792[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (18))){
var inst_28131 = (state_28207[(2)]);
var state_28207__$1 = state_28207;
var statearr_28349_30794 = state_28207__$1;
(statearr_28349_30794[(2)] = inst_28131);

(statearr_28349_30794[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (42))){
var state_28207__$1 = state_28207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28207__$1,(45),dchan);
} else {
if((state_val_28208 === (37))){
var inst_28173 = (state_28207[(22)]);
var inst_28164 = (state_28207[(23)]);
var inst_28072 = (state_28207[(12)]);
var inst_28173__$1 = cljs.core.first(inst_28164);
var inst_28174 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_28173__$1,inst_28072,done);
var state_28207__$1 = (function (){var statearr_28356 = state_28207;
(statearr_28356[(22)] = inst_28173__$1);

return statearr_28356;
})();
if(cljs.core.truth_(inst_28174)){
var statearr_28359_30798 = state_28207__$1;
(statearr_28359_30798[(1)] = (39));

} else {
var statearr_28360_30799 = state_28207__$1;
(statearr_28360_30799[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28208 === (8))){
var inst_28085 = (state_28207[(14)]);
var inst_28086 = (state_28207[(15)]);
var inst_28088 = (inst_28086 < inst_28085);
var inst_28089 = inst_28088;
var state_28207__$1 = state_28207;
if(cljs.core.truth_(inst_28089)){
var statearr_28361_30800 = state_28207__$1;
(statearr_28361_30800[(1)] = (10));

} else {
var statearr_28362_30801 = state_28207__$1;
(statearr_28362_30801[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__26715__auto__ = null;
var cljs$core$async$mult_$_state_machine__26715__auto____0 = (function (){
var statearr_28365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28365[(0)] = cljs$core$async$mult_$_state_machine__26715__auto__);

(statearr_28365[(1)] = (1));

return statearr_28365;
});
var cljs$core$async$mult_$_state_machine__26715__auto____1 = (function (state_28207){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_28207);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e28366){var ex__26718__auto__ = e28366;
var statearr_28367_30815 = state_28207;
(statearr_28367_30815[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_28207[(4)]))){
var statearr_28368_30816 = state_28207;
(statearr_28368_30816[(1)] = cljs.core.first((state_28207[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30820 = state_28207;
state_28207 = G__30820;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__26715__auto__ = function(state_28207){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__26715__auto____1.call(this,state_28207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__26715__auto____0;
cljs$core$async$mult_$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__26715__auto____1;
return cljs$core$async$mult_$_state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_28371 = f__27075__auto__();
(statearr_28371[(6)] = c__27074__auto___30658);

return statearr_28371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__28373 = arguments.length;
switch (G__28373) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_30836 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_30836(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_30840 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_30840(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_30846 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_30846(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_30849 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_30849(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_30854 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_30854(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30858 = arguments.length;
var i__4737__auto___30859 = (0);
while(true){
if((i__4737__auto___30859 < len__4736__auto___30858)){
args__4742__auto__.push((arguments[i__4737__auto___30859]));

var G__30860 = (i__4737__auto___30859 + (1));
i__4737__auto___30859 = G__30860;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__28404){
var map__28405 = p__28404;
var map__28405__$1 = (((((!((map__28405 == null))))?(((((map__28405.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28405.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28405):map__28405);
var opts = map__28405__$1;
var statearr_28410_30862 = state;
(statearr_28410_30862[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_28411_30863 = state;
(statearr_28411_30863[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_28412_30864 = state;
(statearr_28412_30864[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq28396){
var G__28397 = cljs.core.first(seq28396);
var seq28396__$1 = cljs.core.next(seq28396);
var G__28398 = cljs.core.first(seq28396__$1);
var seq28396__$2 = cljs.core.next(seq28396__$1);
var G__28399 = cljs.core.first(seq28396__$2);
var seq28396__$3 = cljs.core.next(seq28396__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28397,G__28398,G__28399,seq28396__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28427 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28427 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta28428){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta28428 = meta28428;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28429,meta28428__$1){
var self__ = this;
var _28429__$1 = this;
return (new cljs.core.async.t_cljs$core$async28427(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta28428__$1));
}));

(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28429){
var self__ = this;
var _28429__$1 = this;
return self__.meta28428;
}));

(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async28427.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async28427.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta28428","meta28428",1606882337,null)], null);
}));

(cljs.core.async.t_cljs$core$async28427.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28427.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28427");

(cljs.core.async.t_cljs$core$async28427.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28427");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28427.
 */
cljs.core.async.__GT_t_cljs$core$async28427 = (function cljs$core$async$mix_$___GT_t_cljs$core$async28427(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta28428){
return (new cljs.core.async.t_cljs$core$async28427(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta28428));
});

}

return (new cljs.core.async.t_cljs$core$async28427(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__27074__auto___30890 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_28577){
var state_val_28578 = (state_28577[(1)]);
if((state_val_28578 === (7))){
var inst_28485 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
var statearr_28580_30895 = state_28577__$1;
(statearr_28580_30895[(2)] = inst_28485);

(statearr_28580_30895[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (20))){
var inst_28497 = (state_28577[(7)]);
var state_28577__$1 = state_28577;
var statearr_28582_30897 = state_28577__$1;
(statearr_28582_30897[(2)] = inst_28497);

(statearr_28582_30897[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (27))){
var state_28577__$1 = state_28577;
var statearr_28586_30899 = state_28577__$1;
(statearr_28586_30899[(2)] = null);

(statearr_28586_30899[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (1))){
var inst_28471 = (state_28577[(8)]);
var inst_28471__$1 = calc_state();
var inst_28473 = (inst_28471__$1 == null);
var inst_28474 = cljs.core.not(inst_28473);
var state_28577__$1 = (function (){var statearr_28593 = state_28577;
(statearr_28593[(8)] = inst_28471__$1);

return statearr_28593;
})();
if(inst_28474){
var statearr_28594_30900 = state_28577__$1;
(statearr_28594_30900[(1)] = (2));

} else {
var statearr_28595_30901 = state_28577__$1;
(statearr_28595_30901[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (24))){
var inst_28522 = (state_28577[(9)]);
var inst_28548 = (state_28577[(10)]);
var inst_28534 = (state_28577[(11)]);
var inst_28548__$1 = (inst_28522.cljs$core$IFn$_invoke$arity$1 ? inst_28522.cljs$core$IFn$_invoke$arity$1(inst_28534) : inst_28522.call(null,inst_28534));
var state_28577__$1 = (function (){var statearr_28596 = state_28577;
(statearr_28596[(10)] = inst_28548__$1);

return statearr_28596;
})();
if(cljs.core.truth_(inst_28548__$1)){
var statearr_28597_30902 = state_28577__$1;
(statearr_28597_30902[(1)] = (29));

} else {
var statearr_28598_30903 = state_28577__$1;
(statearr_28598_30903[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (4))){
var inst_28488 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
if(cljs.core.truth_(inst_28488)){
var statearr_28599_30904 = state_28577__$1;
(statearr_28599_30904[(1)] = (8));

} else {
var statearr_28600_30905 = state_28577__$1;
(statearr_28600_30905[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (15))){
var inst_28516 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
if(cljs.core.truth_(inst_28516)){
var statearr_28601_30906 = state_28577__$1;
(statearr_28601_30906[(1)] = (19));

} else {
var statearr_28602_30907 = state_28577__$1;
(statearr_28602_30907[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (21))){
var inst_28521 = (state_28577[(12)]);
var inst_28521__$1 = (state_28577[(2)]);
var inst_28522 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28521__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_28523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28521__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_28524 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28521__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_28577__$1 = (function (){var statearr_28607 = state_28577;
(statearr_28607[(12)] = inst_28521__$1);

(statearr_28607[(9)] = inst_28522);

(statearr_28607[(13)] = inst_28523);

return statearr_28607;
})();
return cljs.core.async.ioc_alts_BANG_(state_28577__$1,(22),inst_28524);
} else {
if((state_val_28578 === (31))){
var inst_28556 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
if(cljs.core.truth_(inst_28556)){
var statearr_28614_30908 = state_28577__$1;
(statearr_28614_30908[(1)] = (32));

} else {
var statearr_28615_30909 = state_28577__$1;
(statearr_28615_30909[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (32))){
var inst_28533 = (state_28577[(14)]);
var state_28577__$1 = state_28577;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28577__$1,(35),out,inst_28533);
} else {
if((state_val_28578 === (33))){
var inst_28521 = (state_28577[(12)]);
var inst_28497 = inst_28521;
var state_28577__$1 = (function (){var statearr_28617 = state_28577;
(statearr_28617[(7)] = inst_28497);

return statearr_28617;
})();
var statearr_28618_30910 = state_28577__$1;
(statearr_28618_30910[(2)] = null);

(statearr_28618_30910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (13))){
var inst_28497 = (state_28577[(7)]);
var inst_28504 = inst_28497.cljs$lang$protocol_mask$partition0$;
var inst_28505 = (inst_28504 & (64));
var inst_28507 = inst_28497.cljs$core$ISeq$;
var inst_28508 = (cljs.core.PROTOCOL_SENTINEL === inst_28507);
var inst_28509 = ((inst_28505) || (inst_28508));
var state_28577__$1 = state_28577;
if(cljs.core.truth_(inst_28509)){
var statearr_28619_30913 = state_28577__$1;
(statearr_28619_30913[(1)] = (16));

} else {
var statearr_28620_30914 = state_28577__$1;
(statearr_28620_30914[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (22))){
var inst_28534 = (state_28577[(11)]);
var inst_28533 = (state_28577[(14)]);
var inst_28529 = (state_28577[(2)]);
var inst_28533__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28529,(0),null);
var inst_28534__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28529,(1),null);
var inst_28535 = (inst_28533__$1 == null);
var inst_28536 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28534__$1,change);
var inst_28537 = ((inst_28535) || (inst_28536));
var state_28577__$1 = (function (){var statearr_28621 = state_28577;
(statearr_28621[(11)] = inst_28534__$1);

(statearr_28621[(14)] = inst_28533__$1);

return statearr_28621;
})();
if(cljs.core.truth_(inst_28537)){
var statearr_28622_30915 = state_28577__$1;
(statearr_28622_30915[(1)] = (23));

} else {
var statearr_28624_30917 = state_28577__$1;
(statearr_28624_30917[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (36))){
var inst_28521 = (state_28577[(12)]);
var inst_28497 = inst_28521;
var state_28577__$1 = (function (){var statearr_28628 = state_28577;
(statearr_28628[(7)] = inst_28497);

return statearr_28628;
})();
var statearr_28630_30918 = state_28577__$1;
(statearr_28630_30918[(2)] = null);

(statearr_28630_30918[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (29))){
var inst_28548 = (state_28577[(10)]);
var state_28577__$1 = state_28577;
var statearr_28631_30919 = state_28577__$1;
(statearr_28631_30919[(2)] = inst_28548);

(statearr_28631_30919[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (6))){
var state_28577__$1 = state_28577;
var statearr_28633_30920 = state_28577__$1;
(statearr_28633_30920[(2)] = false);

(statearr_28633_30920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (28))){
var inst_28544 = (state_28577[(2)]);
var inst_28545 = calc_state();
var inst_28497 = inst_28545;
var state_28577__$1 = (function (){var statearr_28634 = state_28577;
(statearr_28634[(15)] = inst_28544);

(statearr_28634[(7)] = inst_28497);

return statearr_28634;
})();
var statearr_28635_30921 = state_28577__$1;
(statearr_28635_30921[(2)] = null);

(statearr_28635_30921[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (25))){
var inst_28571 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
var statearr_28638_30925 = state_28577__$1;
(statearr_28638_30925[(2)] = inst_28571);

(statearr_28638_30925[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (34))){
var inst_28569 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
var statearr_28639_30926 = state_28577__$1;
(statearr_28639_30926[(2)] = inst_28569);

(statearr_28639_30926[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (17))){
var state_28577__$1 = state_28577;
var statearr_28640_30927 = state_28577__$1;
(statearr_28640_30927[(2)] = false);

(statearr_28640_30927[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (3))){
var state_28577__$1 = state_28577;
var statearr_28643_30928 = state_28577__$1;
(statearr_28643_30928[(2)] = false);

(statearr_28643_30928[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (12))){
var inst_28574 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28577__$1,inst_28574);
} else {
if((state_val_28578 === (2))){
var inst_28471 = (state_28577[(8)]);
var inst_28476 = inst_28471.cljs$lang$protocol_mask$partition0$;
var inst_28477 = (inst_28476 & (64));
var inst_28479 = inst_28471.cljs$core$ISeq$;
var inst_28480 = (cljs.core.PROTOCOL_SENTINEL === inst_28479);
var inst_28481 = ((inst_28477) || (inst_28480));
var state_28577__$1 = state_28577;
if(cljs.core.truth_(inst_28481)){
var statearr_28653_30932 = state_28577__$1;
(statearr_28653_30932[(1)] = (5));

} else {
var statearr_28654_30933 = state_28577__$1;
(statearr_28654_30933[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (23))){
var inst_28533 = (state_28577[(14)]);
var inst_28539 = (inst_28533 == null);
var state_28577__$1 = state_28577;
if(cljs.core.truth_(inst_28539)){
var statearr_28655_30934 = state_28577__$1;
(statearr_28655_30934[(1)] = (26));

} else {
var statearr_28656_30935 = state_28577__$1;
(statearr_28656_30935[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (35))){
var inst_28560 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
if(cljs.core.truth_(inst_28560)){
var statearr_28657_30936 = state_28577__$1;
(statearr_28657_30936[(1)] = (36));

} else {
var statearr_28658_30937 = state_28577__$1;
(statearr_28658_30937[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (19))){
var inst_28497 = (state_28577[(7)]);
var inst_28518 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28497);
var state_28577__$1 = state_28577;
var statearr_28660_30938 = state_28577__$1;
(statearr_28660_30938[(2)] = inst_28518);

(statearr_28660_30938[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (11))){
var inst_28497 = (state_28577[(7)]);
var inst_28501 = (inst_28497 == null);
var inst_28502 = cljs.core.not(inst_28501);
var state_28577__$1 = state_28577;
if(inst_28502){
var statearr_28661_30939 = state_28577__$1;
(statearr_28661_30939[(1)] = (13));

} else {
var statearr_28662_30940 = state_28577__$1;
(statearr_28662_30940[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (9))){
var inst_28471 = (state_28577[(8)]);
var state_28577__$1 = state_28577;
var statearr_28663_30941 = state_28577__$1;
(statearr_28663_30941[(2)] = inst_28471);

(statearr_28663_30941[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (5))){
var state_28577__$1 = state_28577;
var statearr_28664_30943 = state_28577__$1;
(statearr_28664_30943[(2)] = true);

(statearr_28664_30943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (14))){
var state_28577__$1 = state_28577;
var statearr_28666_30944 = state_28577__$1;
(statearr_28666_30944[(2)] = false);

(statearr_28666_30944[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (26))){
var inst_28534 = (state_28577[(11)]);
var inst_28541 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_28534);
var state_28577__$1 = state_28577;
var statearr_28668_30945 = state_28577__$1;
(statearr_28668_30945[(2)] = inst_28541);

(statearr_28668_30945[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (16))){
var state_28577__$1 = state_28577;
var statearr_28669_30946 = state_28577__$1;
(statearr_28669_30946[(2)] = true);

(statearr_28669_30946[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (38))){
var inst_28565 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
var statearr_28670_30947 = state_28577__$1;
(statearr_28670_30947[(2)] = inst_28565);

(statearr_28670_30947[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (30))){
var inst_28522 = (state_28577[(9)]);
var inst_28534 = (state_28577[(11)]);
var inst_28523 = (state_28577[(13)]);
var inst_28551 = cljs.core.empty_QMARK_(inst_28522);
var inst_28552 = (inst_28523.cljs$core$IFn$_invoke$arity$1 ? inst_28523.cljs$core$IFn$_invoke$arity$1(inst_28534) : inst_28523.call(null,inst_28534));
var inst_28553 = cljs.core.not(inst_28552);
var inst_28554 = ((inst_28551) && (inst_28553));
var state_28577__$1 = state_28577;
var statearr_28675_30948 = state_28577__$1;
(statearr_28675_30948[(2)] = inst_28554);

(statearr_28675_30948[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (10))){
var inst_28471 = (state_28577[(8)]);
var inst_28493 = (state_28577[(2)]);
var inst_28494 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28493,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_28495 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28493,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_28496 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28493,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_28497 = inst_28471;
var state_28577__$1 = (function (){var statearr_28677 = state_28577;
(statearr_28677[(16)] = inst_28494);

(statearr_28677[(17)] = inst_28495);

(statearr_28677[(18)] = inst_28496);

(statearr_28677[(7)] = inst_28497);

return statearr_28677;
})();
var statearr_28678_30950 = state_28577__$1;
(statearr_28678_30950[(2)] = null);

(statearr_28678_30950[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (18))){
var inst_28513 = (state_28577[(2)]);
var state_28577__$1 = state_28577;
var statearr_28679_30951 = state_28577__$1;
(statearr_28679_30951[(2)] = inst_28513);

(statearr_28679_30951[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (37))){
var state_28577__$1 = state_28577;
var statearr_28680_30956 = state_28577__$1;
(statearr_28680_30956[(2)] = null);

(statearr_28680_30956[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28578 === (8))){
var inst_28471 = (state_28577[(8)]);
var inst_28490 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28471);
var state_28577__$1 = state_28577;
var statearr_28681_30958 = state_28577__$1;
(statearr_28681_30958[(2)] = inst_28490);

(statearr_28681_30958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__26715__auto__ = null;
var cljs$core$async$mix_$_state_machine__26715__auto____0 = (function (){
var statearr_28684 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28684[(0)] = cljs$core$async$mix_$_state_machine__26715__auto__);

(statearr_28684[(1)] = (1));

return statearr_28684;
});
var cljs$core$async$mix_$_state_machine__26715__auto____1 = (function (state_28577){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_28577);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e28685){var ex__26718__auto__ = e28685;
var statearr_28686_30964 = state_28577;
(statearr_28686_30964[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_28577[(4)]))){
var statearr_28687_30966 = state_28577;
(statearr_28687_30966[(1)] = cljs.core.first((state_28577[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30968 = state_28577;
state_28577 = G__30968;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__26715__auto__ = function(state_28577){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__26715__auto____1.call(this,state_28577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__26715__auto____0;
cljs$core$async$mix_$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__26715__auto____1;
return cljs$core$async$mix_$_state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_28693 = f__27075__auto__();
(statearr_28693[(6)] = c__27074__auto___30890);

return statearr_28693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_30981 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_30981(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_30982 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_30982(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_30985 = (function() {
var G__30986 = null;
var G__30986__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__30986__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__30986 = function(p,v){
switch(arguments.length){
case 1:
return G__30986__1.call(this,p);
case 2:
return G__30986__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__30986.cljs$core$IFn$_invoke$arity$1 = G__30986__1;
G__30986.cljs$core$IFn$_invoke$arity$2 = G__30986__2;
return G__30986;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__28721 = arguments.length;
switch (G__28721) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_30985(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_30985(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__28734 = arguments.length;
switch (G__28734) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__28730_SHARP_){
if(cljs.core.truth_((p1__28730_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__28730_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__28730_SHARP_.call(null,topic)))){
return p1__28730_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__28730_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28746 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28746 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta28747){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta28747 = meta28747;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28746.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28748,meta28747__$1){
var self__ = this;
var _28748__$1 = this;
return (new cljs.core.async.t_cljs$core$async28746(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta28747__$1));
}));

(cljs.core.async.t_cljs$core$async28746.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28748){
var self__ = this;
var _28748__$1 = this;
return self__.meta28747;
}));

(cljs.core.async.t_cljs$core$async28746.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28746.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async28746.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28746.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async28746.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async28746.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async28746.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async28746.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta28747","meta28747",812716547,null)], null);
}));

(cljs.core.async.t_cljs$core$async28746.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28746.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28746");

(cljs.core.async.t_cljs$core$async28746.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28746");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28746.
 */
cljs.core.async.__GT_t_cljs$core$async28746 = (function cljs$core$async$__GT_t_cljs$core$async28746(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28747){
return (new cljs.core.async.t_cljs$core$async28746(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28747));
});

}

return (new cljs.core.async.t_cljs$core$async28746(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__27074__auto___31004 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_28861){
var state_val_28865 = (state_28861[(1)]);
if((state_val_28865 === (7))){
var inst_28855 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
var statearr_28869_31006 = state_28861__$1;
(statearr_28869_31006[(2)] = inst_28855);

(statearr_28869_31006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (20))){
var state_28861__$1 = state_28861;
var statearr_28870_31007 = state_28861__$1;
(statearr_28870_31007[(2)] = null);

(statearr_28870_31007[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (1))){
var state_28861__$1 = state_28861;
var statearr_28871_31009 = state_28861__$1;
(statearr_28871_31009[(2)] = null);

(statearr_28871_31009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (24))){
var inst_28834 = (state_28861[(7)]);
var inst_28847 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_28834);
var state_28861__$1 = state_28861;
var statearr_28872_31011 = state_28861__$1;
(statearr_28872_31011[(2)] = inst_28847);

(statearr_28872_31011[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (4))){
var inst_28780 = (state_28861[(8)]);
var inst_28780__$1 = (state_28861[(2)]);
var inst_28781 = (inst_28780__$1 == null);
var state_28861__$1 = (function (){var statearr_28873 = state_28861;
(statearr_28873[(8)] = inst_28780__$1);

return statearr_28873;
})();
if(cljs.core.truth_(inst_28781)){
var statearr_28874_31012 = state_28861__$1;
(statearr_28874_31012[(1)] = (5));

} else {
var statearr_28875_31013 = state_28861__$1;
(statearr_28875_31013[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (15))){
var inst_28828 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
var statearr_28876_31014 = state_28861__$1;
(statearr_28876_31014[(2)] = inst_28828);

(statearr_28876_31014[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (21))){
var inst_28852 = (state_28861[(2)]);
var state_28861__$1 = (function (){var statearr_28877 = state_28861;
(statearr_28877[(9)] = inst_28852);

return statearr_28877;
})();
var statearr_28878_31015 = state_28861__$1;
(statearr_28878_31015[(2)] = null);

(statearr_28878_31015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (13))){
var inst_28804 = (state_28861[(10)]);
var inst_28808 = cljs.core.chunked_seq_QMARK_(inst_28804);
var state_28861__$1 = state_28861;
if(inst_28808){
var statearr_28879_31016 = state_28861__$1;
(statearr_28879_31016[(1)] = (16));

} else {
var statearr_28880_31017 = state_28861__$1;
(statearr_28880_31017[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (22))){
var inst_28844 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
if(cljs.core.truth_(inst_28844)){
var statearr_28881_31018 = state_28861__$1;
(statearr_28881_31018[(1)] = (23));

} else {
var statearr_28891_31019 = state_28861__$1;
(statearr_28891_31019[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (6))){
var inst_28780 = (state_28861[(8)]);
var inst_28840 = (state_28861[(11)]);
var inst_28834 = (state_28861[(7)]);
var inst_28834__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_28780) : topic_fn.call(null,inst_28780));
var inst_28839 = cljs.core.deref(mults);
var inst_28840__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28839,inst_28834__$1);
var state_28861__$1 = (function (){var statearr_28899 = state_28861;
(statearr_28899[(11)] = inst_28840__$1);

(statearr_28899[(7)] = inst_28834__$1);

return statearr_28899;
})();
if(cljs.core.truth_(inst_28840__$1)){
var statearr_28900_31020 = state_28861__$1;
(statearr_28900_31020[(1)] = (19));

} else {
var statearr_28901_31021 = state_28861__$1;
(statearr_28901_31021[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (25))){
var inst_28849 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
var statearr_28902_31022 = state_28861__$1;
(statearr_28902_31022[(2)] = inst_28849);

(statearr_28902_31022[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (17))){
var inst_28804 = (state_28861[(10)]);
var inst_28816 = cljs.core.first(inst_28804);
var inst_28820 = cljs.core.async.muxch_STAR_(inst_28816);
var inst_28821 = cljs.core.async.close_BANG_(inst_28820);
var inst_28822 = cljs.core.next(inst_28804);
var inst_28790 = inst_28822;
var inst_28791 = null;
var inst_28792 = (0);
var inst_28793 = (0);
var state_28861__$1 = (function (){var statearr_28903 = state_28861;
(statearr_28903[(12)] = inst_28790);

(statearr_28903[(13)] = inst_28793);

(statearr_28903[(14)] = inst_28791);

(statearr_28903[(15)] = inst_28792);

(statearr_28903[(16)] = inst_28821);

return statearr_28903;
})();
var statearr_28904_31028 = state_28861__$1;
(statearr_28904_31028[(2)] = null);

(statearr_28904_31028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (3))){
var inst_28857 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28861__$1,inst_28857);
} else {
if((state_val_28865 === (12))){
var inst_28830 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
var statearr_28906_31031 = state_28861__$1;
(statearr_28906_31031[(2)] = inst_28830);

(statearr_28906_31031[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (2))){
var state_28861__$1 = state_28861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28861__$1,(4),ch);
} else {
if((state_val_28865 === (23))){
var state_28861__$1 = state_28861;
var statearr_28907_31036 = state_28861__$1;
(statearr_28907_31036[(2)] = null);

(statearr_28907_31036[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (19))){
var inst_28780 = (state_28861[(8)]);
var inst_28840 = (state_28861[(11)]);
var inst_28842 = cljs.core.async.muxch_STAR_(inst_28840);
var state_28861__$1 = state_28861;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28861__$1,(22),inst_28842,inst_28780);
} else {
if((state_val_28865 === (11))){
var inst_28790 = (state_28861[(12)]);
var inst_28804 = (state_28861[(10)]);
var inst_28804__$1 = cljs.core.seq(inst_28790);
var state_28861__$1 = (function (){var statearr_28909 = state_28861;
(statearr_28909[(10)] = inst_28804__$1);

return statearr_28909;
})();
if(inst_28804__$1){
var statearr_28910_31038 = state_28861__$1;
(statearr_28910_31038[(1)] = (13));

} else {
var statearr_28911_31039 = state_28861__$1;
(statearr_28911_31039[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (9))){
var inst_28832 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
var statearr_28912_31041 = state_28861__$1;
(statearr_28912_31041[(2)] = inst_28832);

(statearr_28912_31041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (5))){
var inst_28787 = cljs.core.deref(mults);
var inst_28788 = cljs.core.vals(inst_28787);
var inst_28789 = cljs.core.seq(inst_28788);
var inst_28790 = inst_28789;
var inst_28791 = null;
var inst_28792 = (0);
var inst_28793 = (0);
var state_28861__$1 = (function (){var statearr_28913 = state_28861;
(statearr_28913[(12)] = inst_28790);

(statearr_28913[(13)] = inst_28793);

(statearr_28913[(14)] = inst_28791);

(statearr_28913[(15)] = inst_28792);

return statearr_28913;
})();
var statearr_28917_31046 = state_28861__$1;
(statearr_28917_31046[(2)] = null);

(statearr_28917_31046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (14))){
var state_28861__$1 = state_28861;
var statearr_28922_31047 = state_28861__$1;
(statearr_28922_31047[(2)] = null);

(statearr_28922_31047[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (16))){
var inst_28804 = (state_28861[(10)]);
var inst_28810 = cljs.core.chunk_first(inst_28804);
var inst_28812 = cljs.core.chunk_rest(inst_28804);
var inst_28813 = cljs.core.count(inst_28810);
var inst_28790 = inst_28812;
var inst_28791 = inst_28810;
var inst_28792 = inst_28813;
var inst_28793 = (0);
var state_28861__$1 = (function (){var statearr_28923 = state_28861;
(statearr_28923[(12)] = inst_28790);

(statearr_28923[(13)] = inst_28793);

(statearr_28923[(14)] = inst_28791);

(statearr_28923[(15)] = inst_28792);

return statearr_28923;
})();
var statearr_28924_31050 = state_28861__$1;
(statearr_28924_31050[(2)] = null);

(statearr_28924_31050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (10))){
var inst_28790 = (state_28861[(12)]);
var inst_28793 = (state_28861[(13)]);
var inst_28791 = (state_28861[(14)]);
var inst_28792 = (state_28861[(15)]);
var inst_28798 = cljs.core._nth(inst_28791,inst_28793);
var inst_28799 = cljs.core.async.muxch_STAR_(inst_28798);
var inst_28800 = cljs.core.async.close_BANG_(inst_28799);
var inst_28801 = (inst_28793 + (1));
var tmp28918 = inst_28790;
var tmp28919 = inst_28791;
var tmp28920 = inst_28792;
var inst_28790__$1 = tmp28918;
var inst_28791__$1 = tmp28919;
var inst_28792__$1 = tmp28920;
var inst_28793__$1 = inst_28801;
var state_28861__$1 = (function (){var statearr_28934 = state_28861;
(statearr_28934[(12)] = inst_28790__$1);

(statearr_28934[(13)] = inst_28793__$1);

(statearr_28934[(14)] = inst_28791__$1);

(statearr_28934[(17)] = inst_28800);

(statearr_28934[(15)] = inst_28792__$1);

return statearr_28934;
})();
var statearr_28935_31052 = state_28861__$1;
(statearr_28935_31052[(2)] = null);

(statearr_28935_31052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (18))){
var inst_28825 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
var statearr_28944_31055 = state_28861__$1;
(statearr_28944_31055[(2)] = inst_28825);

(statearr_28944_31055[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28865 === (8))){
var inst_28793 = (state_28861[(13)]);
var inst_28792 = (state_28861[(15)]);
var inst_28795 = (inst_28793 < inst_28792);
var inst_28796 = inst_28795;
var state_28861__$1 = state_28861;
if(cljs.core.truth_(inst_28796)){
var statearr_28945_31057 = state_28861__$1;
(statearr_28945_31057[(1)] = (10));

} else {
var statearr_28946_31058 = state_28861__$1;
(statearr_28946_31058[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_28947 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28947[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_28947[(1)] = (1));

return statearr_28947;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_28861){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_28861);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e28948){var ex__26718__auto__ = e28948;
var statearr_28949_31062 = state_28861;
(statearr_28949_31062[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_28861[(4)]))){
var statearr_28950_31063 = state_28861;
(statearr_28950_31063[(1)] = cljs.core.first((state_28861[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31064 = state_28861;
state_28861 = G__31064;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_28861){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_28861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_28951 = f__27075__auto__();
(statearr_28951[(6)] = c__27074__auto___31004);

return statearr_28951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__28967 = arguments.length;
switch (G__28967) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__28977 = arguments.length;
switch (G__28977) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__28982 = arguments.length;
switch (G__28982) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__27074__auto___31071 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_29041){
var state_val_29042 = (state_29041[(1)]);
if((state_val_29042 === (7))){
var state_29041__$1 = state_29041;
var statearr_29049_31073 = state_29041__$1;
(statearr_29049_31073[(2)] = null);

(statearr_29049_31073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (1))){
var state_29041__$1 = state_29041;
var statearr_29051_31075 = state_29041__$1;
(statearr_29051_31075[(2)] = null);

(statearr_29051_31075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (4))){
var inst_28994 = (state_29041[(7)]);
var inst_28992 = (state_29041[(8)]);
var inst_28996 = (inst_28994 < inst_28992);
var state_29041__$1 = state_29041;
if(cljs.core.truth_(inst_28996)){
var statearr_29052_31079 = state_29041__$1;
(statearr_29052_31079[(1)] = (6));

} else {
var statearr_29053_31080 = state_29041__$1;
(statearr_29053_31080[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (15))){
var inst_29023 = (state_29041[(9)]);
var inst_29028 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_29023);
var state_29041__$1 = state_29041;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29041__$1,(17),out,inst_29028);
} else {
if((state_val_29042 === (13))){
var inst_29023 = (state_29041[(9)]);
var inst_29023__$1 = (state_29041[(2)]);
var inst_29024 = cljs.core.some(cljs.core.nil_QMARK_,inst_29023__$1);
var state_29041__$1 = (function (){var statearr_29054 = state_29041;
(statearr_29054[(9)] = inst_29023__$1);

return statearr_29054;
})();
if(cljs.core.truth_(inst_29024)){
var statearr_29055_31083 = state_29041__$1;
(statearr_29055_31083[(1)] = (14));

} else {
var statearr_29056_31084 = state_29041__$1;
(statearr_29056_31084[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (6))){
var state_29041__$1 = state_29041;
var statearr_29057_31086 = state_29041__$1;
(statearr_29057_31086[(2)] = null);

(statearr_29057_31086[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (17))){
var inst_29030 = (state_29041[(2)]);
var state_29041__$1 = (function (){var statearr_29068 = state_29041;
(statearr_29068[(10)] = inst_29030);

return statearr_29068;
})();
var statearr_29069_31088 = state_29041__$1;
(statearr_29069_31088[(2)] = null);

(statearr_29069_31088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (3))){
var inst_29035 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29041__$1,inst_29035);
} else {
if((state_val_29042 === (12))){
var _ = (function (){var statearr_29070 = state_29041;
(statearr_29070[(4)] = cljs.core.rest((state_29041[(4)])));

return statearr_29070;
})();
var state_29041__$1 = state_29041;
var ex29063 = (state_29041__$1[(2)]);
var statearr_29071_31092 = state_29041__$1;
(statearr_29071_31092[(5)] = ex29063);


if((ex29063 instanceof Object)){
var statearr_29072_31097 = state_29041__$1;
(statearr_29072_31097[(1)] = (11));

(statearr_29072_31097[(5)] = null);

} else {
throw ex29063;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (2))){
var inst_28991 = cljs.core.reset_BANG_(dctr,cnt);
var inst_28992 = cnt;
var inst_28994 = (0);
var state_29041__$1 = (function (){var statearr_29075 = state_29041;
(statearr_29075[(7)] = inst_28994);

(statearr_29075[(11)] = inst_28991);

(statearr_29075[(8)] = inst_28992);

return statearr_29075;
})();
var statearr_29077_31102 = state_29041__$1;
(statearr_29077_31102[(2)] = null);

(statearr_29077_31102[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (11))){
var inst_28999 = (state_29041[(2)]);
var inst_29000 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_29041__$1 = (function (){var statearr_29079 = state_29041;
(statearr_29079[(12)] = inst_28999);

return statearr_29079;
})();
var statearr_29081_31103 = state_29041__$1;
(statearr_29081_31103[(2)] = inst_29000);

(statearr_29081_31103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (9))){
var inst_28994 = (state_29041[(7)]);
var _ = (function (){var statearr_29082 = state_29041;
(statearr_29082[(4)] = cljs.core.cons((12),(state_29041[(4)])));

return statearr_29082;
})();
var inst_29009 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_28994) : chs__$1.call(null,inst_28994));
var inst_29010 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_28994) : done.call(null,inst_28994));
var inst_29011 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29009,inst_29010);
var ___$1 = (function (){var statearr_29083 = state_29041;
(statearr_29083[(4)] = cljs.core.rest((state_29041[(4)])));

return statearr_29083;
})();
var state_29041__$1 = state_29041;
var statearr_29084_31108 = state_29041__$1;
(statearr_29084_31108[(2)] = inst_29011);

(statearr_29084_31108[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (5))){
var inst_29021 = (state_29041[(2)]);
var state_29041__$1 = (function (){var statearr_29085 = state_29041;
(statearr_29085[(13)] = inst_29021);

return statearr_29085;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29041__$1,(13),dchan);
} else {
if((state_val_29042 === (14))){
var inst_29026 = cljs.core.async.close_BANG_(out);
var state_29041__$1 = state_29041;
var statearr_29086_31112 = state_29041__$1;
(statearr_29086_31112[(2)] = inst_29026);

(statearr_29086_31112[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (16))){
var inst_29033 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29087_31113 = state_29041__$1;
(statearr_29087_31113[(2)] = inst_29033);

(statearr_29087_31113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (10))){
var inst_28994 = (state_29041[(7)]);
var inst_29014 = (state_29041[(2)]);
var inst_29015 = (inst_28994 + (1));
var inst_28994__$1 = inst_29015;
var state_29041__$1 = (function (){var statearr_29088 = state_29041;
(statearr_29088[(7)] = inst_28994__$1);

(statearr_29088[(14)] = inst_29014);

return statearr_29088;
})();
var statearr_29089_31115 = state_29041__$1;
(statearr_29089_31115[(2)] = null);

(statearr_29089_31115[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (8))){
var inst_29019 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29094_31116 = state_29041__$1;
(statearr_29094_31116[(2)] = inst_29019);

(statearr_29094_31116[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_29096 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29096[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_29096[(1)] = (1));

return statearr_29096;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_29041){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_29041);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e29097){var ex__26718__auto__ = e29097;
var statearr_29098_31120 = state_29041;
(statearr_29098_31120[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_29041[(4)]))){
var statearr_29099_31122 = state_29041;
(statearr_29099_31122[(1)] = cljs.core.first((state_29041[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31124 = state_29041;
state_29041 = G__31124;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_29041){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_29041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_29100 = f__27075__auto__();
(statearr_29100[(6)] = c__27074__auto___31071);

return statearr_29100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__29107 = arguments.length;
switch (G__29107) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27074__auto___31132 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_29152){
var state_val_29157 = (state_29152[(1)]);
if((state_val_29157 === (7))){
var inst_29123 = (state_29152[(7)]);
var inst_29120 = (state_29152[(8)]);
var inst_29120__$1 = (state_29152[(2)]);
var inst_29123__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29120__$1,(0),null);
var inst_29124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29120__$1,(1),null);
var inst_29125 = (inst_29123__$1 == null);
var state_29152__$1 = (function (){var statearr_29177 = state_29152;
(statearr_29177[(7)] = inst_29123__$1);

(statearr_29177[(8)] = inst_29120__$1);

(statearr_29177[(9)] = inst_29124);

return statearr_29177;
})();
if(cljs.core.truth_(inst_29125)){
var statearr_29179_31143 = state_29152__$1;
(statearr_29179_31143[(1)] = (8));

} else {
var statearr_29181_31144 = state_29152__$1;
(statearr_29181_31144[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (1))){
var inst_29108 = cljs.core.vec(chs);
var inst_29109 = inst_29108;
var state_29152__$1 = (function (){var statearr_29187 = state_29152;
(statearr_29187[(10)] = inst_29109);

return statearr_29187;
})();
var statearr_29191_31145 = state_29152__$1;
(statearr_29191_31145[(2)] = null);

(statearr_29191_31145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (4))){
var inst_29109 = (state_29152[(10)]);
var state_29152__$1 = state_29152;
return cljs.core.async.ioc_alts_BANG_(state_29152__$1,(7),inst_29109);
} else {
if((state_val_29157 === (6))){
var inst_29146 = (state_29152[(2)]);
var state_29152__$1 = state_29152;
var statearr_29196_31146 = state_29152__$1;
(statearr_29196_31146[(2)] = inst_29146);

(statearr_29196_31146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (3))){
var inst_29148 = (state_29152[(2)]);
var state_29152__$1 = state_29152;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29152__$1,inst_29148);
} else {
if((state_val_29157 === (2))){
var inst_29109 = (state_29152[(10)]);
var inst_29111 = cljs.core.count(inst_29109);
var inst_29112 = (inst_29111 > (0));
var state_29152__$1 = state_29152;
if(cljs.core.truth_(inst_29112)){
var statearr_29198_31147 = state_29152__$1;
(statearr_29198_31147[(1)] = (4));

} else {
var statearr_29199_31148 = state_29152__$1;
(statearr_29199_31148[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (11))){
var inst_29109 = (state_29152[(10)]);
var inst_29138 = (state_29152[(2)]);
var tmp29197 = inst_29109;
var inst_29109__$1 = tmp29197;
var state_29152__$1 = (function (){var statearr_29200 = state_29152;
(statearr_29200[(10)] = inst_29109__$1);

(statearr_29200[(11)] = inst_29138);

return statearr_29200;
})();
var statearr_29201_31149 = state_29152__$1;
(statearr_29201_31149[(2)] = null);

(statearr_29201_31149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (9))){
var inst_29123 = (state_29152[(7)]);
var state_29152__$1 = state_29152;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29152__$1,(11),out,inst_29123);
} else {
if((state_val_29157 === (5))){
var inst_29144 = cljs.core.async.close_BANG_(out);
var state_29152__$1 = state_29152;
var statearr_29203_31150 = state_29152__$1;
(statearr_29203_31150[(2)] = inst_29144);

(statearr_29203_31150[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (10))){
var inst_29142 = (state_29152[(2)]);
var state_29152__$1 = state_29152;
var statearr_29205_31152 = state_29152__$1;
(statearr_29205_31152[(2)] = inst_29142);

(statearr_29205_31152[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29157 === (8))){
var inst_29123 = (state_29152[(7)]);
var inst_29109 = (state_29152[(10)]);
var inst_29120 = (state_29152[(8)]);
var inst_29124 = (state_29152[(9)]);
var inst_29133 = (function (){var cs = inst_29109;
var vec__29114 = inst_29120;
var v = inst_29123;
var c = inst_29124;
return (function (p1__29105_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__29105_SHARP_);
});
})();
var inst_29134 = cljs.core.filterv(inst_29133,inst_29109);
var inst_29109__$1 = inst_29134;
var state_29152__$1 = (function (){var statearr_29206 = state_29152;
(statearr_29206[(10)] = inst_29109__$1);

return statearr_29206;
})();
var statearr_29207_31159 = state_29152__$1;
(statearr_29207_31159[(2)] = null);

(statearr_29207_31159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_29209 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29209[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_29209[(1)] = (1));

return statearr_29209;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_29152){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_29152);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e29210){var ex__26718__auto__ = e29210;
var statearr_29211_31160 = state_29152;
(statearr_29211_31160[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_29152[(4)]))){
var statearr_29212_31161 = state_29152;
(statearr_29212_31161[(1)] = cljs.core.first((state_29152[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31164 = state_29152;
state_29152 = G__31164;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_29152){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_29152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_29216 = f__27075__auto__();
(statearr_29216[(6)] = c__27074__auto___31132);

return statearr_29216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__29220 = arguments.length;
switch (G__29220) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27074__auto___31178 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_29254){
var state_val_29255 = (state_29254[(1)]);
if((state_val_29255 === (7))){
var inst_29233 = (state_29254[(7)]);
var inst_29233__$1 = (state_29254[(2)]);
var inst_29237 = (inst_29233__$1 == null);
var inst_29238 = cljs.core.not(inst_29237);
var state_29254__$1 = (function (){var statearr_29263 = state_29254;
(statearr_29263[(7)] = inst_29233__$1);

return statearr_29263;
})();
if(inst_29238){
var statearr_29264_31179 = state_29254__$1;
(statearr_29264_31179[(1)] = (8));

} else {
var statearr_29265_31180 = state_29254__$1;
(statearr_29265_31180[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (1))){
var inst_29228 = (0);
var state_29254__$1 = (function (){var statearr_29269 = state_29254;
(statearr_29269[(8)] = inst_29228);

return statearr_29269;
})();
var statearr_29270_31181 = state_29254__$1;
(statearr_29270_31181[(2)] = null);

(statearr_29270_31181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (4))){
var state_29254__$1 = state_29254;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29254__$1,(7),ch);
} else {
if((state_val_29255 === (6))){
var inst_29249 = (state_29254[(2)]);
var state_29254__$1 = state_29254;
var statearr_29275_31182 = state_29254__$1;
(statearr_29275_31182[(2)] = inst_29249);

(statearr_29275_31182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (3))){
var inst_29251 = (state_29254[(2)]);
var inst_29252 = cljs.core.async.close_BANG_(out);
var state_29254__$1 = (function (){var statearr_29276 = state_29254;
(statearr_29276[(9)] = inst_29251);

return statearr_29276;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29254__$1,inst_29252);
} else {
if((state_val_29255 === (2))){
var inst_29228 = (state_29254[(8)]);
var inst_29230 = (inst_29228 < n);
var state_29254__$1 = state_29254;
if(cljs.core.truth_(inst_29230)){
var statearr_29277_31183 = state_29254__$1;
(statearr_29277_31183[(1)] = (4));

} else {
var statearr_29278_31184 = state_29254__$1;
(statearr_29278_31184[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (11))){
var inst_29228 = (state_29254[(8)]);
var inst_29241 = (state_29254[(2)]);
var inst_29242 = (inst_29228 + (1));
var inst_29228__$1 = inst_29242;
var state_29254__$1 = (function (){var statearr_29279 = state_29254;
(statearr_29279[(8)] = inst_29228__$1);

(statearr_29279[(10)] = inst_29241);

return statearr_29279;
})();
var statearr_29280_31185 = state_29254__$1;
(statearr_29280_31185[(2)] = null);

(statearr_29280_31185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (9))){
var state_29254__$1 = state_29254;
var statearr_29281_31186 = state_29254__$1;
(statearr_29281_31186[(2)] = null);

(statearr_29281_31186[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (5))){
var state_29254__$1 = state_29254;
var statearr_29282_31193 = state_29254__$1;
(statearr_29282_31193[(2)] = null);

(statearr_29282_31193[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (10))){
var inst_29246 = (state_29254[(2)]);
var state_29254__$1 = state_29254;
var statearr_29283_31194 = state_29254__$1;
(statearr_29283_31194[(2)] = inst_29246);

(statearr_29283_31194[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (8))){
var inst_29233 = (state_29254[(7)]);
var state_29254__$1 = state_29254;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29254__$1,(11),out,inst_29233);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_29284 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29284[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_29284[(1)] = (1));

return statearr_29284;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_29254){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_29254);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e29285){var ex__26718__auto__ = e29285;
var statearr_29286_31195 = state_29254;
(statearr_29286_31195[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_29254[(4)]))){
var statearr_29287_31196 = state_29254;
(statearr_29287_31196[(1)] = cljs.core.first((state_29254[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31197 = state_29254;
state_29254 = G__31197;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_29254){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_29254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_29288 = f__27075__auto__();
(statearr_29288[(6)] = c__27074__auto___31178);

return statearr_29288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29290 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29290 = (function (f,ch,meta29291){
this.f = f;
this.ch = ch;
this.meta29291 = meta29291;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29290.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29292,meta29291__$1){
var self__ = this;
var _29292__$1 = this;
return (new cljs.core.async.t_cljs$core$async29290(self__.f,self__.ch,meta29291__$1));
}));

(cljs.core.async.t_cljs$core$async29290.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29292){
var self__ = this;
var _29292__$1 = this;
return self__.meta29291;
}));

(cljs.core.async.t_cljs$core$async29290.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29290.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29290.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29290.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29290.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29299 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29299 = (function (f,ch,meta29291,_,fn1,meta29300){
this.f = f;
this.ch = ch;
this.meta29291 = meta29291;
this._ = _;
this.fn1 = fn1;
this.meta29300 = meta29300;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29299.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29301,meta29300__$1){
var self__ = this;
var _29301__$1 = this;
return (new cljs.core.async.t_cljs$core$async29299(self__.f,self__.ch,self__.meta29291,self__._,self__.fn1,meta29300__$1));
}));

(cljs.core.async.t_cljs$core$async29299.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29301){
var self__ = this;
var _29301__$1 = this;
return self__.meta29300;
}));

(cljs.core.async.t_cljs$core$async29299.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29299.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async29299.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async29299.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__29289_SHARP_){
var G__29311 = (((p1__29289_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__29289_SHARP_) : self__.f.call(null,p1__29289_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__29311) : f1.call(null,G__29311));
});
}));

(cljs.core.async.t_cljs$core$async29299.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29291","meta29291",-1409481786,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async29290","cljs.core.async/t_cljs$core$async29290",917903732,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta29300","meta29300",-213144905,null)], null);
}));

(cljs.core.async.t_cljs$core$async29299.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29299.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29299");

(cljs.core.async.t_cljs$core$async29299.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29299");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29299.
 */
cljs.core.async.__GT_t_cljs$core$async29299 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29299(f__$1,ch__$1,meta29291__$1,___$2,fn1__$1,meta29300){
return (new cljs.core.async.t_cljs$core$async29299(f__$1,ch__$1,meta29291__$1,___$2,fn1__$1,meta29300));
});

}

return (new cljs.core.async.t_cljs$core$async29299(self__.f,self__.ch,self__.meta29291,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__29315 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__29315) : self__.f.call(null,G__29315));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async29290.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29290.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async29290.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29291","meta29291",-1409481786,null)], null);
}));

(cljs.core.async.t_cljs$core$async29290.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29290.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29290");

(cljs.core.async.t_cljs$core$async29290.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29290");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29290.
 */
cljs.core.async.__GT_t_cljs$core$async29290 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29290(f__$1,ch__$1,meta29291){
return (new cljs.core.async.t_cljs$core$async29290(f__$1,ch__$1,meta29291));
});

}

return (new cljs.core.async.t_cljs$core$async29290(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29333 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29333 = (function (f,ch,meta29334){
this.f = f;
this.ch = ch;
this.meta29334 = meta29334;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29333.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29335,meta29334__$1){
var self__ = this;
var _29335__$1 = this;
return (new cljs.core.async.t_cljs$core$async29333(self__.f,self__.ch,meta29334__$1));
}));

(cljs.core.async.t_cljs$core$async29333.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29335){
var self__ = this;
var _29335__$1 = this;
return self__.meta29334;
}));

(cljs.core.async.t_cljs$core$async29333.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29333.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29333.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29333.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async29333.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29333.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async29333.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29334","meta29334",232221511,null)], null);
}));

(cljs.core.async.t_cljs$core$async29333.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29333.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29333");

(cljs.core.async.t_cljs$core$async29333.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29333");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29333.
 */
cljs.core.async.__GT_t_cljs$core$async29333 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async29333(f__$1,ch__$1,meta29334){
return (new cljs.core.async.t_cljs$core$async29333(f__$1,ch__$1,meta29334));
});

}

return (new cljs.core.async.t_cljs$core$async29333(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29349 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29349 = (function (p,ch,meta29350){
this.p = p;
this.ch = ch;
this.meta29350 = meta29350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29351,meta29350__$1){
var self__ = this;
var _29351__$1 = this;
return (new cljs.core.async.t_cljs$core$async29349(self__.p,self__.ch,meta29350__$1));
}));

(cljs.core.async.t_cljs$core$async29349.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29351){
var self__ = this;
var _29351__$1 = this;
return self__.meta29350;
}));

(cljs.core.async.t_cljs$core$async29349.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29349.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29349.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29349.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29349.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async29349.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29349.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async29349.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29350","meta29350",-675354350,null)], null);
}));

(cljs.core.async.t_cljs$core$async29349.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29349.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29349");

(cljs.core.async.t_cljs$core$async29349.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29349");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29349.
 */
cljs.core.async.__GT_t_cljs$core$async29349 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async29349(p__$1,ch__$1,meta29350){
return (new cljs.core.async.t_cljs$core$async29349(p__$1,ch__$1,meta29350));
});

}

return (new cljs.core.async.t_cljs$core$async29349(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__29411 = arguments.length;
switch (G__29411) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27074__auto___31211 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_29443){
var state_val_29444 = (state_29443[(1)]);
if((state_val_29444 === (7))){
var inst_29439 = (state_29443[(2)]);
var state_29443__$1 = state_29443;
var statearr_29456_31213 = state_29443__$1;
(statearr_29456_31213[(2)] = inst_29439);

(statearr_29456_31213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29444 === (1))){
var state_29443__$1 = state_29443;
var statearr_29460_31214 = state_29443__$1;
(statearr_29460_31214[(2)] = null);

(statearr_29460_31214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29444 === (4))){
var inst_29422 = (state_29443[(7)]);
var inst_29422__$1 = (state_29443[(2)]);
var inst_29424 = (inst_29422__$1 == null);
var state_29443__$1 = (function (){var statearr_29463 = state_29443;
(statearr_29463[(7)] = inst_29422__$1);

return statearr_29463;
})();
if(cljs.core.truth_(inst_29424)){
var statearr_29464_31218 = state_29443__$1;
(statearr_29464_31218[(1)] = (5));

} else {
var statearr_29466_31219 = state_29443__$1;
(statearr_29466_31219[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29444 === (6))){
var inst_29422 = (state_29443[(7)]);
var inst_29428 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_29422) : p.call(null,inst_29422));
var state_29443__$1 = state_29443;
if(cljs.core.truth_(inst_29428)){
var statearr_29468_31221 = state_29443__$1;
(statearr_29468_31221[(1)] = (8));

} else {
var statearr_29469_31223 = state_29443__$1;
(statearr_29469_31223[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29444 === (3))){
var inst_29441 = (state_29443[(2)]);
var state_29443__$1 = state_29443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29443__$1,inst_29441);
} else {
if((state_val_29444 === (2))){
var state_29443__$1 = state_29443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29443__$1,(4),ch);
} else {
if((state_val_29444 === (11))){
var inst_29431 = (state_29443[(2)]);
var state_29443__$1 = state_29443;
var statearr_29475_31224 = state_29443__$1;
(statearr_29475_31224[(2)] = inst_29431);

(statearr_29475_31224[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29444 === (9))){
var state_29443__$1 = state_29443;
var statearr_29478_31225 = state_29443__$1;
(statearr_29478_31225[(2)] = null);

(statearr_29478_31225[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29444 === (5))){
var inst_29426 = cljs.core.async.close_BANG_(out);
var state_29443__$1 = state_29443;
var statearr_29482_31226 = state_29443__$1;
(statearr_29482_31226[(2)] = inst_29426);

(statearr_29482_31226[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29444 === (10))){
var inst_29435 = (state_29443[(2)]);
var state_29443__$1 = (function (){var statearr_29484 = state_29443;
(statearr_29484[(8)] = inst_29435);

return statearr_29484;
})();
var statearr_29487_31227 = state_29443__$1;
(statearr_29487_31227[(2)] = null);

(statearr_29487_31227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29444 === (8))){
var inst_29422 = (state_29443[(7)]);
var state_29443__$1 = state_29443;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29443__$1,(11),out,inst_29422);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_29492 = [null,null,null,null,null,null,null,null,null];
(statearr_29492[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_29492[(1)] = (1));

return statearr_29492;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_29443){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_29443);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e29497){var ex__26718__auto__ = e29497;
var statearr_29501_31229 = state_29443;
(statearr_29501_31229[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_29443[(4)]))){
var statearr_29502_31230 = state_29443;
(statearr_29502_31230[(1)] = cljs.core.first((state_29443[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31231 = state_29443;
state_29443 = G__31231;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_29443){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_29443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_29505 = f__27075__auto__();
(statearr_29505[(6)] = c__27074__auto___31211);

return statearr_29505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__29510 = arguments.length;
switch (G__29510) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__27074__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_29614){
var state_val_29616 = (state_29614[(1)]);
if((state_val_29616 === (7))){
var inst_29606 = (state_29614[(2)]);
var state_29614__$1 = state_29614;
var statearr_29626_31235 = state_29614__$1;
(statearr_29626_31235[(2)] = inst_29606);

(statearr_29626_31235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (20))){
var inst_29575 = (state_29614[(7)]);
var inst_29587 = (state_29614[(2)]);
var inst_29588 = cljs.core.next(inst_29575);
var inst_29548 = inst_29588;
var inst_29549 = null;
var inst_29550 = (0);
var inst_29551 = (0);
var state_29614__$1 = (function (){var statearr_29630 = state_29614;
(statearr_29630[(8)] = inst_29550);

(statearr_29630[(9)] = inst_29549);

(statearr_29630[(10)] = inst_29587);

(statearr_29630[(11)] = inst_29548);

(statearr_29630[(12)] = inst_29551);

return statearr_29630;
})();
var statearr_29633_31236 = state_29614__$1;
(statearr_29633_31236[(2)] = null);

(statearr_29633_31236[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (1))){
var state_29614__$1 = state_29614;
var statearr_29637_31237 = state_29614__$1;
(statearr_29637_31237[(2)] = null);

(statearr_29637_31237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (4))){
var inst_29537 = (state_29614[(13)]);
var inst_29537__$1 = (state_29614[(2)]);
var inst_29538 = (inst_29537__$1 == null);
var state_29614__$1 = (function (){var statearr_29638 = state_29614;
(statearr_29638[(13)] = inst_29537__$1);

return statearr_29638;
})();
if(cljs.core.truth_(inst_29538)){
var statearr_29641_31238 = state_29614__$1;
(statearr_29641_31238[(1)] = (5));

} else {
var statearr_29645_31239 = state_29614__$1;
(statearr_29645_31239[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (15))){
var state_29614__$1 = state_29614;
var statearr_29651_31240 = state_29614__$1;
(statearr_29651_31240[(2)] = null);

(statearr_29651_31240[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (21))){
var state_29614__$1 = state_29614;
var statearr_29653_31242 = state_29614__$1;
(statearr_29653_31242[(2)] = null);

(statearr_29653_31242[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (13))){
var inst_29550 = (state_29614[(8)]);
var inst_29549 = (state_29614[(9)]);
var inst_29548 = (state_29614[(11)]);
var inst_29551 = (state_29614[(12)]);
var inst_29566 = (state_29614[(2)]);
var inst_29568 = (inst_29551 + (1));
var tmp29648 = inst_29550;
var tmp29649 = inst_29549;
var tmp29650 = inst_29548;
var inst_29548__$1 = tmp29650;
var inst_29549__$1 = tmp29649;
var inst_29550__$1 = tmp29648;
var inst_29551__$1 = inst_29568;
var state_29614__$1 = (function (){var statearr_29656 = state_29614;
(statearr_29656[(8)] = inst_29550__$1);

(statearr_29656[(9)] = inst_29549__$1);

(statearr_29656[(11)] = inst_29548__$1);

(statearr_29656[(12)] = inst_29551__$1);

(statearr_29656[(14)] = inst_29566);

return statearr_29656;
})();
var statearr_29659_31244 = state_29614__$1;
(statearr_29659_31244[(2)] = null);

(statearr_29659_31244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (22))){
var state_29614__$1 = state_29614;
var statearr_29661_31246 = state_29614__$1;
(statearr_29661_31246[(2)] = null);

(statearr_29661_31246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (6))){
var inst_29537 = (state_29614[(13)]);
var inst_29546 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_29537) : f.call(null,inst_29537));
var inst_29547 = cljs.core.seq(inst_29546);
var inst_29548 = inst_29547;
var inst_29549 = null;
var inst_29550 = (0);
var inst_29551 = (0);
var state_29614__$1 = (function (){var statearr_29664 = state_29614;
(statearr_29664[(8)] = inst_29550);

(statearr_29664[(9)] = inst_29549);

(statearr_29664[(11)] = inst_29548);

(statearr_29664[(12)] = inst_29551);

return statearr_29664;
})();
var statearr_29665_31248 = state_29614__$1;
(statearr_29665_31248[(2)] = null);

(statearr_29665_31248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (17))){
var inst_29575 = (state_29614[(7)]);
var inst_29579 = cljs.core.chunk_first(inst_29575);
var inst_29580 = cljs.core.chunk_rest(inst_29575);
var inst_29581 = cljs.core.count(inst_29579);
var inst_29548 = inst_29580;
var inst_29549 = inst_29579;
var inst_29550 = inst_29581;
var inst_29551 = (0);
var state_29614__$1 = (function (){var statearr_29667 = state_29614;
(statearr_29667[(8)] = inst_29550);

(statearr_29667[(9)] = inst_29549);

(statearr_29667[(11)] = inst_29548);

(statearr_29667[(12)] = inst_29551);

return statearr_29667;
})();
var statearr_29670_31252 = state_29614__$1;
(statearr_29670_31252[(2)] = null);

(statearr_29670_31252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (3))){
var inst_29608 = (state_29614[(2)]);
var state_29614__$1 = state_29614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29614__$1,inst_29608);
} else {
if((state_val_29616 === (12))){
var inst_29596 = (state_29614[(2)]);
var state_29614__$1 = state_29614;
var statearr_29676_31254 = state_29614__$1;
(statearr_29676_31254[(2)] = inst_29596);

(statearr_29676_31254[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (2))){
var state_29614__$1 = state_29614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29614__$1,(4),in$);
} else {
if((state_val_29616 === (23))){
var inst_29604 = (state_29614[(2)]);
var state_29614__$1 = state_29614;
var statearr_29677_31255 = state_29614__$1;
(statearr_29677_31255[(2)] = inst_29604);

(statearr_29677_31255[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (19))){
var inst_29591 = (state_29614[(2)]);
var state_29614__$1 = state_29614;
var statearr_29680_31256 = state_29614__$1;
(statearr_29680_31256[(2)] = inst_29591);

(statearr_29680_31256[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (11))){
var inst_29575 = (state_29614[(7)]);
var inst_29548 = (state_29614[(11)]);
var inst_29575__$1 = cljs.core.seq(inst_29548);
var state_29614__$1 = (function (){var statearr_29681 = state_29614;
(statearr_29681[(7)] = inst_29575__$1);

return statearr_29681;
})();
if(inst_29575__$1){
var statearr_29682_31258 = state_29614__$1;
(statearr_29682_31258[(1)] = (14));

} else {
var statearr_29683_31259 = state_29614__$1;
(statearr_29683_31259[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (9))){
var inst_29598 = (state_29614[(2)]);
var inst_29599 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_29614__$1 = (function (){var statearr_29686 = state_29614;
(statearr_29686[(15)] = inst_29598);

return statearr_29686;
})();
if(cljs.core.truth_(inst_29599)){
var statearr_29688_31268 = state_29614__$1;
(statearr_29688_31268[(1)] = (21));

} else {
var statearr_29690_31269 = state_29614__$1;
(statearr_29690_31269[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (5))){
var inst_29540 = cljs.core.async.close_BANG_(out);
var state_29614__$1 = state_29614;
var statearr_29694_31271 = state_29614__$1;
(statearr_29694_31271[(2)] = inst_29540);

(statearr_29694_31271[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (14))){
var inst_29575 = (state_29614[(7)]);
var inst_29577 = cljs.core.chunked_seq_QMARK_(inst_29575);
var state_29614__$1 = state_29614;
if(inst_29577){
var statearr_29695_31284 = state_29614__$1;
(statearr_29695_31284[(1)] = (17));

} else {
var statearr_29696_31288 = state_29614__$1;
(statearr_29696_31288[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (16))){
var inst_29594 = (state_29614[(2)]);
var state_29614__$1 = state_29614;
var statearr_29702_31289 = state_29614__$1;
(statearr_29702_31289[(2)] = inst_29594);

(statearr_29702_31289[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29616 === (10))){
var inst_29549 = (state_29614[(9)]);
var inst_29551 = (state_29614[(12)]);
var inst_29563 = cljs.core._nth(inst_29549,inst_29551);
var state_29614__$1 = state_29614;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29614__$1,(13),out,inst_29563);
} else {
if((state_val_29616 === (18))){
var inst_29575 = (state_29614[(7)]);
var inst_29584 = cljs.core.first(inst_29575);
var state_29614__$1 = state_29614;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29614__$1,(20),out,inst_29584);
} else {
if((state_val_29616 === (8))){
var inst_29550 = (state_29614[(8)]);
var inst_29551 = (state_29614[(12)]);
var inst_29554 = (inst_29551 < inst_29550);
var inst_29555 = inst_29554;
var state_29614__$1 = state_29614;
if(cljs.core.truth_(inst_29555)){
var statearr_29723_31299 = state_29614__$1;
(statearr_29723_31299[(1)] = (10));

} else {
var statearr_29736_31302 = state_29614__$1;
(statearr_29736_31302[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__26715__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__26715__auto____0 = (function (){
var statearr_29739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29739[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__26715__auto__);

(statearr_29739[(1)] = (1));

return statearr_29739;
});
var cljs$core$async$mapcat_STAR__$_state_machine__26715__auto____1 = (function (state_29614){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_29614);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e29740){var ex__26718__auto__ = e29740;
var statearr_29741_31311 = state_29614;
(statearr_29741_31311[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_29614[(4)]))){
var statearr_29743_31320 = state_29614;
(statearr_29743_31320[(1)] = cljs.core.first((state_29614[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31323 = state_29614;
state_29614 = G__31323;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__26715__auto__ = function(state_29614){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__26715__auto____1.call(this,state_29614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__26715__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__26715__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_29746 = f__27075__auto__();
(statearr_29746[(6)] = c__27074__auto__);

return statearr_29746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));

return c__27074__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__29749 = arguments.length;
switch (G__29749) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__29762 = arguments.length;
switch (G__29762) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__29778 = arguments.length;
switch (G__29778) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27074__auto___31356 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_29810){
var state_val_29811 = (state_29810[(1)]);
if((state_val_29811 === (7))){
var inst_29803 = (state_29810[(2)]);
var state_29810__$1 = state_29810;
var statearr_29814_31360 = state_29810__$1;
(statearr_29814_31360[(2)] = inst_29803);

(statearr_29814_31360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29811 === (1))){
var inst_29782 = null;
var state_29810__$1 = (function (){var statearr_29816 = state_29810;
(statearr_29816[(7)] = inst_29782);

return statearr_29816;
})();
var statearr_29822_31361 = state_29810__$1;
(statearr_29822_31361[(2)] = null);

(statearr_29822_31361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29811 === (4))){
var inst_29787 = (state_29810[(8)]);
var inst_29787__$1 = (state_29810[(2)]);
var inst_29788 = (inst_29787__$1 == null);
var inst_29789 = cljs.core.not(inst_29788);
var state_29810__$1 = (function (){var statearr_29830 = state_29810;
(statearr_29830[(8)] = inst_29787__$1);

return statearr_29830;
})();
if(inst_29789){
var statearr_29835_31362 = state_29810__$1;
(statearr_29835_31362[(1)] = (5));

} else {
var statearr_29837_31363 = state_29810__$1;
(statearr_29837_31363[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29811 === (6))){
var state_29810__$1 = state_29810;
var statearr_29840_31364 = state_29810__$1;
(statearr_29840_31364[(2)] = null);

(statearr_29840_31364[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29811 === (3))){
var inst_29805 = (state_29810[(2)]);
var inst_29807 = cljs.core.async.close_BANG_(out);
var state_29810__$1 = (function (){var statearr_29849 = state_29810;
(statearr_29849[(9)] = inst_29805);

return statearr_29849;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29810__$1,inst_29807);
} else {
if((state_val_29811 === (2))){
var state_29810__$1 = state_29810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29810__$1,(4),ch);
} else {
if((state_val_29811 === (11))){
var inst_29787 = (state_29810[(8)]);
var inst_29797 = (state_29810[(2)]);
var inst_29782 = inst_29787;
var state_29810__$1 = (function (){var statearr_29859 = state_29810;
(statearr_29859[(7)] = inst_29782);

(statearr_29859[(10)] = inst_29797);

return statearr_29859;
})();
var statearr_29860_31366 = state_29810__$1;
(statearr_29860_31366[(2)] = null);

(statearr_29860_31366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29811 === (9))){
var inst_29787 = (state_29810[(8)]);
var state_29810__$1 = state_29810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29810__$1,(11),out,inst_29787);
} else {
if((state_val_29811 === (5))){
var inst_29782 = (state_29810[(7)]);
var inst_29787 = (state_29810[(8)]);
var inst_29791 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29787,inst_29782);
var state_29810__$1 = state_29810;
if(inst_29791){
var statearr_29869_31373 = state_29810__$1;
(statearr_29869_31373[(1)] = (8));

} else {
var statearr_29871_31376 = state_29810__$1;
(statearr_29871_31376[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29811 === (10))){
var inst_29800 = (state_29810[(2)]);
var state_29810__$1 = state_29810;
var statearr_29872_31377 = state_29810__$1;
(statearr_29872_31377[(2)] = inst_29800);

(statearr_29872_31377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29811 === (8))){
var inst_29782 = (state_29810[(7)]);
var tmp29865 = inst_29782;
var inst_29782__$1 = tmp29865;
var state_29810__$1 = (function (){var statearr_29873 = state_29810;
(statearr_29873[(7)] = inst_29782__$1);

return statearr_29873;
})();
var statearr_29874_31390 = state_29810__$1;
(statearr_29874_31390[(2)] = null);

(statearr_29874_31390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_29878 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29878[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_29878[(1)] = (1));

return statearr_29878;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_29810){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_29810);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e29881){var ex__26718__auto__ = e29881;
var statearr_29883_31422 = state_29810;
(statearr_29883_31422[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_29810[(4)]))){
var statearr_29884_31429 = state_29810;
(statearr_29884_31429[(1)] = cljs.core.first((state_29810[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31440 = state_29810;
state_29810 = G__31440;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_29810){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_29810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_29887 = f__27075__auto__();
(statearr_29887[(6)] = c__27074__auto___31356);

return statearr_29887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__29894 = arguments.length;
switch (G__29894) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27074__auto___31482 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_29937){
var state_val_29938 = (state_29937[(1)]);
if((state_val_29938 === (7))){
var inst_29932 = (state_29937[(2)]);
var state_29937__$1 = state_29937;
var statearr_29944_31492 = state_29937__$1;
(statearr_29944_31492[(2)] = inst_29932);

(statearr_29944_31492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (1))){
var inst_29896 = (new Array(n));
var inst_29897 = inst_29896;
var inst_29898 = (0);
var state_29937__$1 = (function (){var statearr_29945 = state_29937;
(statearr_29945[(7)] = inst_29897);

(statearr_29945[(8)] = inst_29898);

return statearr_29945;
})();
var statearr_29946_31495 = state_29937__$1;
(statearr_29946_31495[(2)] = null);

(statearr_29946_31495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (4))){
var inst_29901 = (state_29937[(9)]);
var inst_29901__$1 = (state_29937[(2)]);
var inst_29902 = (inst_29901__$1 == null);
var inst_29903 = cljs.core.not(inst_29902);
var state_29937__$1 = (function (){var statearr_29947 = state_29937;
(statearr_29947[(9)] = inst_29901__$1);

return statearr_29947;
})();
if(inst_29903){
var statearr_29948_31500 = state_29937__$1;
(statearr_29948_31500[(1)] = (5));

} else {
var statearr_29949_31501 = state_29937__$1;
(statearr_29949_31501[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (15))){
var inst_29925 = (state_29937[(2)]);
var state_29937__$1 = state_29937;
var statearr_29950_31506 = state_29937__$1;
(statearr_29950_31506[(2)] = inst_29925);

(statearr_29950_31506[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (13))){
var state_29937__$1 = state_29937;
var statearr_29951_31511 = state_29937__$1;
(statearr_29951_31511[(2)] = null);

(statearr_29951_31511[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (6))){
var inst_29898 = (state_29937[(8)]);
var inst_29921 = (inst_29898 > (0));
var state_29937__$1 = state_29937;
if(cljs.core.truth_(inst_29921)){
var statearr_29952_31521 = state_29937__$1;
(statearr_29952_31521[(1)] = (12));

} else {
var statearr_29953_31522 = state_29937__$1;
(statearr_29953_31522[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (3))){
var inst_29934 = (state_29937[(2)]);
var state_29937__$1 = state_29937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29937__$1,inst_29934);
} else {
if((state_val_29938 === (12))){
var inst_29897 = (state_29937[(7)]);
var inst_29923 = cljs.core.vec(inst_29897);
var state_29937__$1 = state_29937;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29937__$1,(15),out,inst_29923);
} else {
if((state_val_29938 === (2))){
var state_29937__$1 = state_29937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29937__$1,(4),ch);
} else {
if((state_val_29938 === (11))){
var inst_29914 = (state_29937[(2)]);
var inst_29915 = (new Array(n));
var inst_29897 = inst_29915;
var inst_29898 = (0);
var state_29937__$1 = (function (){var statearr_29954 = state_29937;
(statearr_29954[(7)] = inst_29897);

(statearr_29954[(10)] = inst_29914);

(statearr_29954[(8)] = inst_29898);

return statearr_29954;
})();
var statearr_29955_31530 = state_29937__$1;
(statearr_29955_31530[(2)] = null);

(statearr_29955_31530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (9))){
var inst_29897 = (state_29937[(7)]);
var inst_29912 = cljs.core.vec(inst_29897);
var state_29937__$1 = state_29937;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29937__$1,(11),out,inst_29912);
} else {
if((state_val_29938 === (5))){
var inst_29901 = (state_29937[(9)]);
var inst_29897 = (state_29937[(7)]);
var inst_29906 = (state_29937[(11)]);
var inst_29898 = (state_29937[(8)]);
var inst_29905 = (inst_29897[inst_29898] = inst_29901);
var inst_29906__$1 = (inst_29898 + (1));
var inst_29908 = (inst_29906__$1 < n);
var state_29937__$1 = (function (){var statearr_29957 = state_29937;
(statearr_29957[(11)] = inst_29906__$1);

(statearr_29957[(12)] = inst_29905);

return statearr_29957;
})();
if(cljs.core.truth_(inst_29908)){
var statearr_29959_31542 = state_29937__$1;
(statearr_29959_31542[(1)] = (8));

} else {
var statearr_29960_31544 = state_29937__$1;
(statearr_29960_31544[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (14))){
var inst_29928 = (state_29937[(2)]);
var inst_29930 = cljs.core.async.close_BANG_(out);
var state_29937__$1 = (function (){var statearr_29963 = state_29937;
(statearr_29963[(13)] = inst_29928);

return statearr_29963;
})();
var statearr_29964_31546 = state_29937__$1;
(statearr_29964_31546[(2)] = inst_29930);

(statearr_29964_31546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (10))){
var inst_29918 = (state_29937[(2)]);
var state_29937__$1 = state_29937;
var statearr_29966_31549 = state_29937__$1;
(statearr_29966_31549[(2)] = inst_29918);

(statearr_29966_31549[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29938 === (8))){
var inst_29897 = (state_29937[(7)]);
var inst_29906 = (state_29937[(11)]);
var tmp29961 = inst_29897;
var inst_29897__$1 = tmp29961;
var inst_29898 = inst_29906;
var state_29937__$1 = (function (){var statearr_29967 = state_29937;
(statearr_29967[(7)] = inst_29897__$1);

(statearr_29967[(8)] = inst_29898);

return statearr_29967;
})();
var statearr_29969_31555 = state_29937__$1;
(statearr_29969_31555[(2)] = null);

(statearr_29969_31555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_29971 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29971[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_29971[(1)] = (1));

return statearr_29971;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_29937){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_29937);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e29973){var ex__26718__auto__ = e29973;
var statearr_29974_31570 = state_29937;
(statearr_29974_31570[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_29937[(4)]))){
var statearr_29975_31573 = state_29937;
(statearr_29975_31573[(1)] = cljs.core.first((state_29937[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31581 = state_29937;
state_29937 = G__31581;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_29937){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_29937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_29977 = f__27075__auto__();
(statearr_29977[(6)] = c__27074__auto___31482);

return statearr_29977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__29984 = arguments.length;
switch (G__29984) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27074__auto___31598 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27075__auto__ = (function (){var switch__26714__auto__ = (function (state_30033){
var state_val_30034 = (state_30033[(1)]);
if((state_val_30034 === (7))){
var inst_30029 = (state_30033[(2)]);
var state_30033__$1 = state_30033;
var statearr_30046_31605 = state_30033__$1;
(statearr_30046_31605[(2)] = inst_30029);

(statearr_30046_31605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (1))){
var inst_29992 = [];
var inst_29993 = inst_29992;
var inst_29994 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30033__$1 = (function (){var statearr_30047 = state_30033;
(statearr_30047[(7)] = inst_29994);

(statearr_30047[(8)] = inst_29993);

return statearr_30047;
})();
var statearr_30049_31619 = state_30033__$1;
(statearr_30049_31619[(2)] = null);

(statearr_30049_31619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (4))){
var inst_29997 = (state_30033[(9)]);
var inst_29997__$1 = (state_30033[(2)]);
var inst_29998 = (inst_29997__$1 == null);
var inst_29999 = cljs.core.not(inst_29998);
var state_30033__$1 = (function (){var statearr_30052 = state_30033;
(statearr_30052[(9)] = inst_29997__$1);

return statearr_30052;
})();
if(inst_29999){
var statearr_30053_31627 = state_30033__$1;
(statearr_30053_31627[(1)] = (5));

} else {
var statearr_30054_31628 = state_30033__$1;
(statearr_30054_31628[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (15))){
var inst_30023 = (state_30033[(2)]);
var state_30033__$1 = state_30033;
var statearr_30055_31632 = state_30033__$1;
(statearr_30055_31632[(2)] = inst_30023);

(statearr_30055_31632[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (13))){
var state_30033__$1 = state_30033;
var statearr_30059_31635 = state_30033__$1;
(statearr_30059_31635[(2)] = null);

(statearr_30059_31635[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (6))){
var inst_29993 = (state_30033[(8)]);
var inst_30018 = inst_29993.length;
var inst_30019 = (inst_30018 > (0));
var state_30033__$1 = state_30033;
if(cljs.core.truth_(inst_30019)){
var statearr_30063_31640 = state_30033__$1;
(statearr_30063_31640[(1)] = (12));

} else {
var statearr_30065_31641 = state_30033__$1;
(statearr_30065_31641[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (3))){
var inst_30031 = (state_30033[(2)]);
var state_30033__$1 = state_30033;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30033__$1,inst_30031);
} else {
if((state_val_30034 === (12))){
var inst_29993 = (state_30033[(8)]);
var inst_30021 = cljs.core.vec(inst_29993);
var state_30033__$1 = state_30033;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30033__$1,(15),out,inst_30021);
} else {
if((state_val_30034 === (2))){
var state_30033__$1 = state_30033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30033__$1,(4),ch);
} else {
if((state_val_30034 === (11))){
var inst_30001 = (state_30033[(10)]);
var inst_29997 = (state_30033[(9)]);
var inst_30011 = (state_30033[(2)]);
var inst_30012 = [];
var inst_30013 = inst_30012.push(inst_29997);
var inst_29993 = inst_30012;
var inst_29994 = inst_30001;
var state_30033__$1 = (function (){var statearr_30069 = state_30033;
(statearr_30069[(11)] = inst_30011);

(statearr_30069[(7)] = inst_29994);

(statearr_30069[(8)] = inst_29993);

(statearr_30069[(12)] = inst_30013);

return statearr_30069;
})();
var statearr_30073_31657 = state_30033__$1;
(statearr_30073_31657[(2)] = null);

(statearr_30073_31657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (9))){
var inst_29993 = (state_30033[(8)]);
var inst_30009 = cljs.core.vec(inst_29993);
var state_30033__$1 = state_30033;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30033__$1,(11),out,inst_30009);
} else {
if((state_val_30034 === (5))){
var inst_29994 = (state_30033[(7)]);
var inst_30001 = (state_30033[(10)]);
var inst_29997 = (state_30033[(9)]);
var inst_30001__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_29997) : f.call(null,inst_29997));
var inst_30002 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30001__$1,inst_29994);
var inst_30003 = cljs.core.keyword_identical_QMARK_(inst_29994,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30004 = ((inst_30002) || (inst_30003));
var state_30033__$1 = (function (){var statearr_30078 = state_30033;
(statearr_30078[(10)] = inst_30001__$1);

return statearr_30078;
})();
if(cljs.core.truth_(inst_30004)){
var statearr_30080_31668 = state_30033__$1;
(statearr_30080_31668[(1)] = (8));

} else {
var statearr_30081_31669 = state_30033__$1;
(statearr_30081_31669[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (14))){
var inst_30026 = (state_30033[(2)]);
var inst_30027 = cljs.core.async.close_BANG_(out);
var state_30033__$1 = (function (){var statearr_30090 = state_30033;
(statearr_30090[(13)] = inst_30026);

return statearr_30090;
})();
var statearr_30091_31676 = state_30033__$1;
(statearr_30091_31676[(2)] = inst_30027);

(statearr_30091_31676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (10))){
var inst_30016 = (state_30033[(2)]);
var state_30033__$1 = state_30033;
var statearr_30092_31679 = state_30033__$1;
(statearr_30092_31679[(2)] = inst_30016);

(statearr_30092_31679[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30034 === (8))){
var inst_30001 = (state_30033[(10)]);
var inst_29993 = (state_30033[(8)]);
var inst_29997 = (state_30033[(9)]);
var inst_30006 = inst_29993.push(inst_29997);
var tmp30084 = inst_29993;
var inst_29993__$1 = tmp30084;
var inst_29994 = inst_30001;
var state_30033__$1 = (function (){var statearr_30093 = state_30033;
(statearr_30093[(7)] = inst_29994);

(statearr_30093[(14)] = inst_30006);

(statearr_30093[(8)] = inst_29993__$1);

return statearr_30093;
})();
var statearr_30095_31685 = state_30033__$1;
(statearr_30095_31685[(2)] = null);

(statearr_30095_31685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__26715__auto__ = null;
var cljs$core$async$state_machine__26715__auto____0 = (function (){
var statearr_30104 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30104[(0)] = cljs$core$async$state_machine__26715__auto__);

(statearr_30104[(1)] = (1));

return statearr_30104;
});
var cljs$core$async$state_machine__26715__auto____1 = (function (state_30033){
while(true){
var ret_value__26716__auto__ = (function (){try{while(true){
var result__26717__auto__ = switch__26714__auto__(state_30033);
if(cljs.core.keyword_identical_QMARK_(result__26717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26717__auto__;
}
break;
}
}catch (e30105){var ex__26718__auto__ = e30105;
var statearr_30106_31691 = state_30033;
(statearr_30106_31691[(2)] = ex__26718__auto__);


if(cljs.core.seq((state_30033[(4)]))){
var statearr_30107_31694 = state_30033;
(statearr_30107_31694[(1)] = cljs.core.first((state_30033[(4)])));

} else {
throw ex__26718__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31699 = state_30033;
state_30033 = G__31699;
continue;
} else {
return ret_value__26716__auto__;
}
break;
}
});
cljs$core$async$state_machine__26715__auto__ = function(state_30033){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26715__auto____1.call(this,state_30033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26715__auto____0;
cljs$core$async$state_machine__26715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26715__auto____1;
return cljs$core$async$state_machine__26715__auto__;
})()
})();
var state__27076__auto__ = (function (){var statearr_30113 = f__27075__auto__();
(statearr_30113[(6)] = c__27074__auto___31598);

return statearr_30113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27076__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
