(ns btreekeys.dynamic
  (:require [btreekeys.query :as query]
            [btreekeys.core :as bt])
  (:import java.util.TreeSet
           com.google.common.primitives.UnsignedBytes
           java.util.Comparator))

(defmulti keysegment-write
  (fn [keypart-type buffer value] keypart-type))

(defmulti keysegment-read
  (fn [keypart-type buffer] keypart-type))

(def execute-query-type nil)
(defmulti execute-query-type :q)

(defmethod execute-query-type :eq
  [context]
  (execute-query-type (assoc context :q :in :values (:value context))))

(defn make-keysegment
  [structure-type keysegment-key value]
  )

#_(defn lexicographical-sort
  [{:keys [structure-type keysegment-key start values]}]
  (let [tree-set (TreeSet. ^Comparator (UnsignedBytes/lexicographicalComparator))]
    (doseq [value-binding values]
      (.add tree-set (make-keysegment structure-type keysegment-key value-binding)))
    (if skip-to
      (seq (.tailSet tree-set skip-to))
      (seq tree-set))))

(defmethod execute-query-type :in
  [context cont]
  (doseq [value (lexicographical-sort context)])

  (execute-query-type (assoc context :q :in :values (:value context))))

#_(defn execute-query
  [keypart-type iterator query]
  (query/create-reducable
    (fn [iterate rf init]
      (let [acc init
            optmised-query
            (->> query-map
                 (normalize-query (bt/key-structure structure-type))
                 optimize-query)]
        ()
        ))))
