(ns mecha1.decorum.tile
  (:require
    [garden.stylesheet :refer [at-media]]
    [mecha1.seed :as seed]
    [rum.core :as rum]))

(def style
  (seed/style
    [:.tile {:margin "0 0 15px"
             :right  0}
     [:.tile-link {:display   "block"
                   :position  "relative"
                   :max-width "400px"
                   :margin    "0 auto"}
      [:.tile-hover {:position   "absolute"
                     :width      "100%"
                     :height     "100%"
                     :opacity    0
                     :transition "all ease 0.5s"}
       ["&:hover" {:opacity 1}]]]]

    (at-media {:min-width "767px"}
              [:.tile {:margin "0 0 30px"}])))

(rum/defc tile
  < {:key-fn (fn [_ idx] idx)}
  [{:keys [::content
           ::caption
           ::hover
           ::link]}]
  [:div {:class (style :tile)}
   ; tile
   [:a (merge {:class (style :tile-link)}
              (if (string? link)
                {:href link}
                link))
    [:div {:class (style :tile-hover)}
     hover]
    content]

   ; caption
   caption])
