(ns mecha1.decorum.page-scroll
  (:require
    [mecha1.seed :as seed]
    #?(:cljs [cljsjs.jquery-ui])))

(def page-scroll-anchor-selector (str "a" (seed/css-class-ref ::page-scroll)))

#?(:cljs
   (defn get-page-scroll-anchor [e]
     (if (.matches e "a")
       e
       (get-page-scroll-anchor (.-parentElement e)))))

(defn scroll-page-handler [offset-px]
  #?(:cljs
     (fn [event]
       (let [anchor (get-page-scroll-anchor (.-target event))
             target (js/jQuery (.-hash anchor))]
         (-> (js/jQuery "html, body")
             (.stop)
             (.animate #js {:scrollTop (- (.. target offset -top) offset-px)}
                       1250                                 ; duration in milliseconds
                       "easeInOutExpo")))
       (.preventDefault event))))

(defn bind-click-handler-for-page-scroll-anchors
  ([] (bind-click-handler-for-page-scroll-anchors 50))
  ([offset-px]
    #?(:cljs
       ; smooth page scrolling animation when clicking links
       (.bind (js/jQuery page-scroll-anchor-selector)
              "click"
              (scroll-page-handler offset-px)))))

(def css-class (str ::page-scroll))
