(ns mecha1.decorum.modal
  (:require
    [mecha1.seed :as seed]
    [rum.core :as rum]))

(def style
  (seed/style
    [:.tile-modal
     [".modal-backdrop" {:opacity 0
                         :display "none"}]
     [".modal-dialog" {:margin 0
                       :height "100%"
                       :width  "auto"}]]))

(rum/defc modal < {:key-fn (fn [idx _] idx)}
  [modal-id modal-content]
  [:div.modal.fade {:id modal-id
                    :class (style :tile-modal)
                    :tab-index "-1"
                    :role "dialog"
                    :aria-hidden "true"}
   [:div.modal-dialog
    modal-content]])
