(ns mecha1.decorum.google-map
  (:require
    [rum.core :as rum]))

(rum/defc google-map
  "Embedded Google Map component.

  Takes the following options:
    :key (required) - Google Maps API key
    :query (required) - Google Maps query (must be URL escaped)
    :width (optional) - width in CSS units
    :height (optional) - height in CSS units"
  [{:keys [key query
           frame-border
           allow-full-screen
           style]
    :or   {frame-border 0
           allow-full-screen true
           style {:width "100%"
                  :height "50%"}}}]
  [:iframe (cond-> {:src (str "https://www.google.com/maps/embed/v1/place?key=" key "&q=" query)}
                   frame-border (conj [:frameBorder frame-border])
                   allow-full-screen (conj [:allowFullScreen allow-full-screen])
                   style (conj [:style style]))])
