(ns mecha1.decorum.page-scroll
  (:require
    [mecha1.seed :as seed]
    #?(:cljs [cljsjs.jquery-ui])))

(defn init
  ([] (init 50))
  ([offset-px]
    #?(:cljs
       ; smooth page scrolling animation when clicking links
       (.bind (js/jQuery (str "a" (seed/css-class-ref ::page-scroll)))
              "click"
              (fn [event]
                (this-as this
                  (let [anchor (js/jQuery this)
                        target (js/jQuery (.attr anchor "href"))]
                    (-> (js/jQuery "html, body")
                        (.stop)
                        (.animate #js {:scrollTop (- (.. target offset -top) offset-px)}
                                  1250                      ; duration in milliseconds
                                  "easeInOutExpo")))
                  (.preventDefault event)))))))

(def css-class (str ::page-scroll))
