(ns mecha1.decorum.carousel
  (:require
    [mecha1.seed :as seed]
    [rum.core :as rum]))

(rum/defc carousel [id slides]
  (let [id-ref (str "#" (seed/css-escape id))]
    [:div.carousel.slide {:id id, :data-ride "carousel"}
     ; ... slide indicator
     [:ol.carousel-indicators
      (for [i (range (count slides))]
        [:li {:key           i
              :data-target   id-ref
              :data-slide-to i
              :class         (when (= i 0) "active")}])]

     ; slides
     [:div.carousel-inner {:role "listbox"}
      (for [[i {:keys [img caption] :as slide}] (map-indexed vector slides)]
        [:div.item {:key   i
                    :class (when (= i 0) "active")}
         (if (fn? img) (img) img)
         [:div.container
          [:div.carousel-caption
           (if (fn? caption) (caption) caption)]]])]

     ; < previous slide
     [:a.left.carousel-control {:href id-ref, :role "button", :data-slide "prev"}
      [:span.glyphicon.glyphicon-chevron-left {:aria-hidden "true"}]
      [:span.sr-only "Previous"]]
     ; > next slide
     [:a.right.carousel-control {:href id-ref, :role "button", :data-slide "next"}
      [:span.glyphicon.glyphicon-chevron-right {:aria-hidden "true"}]
      [:span.sr-only "Next"]]]))
