(ns mecha1.decorum.affix
  (:require
    [garden.stylesheet :refer [at-media]]
    [mecha1.seed :as seed]
    #?(:cljs [cljsjs.bootstrap])))

(def style
  (seed/style
    ; fade brand logo in/out on affix
    [".affix-top"
     [".navbar-brand" {:filter     "opacity(0%)"
                       :transition "filter 0.25s, font-size 0.25s"}]]
    [".affix"
     [".navbar-brand" {:transition "filter 0.5s, font-size 0.5s"}]]

    (at-media {:min-width "768px"}
              ; not affixed styles
              [".navbar" {:background-color "transparent"
                          :padding          "25px 0"
                          :transition       "padding 0.3s"
                          :border           "none"}
               [".navbar-brand" {:font-size  "2em"
                                 :transition "all 0.3s"}]
               ; affixed styles
               ["&.affix" {:background-color "blue"
                           :padding          "10px 0"}
                ; shrink font size when affixed
                [".navbar-brand" {:font-size "1.5em"}]]])))

#_{:data-spy "affix", :data-offset-top (* height-px 2)}

(defn init [dom-node height-px]
  #?(:cljs
     ; affix header to top of screen when scrolling
     (.affix (js/jQuery (.-firstChild dom-node)) #js {:offset #js {:top (* height-px 2)}})))
