(ns mecha1.decorum.nav
  (:require
    [garden.stylesheet :refer [at-media]]
    [mecha1.seed :as seed]
    [rum.core :as rum]
    #?(:cljs [cljsjs.jquery-ui])))

(def default-bar-color "#222222")
(def default-text-color "white")
(def default-hover-color "#fec503")
(def default-selected-color "#fed136")

(defn set-style
  [{:keys [::bar-color
           ::text-color
           ::hover-color
           ::selected-color]
    :or   {bar-color      default-bar-color
           text-color     default-text-color
           hover-color    default-hover-color
           selected-color default-selected-color}}]
  ((seed/style
    [".navbar" {:background-color bar-color
                :border-color     "transparent"}

     ; collapsible nav items section
     [".navbar-collapse" {:border-color "rgba(255, 255, 255, 0.02)"}]

     ; nav items
     [".nav li a" {:font-weight    400
                   :letter-spacing "1px"
                   :color          text-color}
      ; hover/focus nav item
      ["&:hover"
       "&:focus" {:color   hover-color
                  :outline "none"}]]
     ; active nav item
     [".navbar-nav > .active > a" {:border-radius    0
                                   :background-color selected-color
                                   :color            text-color}
      ; hover/focus active nav item
      ["&:hover"
       "&:focus" {:color            text-color
                  :background-color hover-color}]]

     ; menu toggle button
     [".navbar-toggle" {:border-color     "transparent"
                        :background-color selected-color
                        :color            text-color
                        :font-size        "12px"}
      ["&:hover"
       "&:focus" {:background-color hover-color}]]]

    (at-media {:min-width "768px"}
              ; not affixed styles
              [".navbar" {:background-color "transparent"
                          :padding          "25px 0"
                          :transition       "padding 0.3s"
                          :border           "none"}
               [".navbar-brand" {:font-size  "2em"
                                 :transition "all 0.3s"}]
               ; affixed styles
               ["&.affix" {:background-color bar-color
                           :padding          "10px 0"}
                ; shrink font size when affixed
                [".navbar-brand" {:font-size "1.5em"}]]

               ; rounded button for active nav item
               [".navbar-nav > .active > a" {:border-radius "3px"}]]))))

(rum/defc nav
  < {:did-mount (fn [{:keys [:rum/args] :as state}]
                  #?(:cljs
                     (let [[{:keys [::height-px] :or {height-px 50}}] args]
                       ; smooth page scrolling animation when clicking links
                       (.bind (js/jQuery (str "a" (seed/css-class-ref ::page-scroll)))
                              "click"
                              (fn [event]
                                (this-as this
                                  (let [anchor (js/jQuery this)
                                        target (js/jQuery (.attr anchor "href"))]
                                    (-> (js/jQuery "html, body")
                                        (.stop)
                                        (.animate #js {:scrollTop (- (.. target offset -top) height-px)}
                                                  1250      ; duration in milliseconds
                                                  "easeInOutExpo")))
                                  (.preventDefault event))))

                       ; highlight links when scrolled to section
                       (.scrollspy (js/jQuery "body") #js {:target ".navbar-fixed-top"
                                                           :offset (inc height-px) ; navbar height
                                                           })))
                  state)}
  [{:keys [::id ::brand ::items ::style ::height-px] :or {height-px 50}}]
  (set-style style)
  (let [collapse-id (str id ::collapse)]
    [:div {:id (str id)}
     ; affix header to top of screen when scrolling
     [:nav.navbar.navbar-default.navbar-fixed-top {:data-spy "affix", :data-offset-top (* height-px 2)}
      [:div.container
       ; Brand and toggle get grouped for better mobile display
       [:div.navbar-header
        ; toggle
        [:button.navbar-toggle {:type        "button"
                                :data-toggle "collapse"
                                :data-target (seed/css-id-ref collapse-id)}
         [:span.sr-only "Toggle navigation"] " Menu "]

        ; brand
        [:div.navbar-brand
         brand]]

       ; Collect the nav links, forms, and other content for toggling
       [:div.collapse.navbar-collapse {:id collapse-id}
        [:ul.nav.navbar-nav.navbar-right
         (for [item items]
           [:li {:key item}
            item])]]]]]))

(def page-scroll-class (str ::page-scroll))
