/*
 * Decompiled with CFR 0.152.
 */
package net.ipip.datx;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import me.zhenchuan.base.ResourceFileReader;
import net.ipip.datx.IPv4FormatException;
import net.ipip.datx.Util;

public class City
extends ResourceFileReader {
    private byte[] data;
    private long indexSize;

    public City(String name) throws IOException {
        this.data = this.readBytes(name);
        this.indexSize = Util.bytesToLong(this.data[0], this.data[1], this.data[2], this.data[3]);
    }

    public String[] find(long val) {
        int start = 262148;
        int low = 0;
        int mid = 0;
        int high = new Long((this.indexSize - 262144L - 262148L) / 9L).intValue() - 1;
        int pos = 0;
        while (low <= high) {
            long end;
            mid = new Double((low + high) / 2).intValue();
            pos = mid * 9;
            long s2 = 0L;
            if (mid > 0) {
                int pos1 = (mid - 1) * 9;
                s2 = Util.bytesToLong(this.data[start + pos1], this.data[start + pos1 + 1], this.data[start + pos1 + 2], this.data[start + pos1 + 3]);
            }
            if (val > (end = Util.bytesToLong(this.data[start + pos], this.data[start + pos + 1], this.data[start + pos + 2], this.data[start + pos + 3]))) {
                low = mid + 1;
                continue;
            }
            if (val < s2) {
                high = mid - 1;
                continue;
            }
            byte b2 = 0;
            long off = Util.bytesToLong(b2, this.data[start + pos + 6], this.data[start + pos + 5], this.data[start + pos + 4]);
            long len = Util.bytesToLong(b2, b2, this.data[start + pos + 7], this.data[start + pos + 8]);
            int offset = new Long(off - 262144L + this.indexSize).intValue();
            byte[] loc = Arrays.copyOfRange(this.data, offset, offset + new Long(len).intValue());
            return new String(loc, Charset.forName("UTF-8")).split("\t", -1);
        }
        return null;
    }

    public String[] find(String ips) throws IPv4FormatException {
        if (!Util.isIPv4Address(ips)) {
            throw new IPv4FormatException();
        }
        long val = Util.ip2long(ips);
        return this.find(val);
    }
}

