/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sparkey;

import com.spotify.sparkey.MurmurHash3;

public enum HashType {
    HASH_64_BITS(8){

        @Override
        public long hash(int keyLen, byte[] key, int seed) {
            return MurmurHash3.murmurHash3_x64_64(key, keyLen, seed);
        }
    }
    ,
    HASH_32_BITS(4){

        @Override
        public long hash(int keyLen, byte[] key, int seed) {
            return (long)MurmurHash3.murmurHash3_x86_32(key, keyLen, seed) & 0xFFFFFFFFL;
        }
    };

    private static final long BITS_32 = 0xFFFFFFFFL;
    private static final long INT_MASK = 0xFFFFFFFFL;
    private final int size;

    private HashType(int size) {
        this.size = size;
    }

    public abstract long hash(int var1, byte[] var2, int var3);

    public int size() {
        return this.size;
    }
}

