/*
 * Decompiled with CFR 0.152.
 */
package com.ipinyou.rpc.dependency;

import com.ipinyou.rpc.dependency.In;
import com.ipinyou.rpc.dependency.LongCodec;
import com.ipinyou.rpc.dependency.Out;
import java.nio.charset.Charset;

public class StringCodec {
    private static final Charset utf8 = Charset.forName("utf-8");

    public static void encode(String data, Out out) {
        byte[] bytes = data.getBytes(utf8);
        LongCodec.encodeU(bytes.length, out);
        out.write(bytes);
    }

    public static String decode(In in) {
        int len = (int)LongCodec.decodeU(in);
        byte[] bytes = new byte[len];
        in.read(bytes);
        return new String(bytes, utf8);
    }

    public static int compare(In in1, In in2) {
        int len1 = (int)LongCodec.decodeU(in1);
        int len2 = (int)LongCodec.decodeU(in2);
        int lim = Math.min(len1, len2);
        for (int i2 = 0; i2 < lim; ++i2) {
            int c2;
            int c1 = 0xFF & in1.read();
            if (c1 < (c2 = 0xFF & in2.read())) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        return len1 < len2 ? -1 : (len1 == len2 ? 0 : 1);
    }
}

