/*
 * Decompiled with CFR 0.152.
 */
package com.ipinyou.rpc.dependency;

import com.ipinyou.rpc.dependency.In;
import com.ipinyou.rpc.dependency.Input;
import com.ipinyou.rpc.dependency.LongCodec;
import com.ipinyou.rpc.dependency.O;
import com.ipinyou.rpc.dependency.Out;
import com.ipinyou.rpc.dependency.Output;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalCodec {
    public static void encodeLong(BigDecimal data, int scale, Out out) {
        if (data.scale() != scale) {
            data = data.setScale(scale);
        }
        O.required(data.precision() <= 18, "data.precision() <= 18");
        LongCodec.encode(data.unscaledValue().longValue(), out);
    }

    public static byte[] encodeLong(BigDecimal data, int scale) {
        Output out = new Output();
        DecimalCodec.encodeLong(data, scale, out);
        return out.toByteArray();
    }

    public static BigDecimal decodeLong(In in, int scale) {
        return BigDecimal.valueOf(LongCodec.decode(in), scale);
    }

    public static BigDecimal decodeLong(byte[] bytes, int scale) {
        return DecimalCodec.decodeLong(new Input(bytes), scale);
    }

    public static void encodeBytes(BigDecimal data, int scale, Out out) {
        if (data.scale() != scale) {
            data = data.setScale(scale, 4);
        }
        byte[] bs = data.unscaledValue().toByteArray();
        LongCodec.encodeU(bs.length, out);
        out.write(bs, 0, bs.length);
    }

    public static byte[] encodeBytes(BigDecimal data, int scale) {
        Output out = new Output();
        DecimalCodec.encodeBytes(data, scale, out);
        return out.toByteArray();
    }

    public static BigDecimal decodeBytes(In in, int scale) {
        byte[] bs = new byte[(int)LongCodec.decodeU(in)];
        in.read(bs);
        return new BigDecimal(new BigInteger(bs), scale);
    }

    public static BigDecimal decodeBytes(byte[] bytes, int scale) {
        return DecimalCodec.decodeBytes(new Input(bytes), scale);
    }
}

