/*
 * Decompiled with CFR 0.152.
 */
package net.ipip.datx;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public class Util {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");

    public static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static long bytesToLong(byte a2, byte b2, byte c2, byte d2) {
        return Util.int2long((a2 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (c2 & 0xFF) << 8 | d2 & 0xFF);
    }

    private static int str2Ip(String ip) {
        String[] ss = ip.split("\\.");
        int a2 = Integer.parseInt(ss[0]);
        int b2 = Integer.parseInt(ss[1]);
        int c2 = Integer.parseInt(ss[2]);
        int d2 = Integer.parseInt(ss[3]);
        return a2 << 24 | b2 << 16 | c2 << 8 | d2;
    }

    public static int str2Ip2(String ip) {
        try {
            byte[] bytes = InetAddress.getByName(ip).getAddress();
            return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3];
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    public static long ip2long(String ip) {
        return Util.int2long(Util.str2Ip(ip));
    }

    private static long int2long(int i2) {
        long l2 = (long)i2 & Integer.MAX_VALUE;
        if (i2 < 0) {
            l2 |= 0x80000000L;
        }
        return l2;
    }
}

