/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.ua;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.net.URLDecoder;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.zhenchuan.base.enums.DeviceModel;
import me.zhenchuan.base.enums.DeviceType;
import me.zhenchuan.base.enums.Manufacturer;
import me.zhenchuan.dict.ModelKeyword;
import me.zhenchuan.ua.ModelParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgent {
    private static final Logger log = LoggerFactory.getLogger(UserAgent.class);
    OS os = new OS();
    Device device = new Device();
    Browser browser = new Browser();
    static final String momoRegex = "MomoChat.*?\\((.*?);(.*?);.*;(.*)\\)";
    static final Pattern momoPattern = Pattern.compile("MomoChat.*?\\((.*?);(.*?);.*;(.*)\\)", 2);
    static final String funRegex = ".*?\\((.*)\\/(.*?)\\)?;(.*?);(.*)\\)";
    static final Pattern funPattern = Pattern.compile(".*?\\((.*)\\/(.*?)\\)?;(.*?);(.*)\\)", 2);
    private ModelKeyword ModelKeyword = me.zhenchuan.dict.ModelKeyword.getInstance();
    static Set<String> unKonws = Sets.newHashSet((Object[])new String[]{"", "androidVersion", "unknown", "LMY47D"});
    static final String ios1Regex = "[(;]((iphone|ipad|ipod).*?);\\s+.*?OS\\s+([\\d._]+)";
    static final Pattern ios1Pattern = Pattern.compile("[(;]((iphone|ipad|ipod).*?);\\s+.*?OS\\s+([\\d._]+)", 2);
    static final String android1Regex = "Android(.*?);(([\\d\\.\\-]+);)?([\\w\\s\\/-]*)";
    static final Pattern android1Pattern = Pattern.compile("Android(.*?);(([\\d\\.\\-]+);)?([\\w\\s\\/-]*)", 2);
    static final String x1 = "((Android|iOs|Iphone)\\s*(OS)?).*?([\\d.]+);(.*)";
    static final Pattern x1Pattern = Pattern.compile("((Android|iOs|Iphone)\\s*(OS)?).*?([\\d.]+);(.*)", 2);
    static Pattern browserPattern = Pattern.compile("(UCBrowser|MZBrowser|SogouMobileBrowser|MiuiBrowser|MQQBrowser|VivoBrowser|OppoBrowser|SamsungBrowser)/([0-9\\.]+)", 2);
    private String it;
    private static ModelParser modelParser = new ModelParser();
    static final Pattern cheat_pattern = Pattern.compile("(java|python|curl|http)", 2);

    public DeviceModel getModel() {
        return DeviceModel.NULL;
    }

    public DeviceType getDeviceType() {
        return DeviceType.from(this.device.type);
    }

    public Manufacturer getManufacturer() {
        try {
            if (this.device.manufacturer == null) {
                return Manufacturer.NULL;
            }
            return Manufacturer.valueOf(this.device.manufacturer);
        }
        catch (Exception e2) {
            return Manufacturer.NULL;
        }
    }

    public me.zhenchuan.base.enums.Browser getBrowserName() {
        try {
            return me.zhenchuan.base.enums.Browser.valueOf(this.browser.name);
        }
        catch (Exception e2) {
            return me.zhenchuan.base.enums.Browser.NULL;
        }
    }

    public double getBrowserVersion() {
        return this.browser.verison;
    }

    public boolean hasManufacturer() {
        return this.device.manufacturer != null;
    }

    public double getOsVersion() {
        return this.os.version;
    }

    public me.zhenchuan.base.enums.OS getOsName() {
        if ("ios".equalsIgnoreCase(this.os.name)) {
            return me.zhenchuan.base.enums.OS.IOS;
        }
        if ("Android".equalsIgnoreCase(this.os.name)) {
            return me.zhenchuan.base.enums.OS.Android;
        }
        return me.zhenchuan.base.enums.OS.NULL;
    }

    public String deviceModel() {
        return this.device.model;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UserAgent1{");
        sb.append("os=").append(this.os.name).append("=").append(this.os.version);
        sb.append(", device=").append(this.device.type).append("=").append(this.device.model).append("=").append(this.device.manufacturer);
        sb.append(", browser=").append(this.browser.name).append("=").append(this.browser.verison);
        sb.append('}');
        return sb.toString();
    }

    public OS getOs() {
        return this.os;
    }

    public Device getDevice() {
        return this.device;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    private void parseIOSType(String lowerCaseType) {
        if (lowerCaseType.startsWith("iph")) {
            this.device.type = DeviceType.IPHONE.name();
        } else if (lowerCaseType.startsWith("ipa")) {
            this.device.type = DeviceType.IPAD.name();
        } else if (lowerCaseType.startsWith("ipo")) {
            this.device.type = DeviceType.IPOD.name();
        }
    }

    private boolean funshion(String ua) {
        Matcher matcher = funPattern.matcher(ua);
        if (matcher.find()) {
            this.os.name = matcher.group(1);
            this.os.version = this.majorVersion(matcher.group(2));
            String lowerCaseType = matcher.group(3).trim().toLowerCase();
            if (lowerCaseType.startsWith("i")) {
                this.device.manufacturer = "Apple";
                this.parseIOSType(lowerCaseType);
            } else if (lowerCaseType.startsWith("aph")) {
                this.device.type = DeviceType.APHONE.name();
            } else if (lowerCaseType.startsWith("apo")) {
                this.device.type = DeviceType.APAD.name();
            }
            this.device.model = matcher.group(4);
            return true;
        }
        return false;
    }

    private boolean momo(String ua) {
        Matcher matcher = momoPattern.matcher(ua);
        if (matcher.find()) {
            this.device.model = matcher.group(1);
            this.device.manufacturer = this.ModelKeyword.manufacturer(matcher.group(3));
            String tmp = matcher.group(2);
            if (tmp.contains("Android")) {
                this.os.name = "Android";
            } else {
                this.os.name = "iOS";
                this.device.manufacturer = "Apple";
            }
            this.os.version = this.majorVersion(tmp.split("\\s+")[0]);
            return true;
        }
        return false;
    }

    private int majorVersion(String v) {
        if (v == null || unKonws.contains(v.trim())) {
            return 0;
        }
        StringBuilder str = new StringBuilder();
        for (int i2 = 0; i2 < v.length(); ++i2) {
            if (v.charAt(i2) == ' ') continue;
            if (v.charAt(i2) == '.' || v.charAt(i2) == '_') break;
            str.append(v.charAt(i2));
        }
        try {
            return Integer.parseInt(str.toString());
        }
        catch (Exception e2) {
            log.warn("\u89e3\u6790 {} \u5931\u8d25, {}", (Object)v, (Object)this.it);
            return 0;
        }
    }

    private boolean ios(String a2) {
        Matcher m2 = ios1Pattern.matcher(a2);
        if (m2.find()) {
            this.os.name = "iOS";
            this.device.manufacturer = "Apple";
            this.os.version = this.majorVersion(m2.group(3));
            String lowerCaseType = m2.group(1).trim().toLowerCase();
            if (lowerCaseType.startsWith("i")) {
                this.device.manufacturer = "Apple";
                this.parseIOSType(lowerCaseType);
            }
            return true;
        }
        return false;
    }

    private boolean x(String os) {
        Matcher m2 = x1Pattern.matcher(os);
        if (m2.find()) {
            if ("Android".equalsIgnoreCase(m2.group(2))) {
                this.os.name = "Android";
            } else {
                this.os.name = "iOS";
                this.device.manufacturer = "Apple";
            }
            this.os.version = this.majorVersion(m2.group(4));
            this.device.model = m2.group(5);
            return true;
        }
        return false;
    }

    private boolean android(String android) {
        int idx = android.indexOf("Android ");
        if (idx > 0) {
            this.os.name = "Android";
            int versionIdx = android.indexOf(";", idx + 7);
            if (versionIdx > 0) {
                String version = android.substring(idx + 7, versionIdx);
                this.os.version = this.majorVersion(version);
                int browserIdx = android.indexOf("AppleWebKit", versionIdx + 1);
                if (browserIdx > 0) {
                    this.device.model = android.substring(versionIdx + 1, browserIdx);
                    int browserIndex = android.indexOf("Chrome/", browserIdx);
                    if (browserIndex > 0) {
                        Matcher m2 = browserPattern.matcher(android);
                        if (m2.find()) {
                            this.browser.verison = this.majorVersion(m2.group(2));
                            this.browser.name = m2.group(1);
                        } else {
                            this.browser.name = "ChromeBrowser";
                        }
                        return true;
                    }
                    return true;
                }
                int modeEndIdx = android.indexOf(")", versionIdx);
                if (modeEndIdx > 0) {
                    this.device.model = android.substring(versionIdx + 1, modeEndIdx);
                    return true;
                }
                Matcher matcher = android1Pattern.matcher(android);
                if (matcher.find()) {
                    this.os.version = this.majorVersion(matcher.group(2));
                    this.device.model = matcher.group(3);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public String getInput() {
        return this.it;
    }

    public void parse(String it) {
        Matcher m2;
        String man;
        if (Strings.isNullOrEmpty((String)(it = this.decode(it)))) {
            return;
        }
        if (it.regionMatches(true, 0, "MomoChat", 0, 8)) {
            this.momo(it);
            return;
        }
        if (it.regionMatches(true, 0, "Funshion", 0, 8)) {
            this.funshion(it);
            return;
        }
        if (this.android(it) || this.ios(it) || this.x(it)) {
            // empty if block
        }
        if (!Strings.isNullOrEmpty((String)(man = modelParser.extractManufacturer(this.device.model)))) {
            this.device.manufacturer = man;
        }
        if (this.os.name == null && (m2 = cheat_pattern.matcher(it)).find()) {
            this.device.type = DeviceType.CHEATER.name();
        }
    }

    private void handleModel() {
    }

    private String decode(String it) {
        try {
            if (it.contains("%252F")) {
                it = URLDecoder.decode(URLDecoder.decode(it, "UTF-8"), "UTF-8");
            } else if (it.contains("%2F") || it.contains("%20%28")) {
                it = URLDecoder.decode(it, "UTF-8");
            }
        }
        catch (Exception e2) {
            return null;
        }
        this.it = it;
        return it;
    }

    class Browser {
        String name;
        double verison;

        Browser() {
        }
    }

    class Device {
        String type;
        String manufacturer;
        String model;

        Device() {
        }
    }

    class OS {
        String name;
        double version;

        OS() {
        }
    }
}

