/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.db.history;

import com.codahale.metrics.Counter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ipinyou.rpc.dependency.DecimalCodec;
import com.ipinyou.rpc.dependency.Decoder;
import com.ipinyou.rpc.dependency.Encoder;
import com.ipinyou.rpc.dependency.Input;
import com.ipinyou.rpc.dependency.LongCodec;
import com.ipinyou.rpc.dependency.Output;
import java.io.Serializable;
import java.math.BigDecimal;
import me.zhenchuan.Metrics;
import me.zhenchuan.base.enums.Browser;
import me.zhenchuan.base.enums.DeviceModel;
import me.zhenchuan.base.enums.DeviceType;
import me.zhenchuan.base.enums.Manufacturer;
import me.zhenchuan.base.enums.OS;
import me.zhenchuan.db.Flattening;
import me.zhenchuan.ua.UserAgent;

public class Device
implements Encoder<Device>,
Decoder<Device>,
Serializable,
Flattening {
    static final Cache<String, UserAgent> cache = CacheBuilder.newBuilder().maximumSize(200000L).build();
    public static final String[] LABELS = new String[]{"Device Type", "Manufacturer", "Device Model", "Browser", "Os", "Os Version"};
    static Counter counter = Metrics.counter(Device.class, "ua-cache-hits");
    DeviceType device = DeviceType.NULL;
    Browser browser = Browser.NULL;
    OS os = OS.NULL;
    BigDecimal osVersion = BigDecimal.ZERO;
    Manufacturer manufacturer = Manufacturer.NULL;
    DeviceModel deviceModel = DeviceModel.NULL;
    private static final int OS_VERSION_SCALE = 1;

    @Override
    public String[] flatten() {
        return new String[]{this.device.name(), this.manufacturer.name(), this.deviceModel.name(), this.browser.name(), this.os.name(), this.osVersion.toString()};
    }

    public Device() {
    }

    public Device(String ua) {
        if (ua == null) {
            return;
        }
        UserAgent userAgent = (UserAgent)cache.getIfPresent((Object)ua);
        if (userAgent == null) {
            userAgent = new UserAgent();
            userAgent.parse(ua);
            cache.put((Object)ua, (Object)userAgent);
        } else {
            counter.inc();
        }
        this.browser = userAgent.getBrowserName();
        this.os = userAgent.getOsName();
        this.manufacturer = userAgent.getManufacturer();
        this.deviceModel = userAgent.getModel();
        this.device = userAgent.getDeviceType();
    }

    public DeviceType getDevice() {
        return this.device;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public OS getOs() {
        return this.os;
    }

    public Manufacturer getManufacturer() {
        return this.manufacturer;
    }

    public DeviceModel getDeviceModel() {
        return this.deviceModel;
    }

    public void setDevice(DeviceType device) {
        this.device = device;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public void setOs(OS os) {
        this.os = os;
    }

    public BigDecimal getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(BigDecimal osVersion) {
        this.osVersion = osVersion;
    }

    public void setManufacturer(Manufacturer manufacturer) {
        this.manufacturer = manufacturer;
    }

    public void setDeviceModel(DeviceModel deviceModel) {
        this.deviceModel = deviceModel;
    }

    @Override
    public Device decode(Input in) {
        this.device = DeviceType.valueOf((int)LongCodec.decode(in));
        this.browser = Browser.valueOf((int)LongCodec.decode(in));
        this.os = OS.valueOf((int)LongCodec.decode(in));
        this.osVersion = DecimalCodec.decodeBytes(in, 1);
        this.manufacturer = Manufacturer.valueOf((int)LongCodec.decode(in));
        this.deviceModel = DeviceModel.valueOf((int)LongCodec.decode(in));
        return this;
    }

    @Override
    public void encode(Output out) {
        LongCodec.encode(this.device.ordinal(), out);
        LongCodec.encode(this.browser.ordinal(), out);
        LongCodec.encode(this.os.ordinal(), out);
        DecimalCodec.encodeBytes(this.osVersion, 1, out);
        LongCodec.encode(this.manufacturer.ordinal(), out);
        LongCodec.encode(this.deviceModel.ordinal(), out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Device{");
        sb.append("device=").append((Object)this.device);
        sb.append(", browser=").append((Object)this.browser);
        sb.append(", os=").append((Object)this.os);
        sb.append(", manufacturer=").append((Object)this.manufacturer);
        sb.append(", deviceModel=").append((Object)this.deviceModel);
        sb.append('}');
        return sb.toString();
    }
}

