/*
 * Decompiled with CFR 0.152.
 */
package com.ipinyou.rpc.dependency;

import com.ipinyou.rpc.dependency.In;
import com.ipinyou.rpc.dependency.Input;
import com.ipinyou.rpc.dependency.Out;
import com.ipinyou.rpc.dependency.Output;

public class LongCodec {
    public static void encodeU(long data, Out out) {
        long v2 = data;
        long r2 = v2 >>> 7;
        int i2 = 0;
        while (r2 != 0L && i2++ < 8) {
            out.write((byte)(v2 | 0x80L));
            v2 = r2;
            r2 = v2 >>> 7;
        }
        out.write((byte)v2);
    }

    public static long decodeU(In in) {
        byte c2 = in.read();
        long ret = 0L;
        int i2 = 0;
        while (c2 < 0 && i2 < 8) {
            ret |= ((long)c2 & 0x7FL) << 7 * i2++;
            c2 = in.read();
        }
        return ret | (0xFFL & (long)c2) << 7 * i2;
    }

    public static byte[] encodeU(long data) {
        Output out = new Output(9);
        LongCodec.encodeU(data, out);
        return out.toByteArray();
    }

    public static long decodeU(byte[] bytes) {
        return LongCodec.decodeU(new Input(bytes));
    }

    public static void encode(long data, Out out) {
        LongCodec.encodeU(LongCodec.zig(data), out);
    }

    public static long decode(In in) {
        return LongCodec.zag(LongCodec.decodeU(in));
    }

    public static byte[] encode(long data) {
        return LongCodec.encodeU(LongCodec.zig(data));
    }

    public static long decode(byte[] bytes) {
        return LongCodec.zag(LongCodec.decodeU(bytes));
    }

    public static long zig(long data) {
        return data << 1 ^ data >> 63;
    }

    public static long zag(long data) {
        return data >>> 1 ^ -(data & 1L);
    }
}

