/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.utils.s2;

import com.baidu.common.geometry.S2CellId;
import com.baidu.common.geometry.S2CellUnion;
import com.baidu.common.geometry.S2LatLng;
import com.baidu.common.geometry.S2Loop;
import com.baidu.common.geometry.S2Point;
import com.baidu.common.geometry.S2Polygon;
import com.baidu.common.geometry.S2PolygonBuilder;
import com.baidu.common.geometry.S2RegionCoverer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class S2Helper {
    public static S2Polygon parseWktPolygon(String polygon) {
        String coord = "[-]?[0-9]+[.]?[-]?[0-9]+";
        String spaces = "(\\s)+";
        String ospaces = "(\\s)*";
        String point = ospaces + coord + spaces + coord + ospaces;
        String pattern = "POLYGON[(][(]" + point + "(," + point + "){2,}?[)][)]";
        System.out.println(pattern);
        polygon = polygon.toUpperCase();
        Boolean match = Pattern.matches(pattern, polygon);
        System.out.println(match);
        if (match.booleanValue()) {
            String[] items;
            ArrayList<S2Point> points = new ArrayList<S2Point>();
            for (String item : items = Pattern.compile(ospaces + "," + ospaces).split(polygon.replace("POLYGON((", "").replace("))", ""))) {
                String[] nums = item.trim().split(spaces);
                points.add(S2LatLng.fromDegrees(Double.parseDouble(nums[1]), Double.parseDouble(nums[0])).toPoint());
            }
            S2Loop loop = new S2Loop(points);
            S2PolygonBuilder polyBuilder = new S2PolygonBuilder();
            polyBuilder.addLoop(loop);
            return polyBuilder.assemblePolygon();
        }
        return new S2Polygon();
    }

    public static S2CellUnion cover(S2Polygon polygon, int minLevel, int maxLevel) {
        if (polygon == null || polygon.numLoops() == 0) {
            return null;
        }
        S2RegionCoverer coverer = new S2RegionCoverer();
        coverer.setMinLevel(minLevel);
        coverer.setMaxLevel(maxLevel);
        return coverer.getCovering(polygon);
    }

    public static S2CellUnion cover(S2Polygon polygon, int level) {
        return S2Helper.cover(polygon, level, level);
    }

    public static List<S2CellId> getChilds(S2CellId cellid) {
        ArrayList<S2CellId> childs = new ArrayList<S2CellId>();
        S2CellId c2 = cellid.childBegin();
        while (!c2.equals(cellid.childEnd())) {
            childs.add(c2);
            c2 = c2.next();
        }
        return childs;
    }
}

