/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.utils.s2;

import com.baidu.common.geometry.S1Angle;
import com.baidu.common.geometry.S2Cap;
import com.baidu.common.geometry.S2CellId;
import com.baidu.common.geometry.S2CellUnion;
import com.baidu.common.geometry.S2LatLng;
import com.baidu.common.geometry.S2Polygon;
import com.baidu.common.geometry.S2RegionCoverer;
import java.util.ArrayList;
import java.util.List;
import me.zhenchuan.utils.s2.S2Helper;

public class S2GeometryFunctions {
    public static String s2_cell(double lat, double lon, long level) {
        return S2CellId.fromLatLng(S2LatLng.fromDegrees(lat, lon)).parent(Math.toIntExact(level)).toToken();
    }

    public static Long s2_cell_id(double lat, double lon, long level) {
        return S2CellId.fromLatLng(S2LatLng.fromDegrees(lat, lon)).parent(Math.toIntExact(level)).id();
    }

    public static String s2_cell(double lat, double lon) {
        return S2GeometryFunctions.s2_cell(lat, lon, 30L);
    }

    public static String s2_parent(String cellToken) {
        return S2CellId.fromToken(cellToken).parent().toToken();
    }

    public static int s2_level(String cellToken) {
        return S2CellId.fromToken(cellToken).level();
    }

    public static double s2_distance(String cellToken, double lat, double lon) {
        return S2CellId.fromToken(cellToken).toLatLng().getEarthDistance(S2LatLng.fromDegrees(lat, lon));
    }

    public static double[] s2_centroid(String cellToken) {
        S2LatLng latlng = S2CellId.fromToken(cellToken).toLatLng();
        return new double[]{latlng.latDegrees(), latlng.lngDegrees()};
    }

    public static List<S2CellId> s2_neighbours(String cellToken, int level) {
        ArrayList<S2CellId> output = new ArrayList<S2CellId>();
        S2CellId cellId = S2CellId.fromToken(cellToken);
        cellId.getAllNeighbors(Math.toIntExact(level), output);
        return output;
    }

    public static List<S2CellId> s2_children(String cellToken) {
        S2CellId cellId = S2CellId.fromToken(cellToken);
        return S2Helper.getChilds(cellId);
    }

    public static List<S2CellId> s2_radius_cover(String cellToken, double radius, int level) {
        S2CellId cellId = S2CellId.fromToken(cellToken);
        S2Cap circle = S2Cap.fromAxisAngle(cellId.toLatLng().toPoint(), S1Angle.degrees(360.0 * radius / 1000.0 / 40030.23642389422));
        ArrayList<S2CellId> output = new ArrayList<S2CellId>();
        S2RegionCoverer.getSimpleCovering(circle, cellId.toLatLng().toPoint(), Math.toIntExact(level), output);
        return output;
    }

    public static S2Polygon s2_parse_wkt(String wktPolygon) {
        return S2Helper.parseWktPolygon(wktPolygon);
    }

    public static List<S2CellId> s2_polygon_cover(String wktPolygo, int min_level, int max_level) {
        S2CellUnion cover = S2Helper.cover(S2GeometryFunctions.s2_parse_wkt(wktPolygo), Math.toIntExact(min_level), Math.toIntExact(max_level));
        return cover.cellIds();
    }

    public static List<S2CellId> s2_polygon_cover(String wktPolygo, int level) {
        return S2GeometryFunctions.s2_polygon_cover(wktPolygo, level, level);
    }

    public static boolean s2_within(String cellToken, String wktPolygon, int level) {
        S2CellUnion cover = S2Helper.cover(S2GeometryFunctions.s2_parse_wkt(wktPolygon), Math.toIntExact(level));
        if (cover == null) {
            return false;
        }
        S2CellId cellId = S2CellId.fromToken(cellToken);
        return cover.contains(cellId);
    }

    public static boolean s2_within(String cellToken, List<String> cellTokens) {
        ArrayList<S2CellId> cellIds = new ArrayList<S2CellId>();
        for (String cellToken1 : cellTokens) {
            cellIds.add(S2CellId.fromToken(cellToken1));
        }
        S2CellUnion cellUnion = new S2CellUnion();
        cellUnion.initFromCellIds(cellIds);
        return cellUnion.contains(S2CellId.fromToken(cellToken));
    }

    public static boolean s2_within(String cellTokenA, String cellTokenB) {
        return S2CellId.fromToken(cellTokenB).contains(S2CellId.fromToken(cellTokenA));
    }
}

