/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.utils;

import com.google.common.base.Strings;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import net.ipip.datx.City;
import net.ipip.datx.IPv4FormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static AtomicReference<String> address_cache = new AtomicReference();
    private static AtomicReference<City> city_cache = new AtomicReference();

    public static String[] parse(String ip) {
        try {
            return IpUtils.getCity().find(ip);
        }
        catch (IPv4FormatException e2) {
            return new String[]{"", "", "", ""};
        }
    }

    public static String[] parse(long ip) {
        return IpUtils.getCity().find(ip);
    }

    public static void main(String[] args) {
        System.out.println(Arrays.asList(IpUtils.parse("219.154.46.100")));
    }

    private static City getCity() {
        if (city_cache.get() != null) {
            return city_cache.get();
        }
        try {
            City city = new City("/17monipdb.datx");
            city_cache.compareAndSet(null, city);
            return city;
        }
        catch (Exception e2) {
            throw new RuntimeException("failed to parse 17monipdb.datx ");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String localAddress() {
        if (address_cache.get() != null) {
            return address_cache.get();
        }
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            String result = socket.getLocalAddress().getHostAddress();
            if (result != null) {
                address_cache.set(result);
            }
            String string = result;
            return string;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static long toLong(String strIp) {
        try {
            if (Strings.isNullOrEmpty((String)strIp)) {
                return 0L;
            }
            String[] items = strIp.trim().split("\\.");
            if (items.length != 4) {
                return 0L;
            }
            long[] ip = new long[]{Long.parseLong(items[0]), Long.parseLong(items[1]), Long.parseLong(items[2]), 0L};
            if (!"*".equals(items[3])) {
                ip[3] = Long.parseLong(items[3]);
            }
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        catch (Exception e2) {
            log.warn("invalid ip address : {}", (Object)strIp, (Object)e2);
            return 0L;
        }
    }

    public static String toIP(long longIp) {
        if (longIp == 0L) {
            return "";
        }
        return String.valueOf(longIp >>> 24) + "." + String.valueOf((longIp & 0xFFFFFFL) >>> 16) + "." + String.valueOf((longIp & 0xFFFFL) >>> 8) + "." + String.valueOf(longIp & 0xFFL);
    }
}

