/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.db.history;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.ipinyou.rpc.dependency.Decoder;
import com.ipinyou.rpc.dependency.Encoder;
import com.ipinyou.rpc.dependency.Input;
import com.ipinyou.rpc.dependency.LongCodec;
import com.ipinyou.rpc.dependency.Output;
import com.ipinyou.rpc.dependency.StringCodec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.zhenchuan.base.enums.MediaType;
import me.zhenchuan.base.enums.Network;
import me.zhenchuan.base.enums.Platform;
import me.zhenchuan.db.Flattening;
import me.zhenchuan.dict.AppData;

public class Media
implements Encoder<Media>,
Decoder<Media>,
Serializable,
Flattening {
    Network network = Network.NULL;
    MediaType mediaType = MediaType.NULL;
    String target = "";
    int targetId = 0;
    Platform platform = Platform.na;
    List<Long> tags = new ArrayList<Long>();
    private AppData AppData = me.zhenchuan.dict.AppData.getInstance();
    static final Set<String> platformAsApp = Sets.newHashSet((Object[])new String[]{"tencent_brand", "toutiao"});
    public static final String[] LABELS = new String[]{"Network", "Platform", "Media Type", "Media Name", "Tags"};

    public Media() {
    }

    public Media(String network, MediaType source, String target) {
        this.network = Network.from(network);
        this.mediaType = source;
        if (target != null) {
            this.target = target.trim();
        }
        this.targetId = this.AppData.index(this.target);
    }

    public Media(String network, MediaType source, String target, String platform) {
        this.network = Network.from(network);
        this.mediaType = source;
        if (target != null) {
            this.target = target.trim();
        }
        if (platformAsApp.contains(platform)) {
            this.target = platform;
        }
        this.targetId = this.AppData.index(this.target);
        this.setPlatform(platform);
    }

    public void setNetwork(Network network) {
        this.network = network;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public List<Long> getTags() {
        return this.tags;
    }

    public void setTags(List<Long> tags) {
        this.tags = tags;
    }

    public void setPlatform(String platform) {
        this.platform = Platform.from(platform);
    }

    public Network getNetwork() {
        return this.network;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getTarget() {
        return this.target;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void encodeRaw(Output out) {
        LongCodec.encode(this.network.ordinal(), out);
        LongCodec.encode(this.mediaType.ordinal(), out);
        LongCodec.encode(this.platform.ordinal(), out);
        StringCodec.encode(this.target, out);
    }

    public Media decodeRaw(Input in) {
        this.network = Network.valueOf((int)LongCodec.decode(in));
        this.mediaType = MediaType.valueOf((int)LongCodec.decode(in));
        this.platform = Platform.valueOf((int)LongCodec.decode(in));
        this.target = StringCodec.decode(in);
        this.targetId = this.AppData.index(this.target);
        return this;
    }

    @Override
    public Media decode(Input in) {
        this.network = Network.valueOf((int)LongCodec.decode(in));
        this.mediaType = MediaType.valueOf((int)LongCodec.decode(in));
        this.platform = Platform.valueOf((int)LongCodec.decode(in));
        int appId = (int)LongCodec.decode(in);
        this.target = this.AppData.name(appId);
        this.targetId = appId;
        long size = LongCodec.decode(in);
        this.tags = new ArrayList<Long>();
        if (size > 0L) {
            int i2 = 0;
            while ((long)i2 < size) {
                this.tags.add(LongCodec.decode(in));
                ++i2;
            }
        }
        return this;
    }

    @Override
    public String[] flatten() {
        return new String[]{this.network.name(), this.platform.name(), this.mediaType.name(), this.target, Joiner.on((String)",").join(this.tags)};
    }

    @Override
    public void encode(Output out) {
        LongCodec.encode(this.network.ordinal(), out);
        LongCodec.encode(this.mediaType.ordinal(), out);
        LongCodec.encode(this.platform.ordinal(), out);
        LongCodec.encode(this.AppData.index(this.target), out);
        LongCodec.encode(this.tags.size(), out);
        this.tags.forEach(tag -> LongCodec.encode(tag, out));
    }

    public boolean equals(Object o2) {
        Media media = (Media)o2;
        return this.target.equals(media.target);
    }

    public int hashCode() {
        int result = this.target.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Context{");
        sb.append("platform=").append((Object)this.platform);
        sb.append(", network=").append((Object)this.network);
        sb.append(", sourceType=").append((Object)this.mediaType);
        sb.append(", tags=").append(this.tags);
        sb.append(", target='").append(this.target).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

