/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.db.history;

import com.ipinyou.rpc.dependency.DecimalCodec;
import com.ipinyou.rpc.dependency.Decoder;
import com.ipinyou.rpc.dependency.Encoder;
import com.ipinyou.rpc.dependency.Input;
import com.ipinyou.rpc.dependency.LongCodec;
import com.ipinyou.rpc.dependency.Output;
import java.io.Serializable;
import java.math.BigDecimal;
import me.zhenchuan.db.Flattening;
import me.zhenchuan.utils.IpUtils;
import me.zhenchuan.utils.LatLngUtils;

public class Location
implements Encoder<Location>,
Decoder<Location>,
Serializable,
Flattening {
    public static final String[] LABELS = new String[]{"Ip", "Lat", "Lng", "Country", "City", "Province"};
    String ip;
    transient long longIp;
    BigDecimal lat = BigDecimal.ZERO;
    BigDecimal lng = BigDecimal.ZERO;
    int cityId;
    int provinceId;
    private static final int scala = 6;

    public Location() {
    }

    @Override
    public String[] flatten() {
        String[] regions = IpUtils.parse(this.ip);
        return new String[]{this.ip, this.lat.toString(), this.lng.toString(), regions[0], regions[1], regions[2]};
    }

    public void setCityId(int cityId) {
        this.cityId = cityId;
    }

    public void setProvinceId(int provinceId) {
        this.provinceId = provinceId;
    }

    public Location(String ip, Double lat, Double lng) {
        this.ip = ip;
        this.setLatLng(lat, lng);
    }

    private void setLatLng(Double lat, Double lng) {
        if (lat == null || lng == null || !LatLngUtils.isValid(lng, lat)) {
            this.lat = BigDecimal.ZERO;
            this.lng = BigDecimal.ZERO;
        } else {
            this.lat = BigDecimal.valueOf(lat);
            this.lng = BigDecimal.valueOf(lng);
        }
    }

    public Location(String ip, String lat, String lng) {
        this.ip = ip;
        if (lat == null || "-1".equals(lat) || "null".equalsIgnoreCase(lat)) {
            this.lat = BigDecimal.ZERO;
            this.lng = BigDecimal.ZERO;
        } else {
            double alat = Double.parseDouble(lat);
            double alng = Double.parseDouble(lng);
            this.setLatLng(alat, alng);
        }
    }

    public String getIp() {
        return this.ip;
    }

    public BigDecimal getLat() {
        return this.lat;
    }

    public BigDecimal getLng() {
        return this.lng;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setLat(BigDecimal lat) {
        this.lat = lat;
    }

    public void setLng(BigDecimal lng) {
        this.lng = lng;
    }

    public int getCityId() {
        return this.cityId;
    }

    public int getProvinceId() {
        return this.provinceId;
    }

    public long getLongIp() {
        return this.longIp;
    }

    @Override
    public Location decode(Input in) {
        this.longIp = LongCodec.decode(in);
        this.ip = IpUtils.toIP(this.longIp);
        this.lat = DecimalCodec.decodeBytes(in, 6);
        this.lng = DecimalCodec.decodeBytes(in, 6);
        return this;
    }

    @Override
    public void encode(Output out) {
        LongCodec.encode(IpUtils.toLong(this.ip), out);
        DecimalCodec.encodeBytes(this.lat, 6, out);
        DecimalCodec.encodeBytes(this.lng, 6, out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Position{");
        sb.append("ip=").append(this.ip);
        sb.append(", lat=").append(this.lat);
        sb.append(", lng=").append(this.lng);
        sb.append('}');
        return sb.toString();
    }
}

