/*
 * Decompiled with CFR 0.152.
 */
package com.ipinyou.rpc.dependency;

import com.ipinyou.rpc.dependency.BufferPool;
import com.ipinyou.rpc.dependency.O;
import com.ipinyou.rpc.dependency.Out;
import java.util.Arrays;

public class Output
implements Out {
    private static final BufferPool pool = BufferPool.instance;
    private byte[] buf;
    private int length;

    public Output() {
        this(16);
    }

    public Output(int capacity) {
        this.buf = pool.getBuffer(capacity);
    }

    public int length() {
        return this.length;
    }

    public void length(int i2) {
        O.required(i2 >= 0, "i >= 0");
        if (i2 > this.buf.length) {
            O.required("i <= " + this.buf.length);
        }
        this.length = i2;
    }

    public byte[] buf() {
        return this.buf;
    }

    @Override
    public void write(byte value) {
        this.grow(this.length + 1);
        this.buf[this.length] = value;
        ++this.length;
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.grow(this.length + len);
        System.arraycopy(bytes, off, this.buf, this.length, len);
        this.length += len;
    }

    @Override
    public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.buf, 0, this.length);
    }

    private void grow(int capacity) {
        if (capacity > this.buf.length) {
            byte[] nb = pool.getBuffer(capacity);
            System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
            pool.returnBuffer(this.buf);
            this.buf = nb;
        }
    }

    public void returnBuf() {
        if (this.buf != null) {
            pool.returnBuffer(this.buf);
        }
        this.buf = null;
        this.length = 0;
    }
}

