/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

import com.baidu.common.geometry.R2Vector;
import com.baidu.common.geometry.S2;
import com.baidu.common.geometry.S2Point;

public strictfp final class S2Projections {
    private static final Projections S2_PROJECTION = Projections.S2_QUADRATIC_PROJECTION;
    public static final S2.Metric MIN_AREA = new S2.Metric(2, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? 1.0 / (3.0 * Math.sqrt(3.0)) : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? Math.PI * Math.PI / (16.0 * S2.M_SQRT2) : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 2.0 * S2.M_SQRT2 / 9.0 : 0.0)));
    public static final S2.Metric MAX_AREA = new S2.Metric(2, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? 1.0 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? 0.6168502750680849 : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 0.6589498142407904 : 0.0)));
    public static final S2.Metric AVG_AREA = new S2.Metric(2, 0.5235987755982988);
    public static final S2.Metric MIN_ANGLE_SPAN = new S2.Metric(1, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? 0.5 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? 0.7853981633974483 : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 0.6666666666666666 : 0.0)));
    public static final S2.Metric MAX_ANGLE_SPAN = new S2.Metric(1, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? 1.0 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? 0.7853981633974483 : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 0.8524485895996092 : 0.0)));
    public static final S2.Metric AVG_ANGLE_SPAN = new S2.Metric(1, 0.7853981633974483);
    public static final S2.Metric MIN_WIDTH = new S2.Metric(1, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? 1.0 / Math.sqrt(6.0) : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? Math.PI / (4.0 * S2.M_SQRT2) : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? S2.M_SQRT2 / 3.0 : 0.0)));
    public static final S2.Metric MAX_WIDTH = new S2.Metric(1, MAX_ANGLE_SPAN.deriv());
    public static final S2.Metric AVG_WIDTH = new S2.Metric(1, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? 0.7057296729222284 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? 0.7186593194625804 : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 0.7172618364430496 : 0.0)));
    public static final S2.Metric MIN_EDGE = new S2.Metric(1, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? S2.M_SQRT2 / 3.0 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? Math.PI / (4.0 * S2.M_SQRT2) : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? S2.M_SQRT2 / 3.0 : 0.0)));
    public static final S2.Metric MAX_EDGE = new S2.Metric(1, MAX_ANGLE_SPAN.deriv());
    public static final S2.Metric AVG_EDGE = new S2.Metric(1, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? 0.7200170964778018 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? 0.7308335162733697 : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 0.7296068731930531 : 0.0)));
    public static final S2.Metric MIN_DIAG = new S2.Metric(1, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? S2.M_SQRT2 / 3.0 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? Math.PI / (3.0 * S2.M_SQRT2) : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 4.0 * S2.M_SQRT2 / 9.0 : 0.0)));
    public static final S2.Metric MAX_DIAG = new S2.Metric(1, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? S2.M_SQRT2 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? Math.PI / Math.sqrt(6.0) : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 1.2193272972170106 : 0.0)));
    public static final S2.Metric AVG_DIAG = new S2.Metric(1, S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? 1.0159089332094062 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? 1.0318115985978178 : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 1.0302113694992359 : 0.0)));
    public static final double MAX_EDGE_ASPECT = S2_PROJECTION == Projections.S2_LINEAR_PROJECTION ? S2.M_SQRT2 : (S2_PROJECTION == Projections.S2_TAN_PROJECTION ? S2.M_SQRT2 : (S2_PROJECTION == Projections.S2_QUADRATIC_PROJECTION ? 1.442615274452683 : 0.0));
    public static final double MAX_DIAG_ASPECT = Math.sqrt(3.0);

    public static double stToUV(double s2) {
        switch (S2_PROJECTION) {
            case S2_LINEAR_PROJECTION: {
                return s2;
            }
            case S2_TAN_PROJECTION: {
                s2 = Math.tan(0.7853981633974483 * s2);
                return s2 + (double)1.110223E-16f * s2;
            }
            case S2_QUADRATIC_PROJECTION: {
                if (s2 >= 0.0) {
                    return 0.3333333333333333 * ((1.0 + s2) * (1.0 + s2) - 1.0);
                }
                return 0.3333333333333333 * (1.0 - (1.0 - s2) * (1.0 - s2));
            }
        }
        throw new IllegalStateException("Invalid value for S2_PROJECTION");
    }

    public static double uvToST(double u2) {
        switch (S2_PROJECTION) {
            case S2_LINEAR_PROJECTION: {
                return u2;
            }
            case S2_TAN_PROJECTION: {
                return 1.2732395447351628 * Math.atan(u2);
            }
            case S2_QUADRATIC_PROJECTION: {
                if (u2 >= 0.0) {
                    return Math.sqrt(1.0 + 3.0 * u2) - 1.0;
                }
                return 1.0 - Math.sqrt(1.0 - 3.0 * u2);
            }
        }
        throw new IllegalStateException("Invalid value for S2_PROJECTION");
    }

    public static S2Point faceUvToXyz(int face, double u2, double v) {
        switch (face) {
            case 0: {
                return new S2Point(1.0, u2, v);
            }
            case 1: {
                return new S2Point(-u2, 1.0, v);
            }
            case 2: {
                return new S2Point(-u2, -v, 1.0);
            }
            case 3: {
                return new S2Point(-1.0, -v, -u2);
            }
            case 4: {
                return new S2Point(v, -1.0, -u2);
            }
        }
        return new S2Point(v, u2, -1.0);
    }

    public static R2Vector validFaceXyzToUv(int face, S2Point p2) {
        double pv;
        double pu;
        switch (face) {
            case 0: {
                pu = p2.y / p2.x;
                pv = p2.z / p2.x;
                break;
            }
            case 1: {
                pu = -p2.x / p2.y;
                pv = p2.z / p2.y;
                break;
            }
            case 2: {
                pu = -p2.x / p2.z;
                pv = -p2.y / p2.z;
                break;
            }
            case 3: {
                pu = p2.z / p2.x;
                pv = p2.y / p2.x;
                break;
            }
            case 4: {
                pu = p2.z / p2.y;
                pv = -p2.x / p2.y;
                break;
            }
            default: {
                pu = -p2.y / p2.z;
                pv = -p2.x / p2.z;
            }
        }
        return new R2Vector(pu, pv);
    }

    public static int xyzToFace(S2Point p2) {
        int face = p2.largestAbsComponent();
        if (p2.get(face) < 0.0) {
            face += 3;
        }
        return face;
    }

    public static R2Vector faceXyzToUv(int face, S2Point p2) {
        if (face < 3 ? p2.get(face) <= 0.0 : p2.get(face - 3) >= 0.0) {
            return null;
        }
        return S2Projections.validFaceXyzToUv(face, p2);
    }

    public static S2Point getUNorm(int face, double u2) {
        switch (face) {
            case 0: {
                return new S2Point(u2, -1.0, 0.0);
            }
            case 1: {
                return new S2Point(1.0, u2, 0.0);
            }
            case 2: {
                return new S2Point(1.0, 0.0, u2);
            }
            case 3: {
                return new S2Point(-u2, 0.0, 1.0);
            }
            case 4: {
                return new S2Point(0.0, -u2, 1.0);
            }
        }
        return new S2Point(0.0, -1.0, -u2);
    }

    public static S2Point getVNorm(int face, double v) {
        switch (face) {
            case 0: {
                return new S2Point(-v, 0.0, 1.0);
            }
            case 1: {
                return new S2Point(0.0, -v, 1.0);
            }
            case 2: {
                return new S2Point(0.0, -1.0, -v);
            }
            case 3: {
                return new S2Point(v, -1.0, 0.0);
            }
            case 4: {
                return new S2Point(1.0, v, 0.0);
            }
        }
        return new S2Point(1.0, 0.0, v);
    }

    public static S2Point getNorm(int face) {
        return S2Projections.faceUvToXyz(face, 0.0, 0.0);
    }

    public static S2Point getUAxis(int face) {
        switch (face) {
            case 0: {
                return new S2Point(0.0, 1.0, 0.0);
            }
            case 1: {
                return new S2Point(-1.0, 0.0, 0.0);
            }
            case 2: {
                return new S2Point(-1.0, 0.0, 0.0);
            }
            case 3: {
                return new S2Point(0.0, 0.0, -1.0);
            }
            case 4: {
                return new S2Point(0.0, 0.0, -1.0);
            }
        }
        return new S2Point(0.0, 1.0, 0.0);
    }

    public static S2Point getVAxis(int face) {
        switch (face) {
            case 0: {
                return new S2Point(0.0, 0.0, 1.0);
            }
            case 1: {
                return new S2Point(0.0, 0.0, 1.0);
            }
            case 2: {
                return new S2Point(0.0, -1.0, 0.0);
            }
            case 3: {
                return new S2Point(0.0, -1.0, 0.0);
            }
            case 4: {
                return new S2Point(1.0, 0.0, 0.0);
            }
        }
        return new S2Point(1.0, 0.0, 0.0);
    }

    private S2Projections() {
    }

    public strictfp static enum Projections {
        S2_LINEAR_PROJECTION,
        S2_TAN_PROJECTION,
        S2_QUADRATIC_PROJECTION;

    }
}

