/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

import com.baidu.common.geometry.S1Angle;
import com.baidu.common.geometry.S2AreaCentroid;
import com.baidu.common.geometry.S2Cap;
import com.baidu.common.geometry.S2Cell;
import com.baidu.common.geometry.S2Edge;
import com.baidu.common.geometry.S2EdgeIndex;
import com.baidu.common.geometry.S2EdgeUtil;
import com.baidu.common.geometry.S2LatLngRect;
import com.baidu.common.geometry.S2Loop;
import com.baidu.common.geometry.S2Point;
import com.baidu.common.geometry.S2PolygonBuilder;
import com.baidu.common.geometry.S2Region;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public strictfp final class S2Polygon
implements S2Region,
Comparable<S2Polygon> {
    private static final Logger log = Logger.getLogger(S2Polygon.class.getCanonicalName());
    private List<S2Loop> loops = Lists.newArrayList();
    private S2LatLngRect bound;
    private boolean hasHoles;
    private int numVertices;

    public S2Polygon() {
        this.bound = S2LatLngRect.empty();
        this.hasHoles = false;
        this.numVertices = 0;
    }

    public S2Polygon(List<S2Loop> loops) {
        this.bound = S2LatLngRect.empty();
        this.init(loops);
    }

    public S2Polygon(S2Loop loop) {
        this.bound = loop.getRectBound();
        this.hasHoles = false;
        this.numVertices = loop.numVertices();
        this.loops.add(loop);
    }

    public S2Polygon(S2Polygon src) {
        this.bound = src.getRectBound();
        this.hasHoles = src.hasHoles;
        this.numVertices = src.numVertices;
        for (int i2 = 0; i2 < src.numLoops(); ++i2) {
            this.loops.add(new S2Loop(src.loop(i2)));
        }
    }

    @Override
    public int compareTo(S2Polygon other) {
        if (this.numLoops() != other.numLoops()) {
            return this.numLoops() - other.numLoops();
        }
        for (int i2 = 0; i2 < this.numLoops(); ++i2) {
            int compare = this.loops.get(i2).compareTo(other.loops.get(i2));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public void init(List<S2Loop> loops) {
        HashMap loopMap = Maps.newHashMap();
        loopMap.put(null, Lists.newArrayList());
        for (S2Loop loop : loops) {
            S2Polygon.insertLoop(loop, null, loopMap);
            this.numVertices += loop.numVertices();
        }
        loops.clear();
        S2Polygon.sortValueLoops(loopMap);
        this.initLoop(null, -1, loopMap);
        this.hasHoles = false;
        this.bound = S2LatLngRect.empty();
        for (int i2 = 0; i2 < this.numLoops(); ++i2) {
            if (this.loop(i2).sign() < 0) {
                this.hasHoles = true;
                continue;
            }
            this.bound = this.bound.union(this.loop(i2).getRectBound());
        }
    }

    public void release(List<S2Loop> loops) {
        loops.addAll(this.loops);
        this.loops.clear();
        this.bound = S2LatLngRect.empty();
        this.hasHoles = false;
        this.numVertices = 0;
    }

    public static boolean isValid(List<S2Loop> loops) {
        if (loops.size() > 1) {
            HashMap edges = Maps.newHashMap();
            for (int i2 = 0; i2 < loops.size(); ++i2) {
                S2Loop lp = loops.get(i2);
                for (int j2 = 0; j2 < lp.numVertices(); ++j2) {
                    UndirectedEdge key = new UndirectedEdge(lp.vertex(j2), lp.vertex(j2 + 1));
                    LoopVertexIndexPair value = new LoopVertexIndexPair(i2, j2);
                    if (edges.containsKey(key)) {
                        LoopVertexIndexPair other = (LoopVertexIndexPair)edges.get(key);
                        log.info("Duplicate edge: loop " + i2 + ", edge " + j2 + " and loop " + other.getLoopIndex() + ", edge " + other.getVertexIndex());
                        return false;
                    }
                    edges.put(key, value);
                }
            }
        }
        for (int i3 = 0; i3 < loops.size(); ++i3) {
            if (!loops.get(i3).isNormalized()) {
                log.info("Loop " + i3 + " encloses more than half the sphere");
                return false;
            }
            for (int j3 = i3 + 1; j3 < loops.size(); ++j3) {
                if (loops.get(i3).containsOrCrosses(loops.get(j3)) >= 0) continue;
                log.info("Loop " + i3 + " crosses loop " + j3);
                return false;
            }
        }
        return true;
    }

    public int numLoops() {
        return this.loops.size();
    }

    public S2Loop loop(int k2) {
        return this.loops.get(k2);
    }

    public int getParent(int k2) {
        int depth = this.loop(k2).depth();
        if (depth == 0) {
            return -1;
        }
        while (--k2 >= 0 && this.loop(k2).depth() >= depth) {
        }
        return k2;
    }

    public int getLastDescendant(int k2) {
        if (k2 < 0) {
            return this.numLoops() - 1;
        }
        int depth = this.loop(k2).depth();
        while (++k2 < this.numLoops() && this.loop(k2).depth() > depth) {
        }
        return k2 - 1;
    }

    private S2AreaCentroid getAreaCentroid(boolean doCentroid) {
        double areaSum = 0.0;
        S2Point centroidSum = new S2Point(0.0, 0.0, 0.0);
        for (int i2 = 0; i2 < this.numLoops(); ++i2) {
            S2AreaCentroid areaCentroid = doCentroid ? this.loop(i2).getAreaAndCentroid() : null;
            double loopArea = doCentroid ? areaCentroid.getArea() : this.loop(i2).getArea();
            int loopSign = this.loop(i2).sign();
            areaSum += (double)loopSign * loopArea;
            if (!doCentroid) continue;
            S2Point currentCentroid = areaCentroid.getCentroid();
            centroidSum = new S2Point(centroidSum.x + (double)loopSign * currentCentroid.x, centroidSum.y + (double)loopSign * currentCentroid.y, centroidSum.z + (double)loopSign * currentCentroid.z);
        }
        return new S2AreaCentroid(areaSum, doCentroid ? centroidSum : null);
    }

    public S2AreaCentroid getAreaAndCentroid() {
        return this.getAreaCentroid(true);
    }

    public double getArea() {
        return this.getAreaCentroid(false).getArea();
    }

    public S2Point getCentroid() {
        return this.getAreaCentroid(true).getCentroid();
    }

    public S1Angle getDistance(S2Point p2) {
        if (this.contains(p2)) {
            return S1Angle.radians(0.0);
        }
        S1Angle minDistance = S1Angle.radians(Math.PI);
        for (int i2 = 0; i2 < this.numLoops(); ++i2) {
            minDistance = S1Angle.min(minDistance, this.loop(i2).getDistance(p2));
        }
        return minDistance;
    }

    public boolean contains(S2Polygon b2) {
        if (this.numLoops() == 1 && b2.numLoops() == 1) {
            return this.loop(0).contains(b2.loop(0));
        }
        if (!this.bound.contains(b2.getRectBound()) && !this.bound.lng().union(b2.getRectBound().lng()).isFull()) {
            return false;
        }
        if (!this.hasHoles && !b2.hasHoles) {
            for (int j2 = 0; j2 < b2.numLoops(); ++j2) {
                if (this.anyLoopContains(b2.loop(j2))) continue;
                return false;
            }
            return true;
        }
        return this.containsAllShells(b2) && b2.excludesAllHoles(this);
    }

    public boolean intersects(S2Polygon b2) {
        if (this.numLoops() == 1 && b2.numLoops() == 1) {
            return this.loop(0).intersects(b2.loop(0));
        }
        if (!this.bound.intersects(b2.getRectBound())) {
            return false;
        }
        if (!this.hasHoles && !b2.hasHoles) {
            for (int i2 = 0; i2 < this.numLoops(); ++i2) {
                for (int j2 = 0; j2 < b2.numLoops(); ++j2) {
                    if (!this.loop(i2).intersects(b2.loop(j2))) continue;
                    return true;
                }
            }
            return false;
        }
        return this.intersectsAnyShell(b2) || b2.intersectsAnyShell(this);
    }

    private static void addIntersection(S2Point a0, S2Point a1, S2Point b0, S2Point b1, boolean addSharedEdges, int crossing, List<ParametrizedS2Point> intersections) {
        if (crossing > 0) {
            S2Point x = S2EdgeUtil.getIntersection(a0, a1, b0, b1);
            double t2 = S2EdgeUtil.getDistanceFraction(x, a0, a1);
            intersections.add(new ParametrizedS2Point(t2, x));
        } else if (S2EdgeUtil.vertexCrossing(a0, a1, b0, b1)) {
            double t3;
            double d2 = t3 = a0 == b0 || a0 == b1 ? 0.0 : 1.0;
            if (!addSharedEdges && a1 == b1) {
                t3 = 1.0;
            }
            intersections.add(new ParametrizedS2Point(t3, t3 == 0.0 ? a0 : a1));
        }
    }

    private static void clipEdge(S2Point a0, S2Point a1, S2LoopSequenceIndex bIndex, boolean addSharedEdges, List<ParametrizedS2Point> intersections) {
        S2EdgeIndex.DataEdgeIterator it = new S2EdgeIndex.DataEdgeIterator(bIndex);
        it.getCandidates(a0, a1);
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(a0, a1, a0);
        S2Point from = null;
        S2Point to = null;
        while (it.hasNext()) {
            int crossing;
            S2Point previousTo = to;
            S2Edge fromTo = bIndex.edgeFromTo(it.index());
            from = fromTo.getStart();
            to = fromTo.getEnd();
            if (previousTo != from) {
                crosser.restartAt(from);
            }
            if ((crossing = crosser.robustCrossing(to)) >= 0) {
                S2Polygon.addIntersection(a0, a1, from, to, addSharedEdges, crossing, intersections);
            }
            it.next();
        }
    }

    private static void clipBoundary(S2Polygon a2, boolean reverseA, S2Polygon b2, boolean reverseB, boolean invertB, boolean addSharedEdges, S2PolygonBuilder builder) {
        S2PolygonIndex bIndex = new S2PolygonIndex(b2, reverseB);
        bIndex.predictAdditionalCalls(a2.getNumVertices());
        ArrayList intersections = Lists.newArrayList();
        for (S2Loop aLoop : a2.loops) {
            int j2;
            int n2 = aLoop.numVertices();
            int dir = aLoop.isHole() ^ reverseA ? -1 : 1;
            boolean inside = b2.contains(aLoop.vertex(0)) ^ invertB;
            int n3 = j2 = dir > 0 ? 0 : n2;
            while (n2 > 0) {
                S2Point a0 = aLoop.vertex(j2);
                S2Point a1 = aLoop.vertex(j2 + dir);
                intersections.clear();
                S2Polygon.clipEdge(a0, a1, bIndex, addSharedEdges, intersections);
                if (inside) {
                    intersections.add(new ParametrizedS2Point(0.0, a0));
                }
                boolean bl = inside = (intersections.size() & 1) == 1;
                if (inside) {
                    intersections.add(new ParametrizedS2Point(1.0, a1));
                }
                Collections.sort(intersections);
                int size = intersections.size();
                for (int i2 = 1; i2 < size; i2 += 2) {
                    builder.addEdge(((ParametrizedS2Point)intersections.get(i2 - 1)).getPoint(), ((ParametrizedS2Point)intersections.get(i2)).getPoint());
                }
                --n2;
                j2 += dir;
            }
        }
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public void initToIntersection(S2Polygon a2, S2Polygon b2) {
        this.initToIntersectionSloppy(a2, b2, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToIntersectionSloppy(S2Polygon a2, S2Polygon b2, S1Angle vertexMergeRadius) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        if (!a2.bound.intersects(b2.bound)) {
            return;
        }
        S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR;
        options.setMergeDistance(vertexMergeRadius);
        S2PolygonBuilder builder = new S2PolygonBuilder(options);
        S2Polygon.clipBoundary(a2, false, b2, false, false, true, builder);
        S2Polygon.clipBoundary(b2, false, a2, false, false, false, builder);
        if (!builder.assemblePolygon(this, null)) {
            log.severe("Bad directed edges");
        }
    }

    public void initToUnion(S2Polygon a2, S2Polygon b2) {
        this.initToUnionSloppy(a2, b2, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToUnionSloppy(S2Polygon a2, S2Polygon b2, S1Angle vertexMergeRadius) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR;
        options.setMergeDistance(vertexMergeRadius);
        S2PolygonBuilder builder = new S2PolygonBuilder(options);
        S2Polygon.clipBoundary(a2, false, b2, false, true, true, builder);
        S2Polygon.clipBoundary(b2, false, a2, false, true, false, builder);
        if (!builder.assemblePolygon(this, null)) {
            log.severe("Bad directed edges");
        }
    }

    public static S2Polygon destructiveUnion(List<S2Polygon> polygons) {
        return S2Polygon.destructiveUnionSloppy(polygons, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public static S2Polygon destructiveUnionSloppy(List<S2Polygon> polygons, S1Angle vertexMergeRadius) {
        TreeMultimap queue = TreeMultimap.create();
        for (S2Polygon polygon : polygons) {
            queue.put((Object)polygon.getNumVertices(), (Object)polygon);
        }
        polygons.clear();
        Set queueSet = queue.entries();
        while (queueSet.size() > 1) {
            queueSet = queue.entries();
            Iterator smallestIter = queueSet.iterator();
            Map.Entry smallest = (Map.Entry)smallestIter.next();
            int aSize = (Integer)smallest.getKey();
            S2Polygon aPolygon = (S2Polygon)smallest.getValue();
            smallestIter.remove();
            smallest = (Map.Entry)smallestIter.next();
            int bSize = (Integer)smallest.getKey();
            S2Polygon bPolygon = (S2Polygon)smallest.getValue();
            smallestIter.remove();
            S2Polygon unionPolygon = new S2Polygon();
            unionPolygon.initToUnionSloppy(aPolygon, bPolygon, vertexMergeRadius);
            int unionSize = aSize + bSize;
            queue.put((Object)unionSize, (Object)unionPolygon);
        }
        if (queue.isEmpty()) {
            return new S2Polygon();
        }
        return (S2Polygon)queue.get(queue.asMap().firstKey()).first();
    }

    public boolean isNormalized() {
        HashMultiset vertices = HashMultiset.create();
        S2Loop lastParent = null;
        for (int i2 = 0; i2 < this.numLoops(); ++i2) {
            S2Loop child = this.loop(i2);
            if (child.depth() == 0) continue;
            S2Loop parent = this.loop(this.getParent(i2));
            if (parent != lastParent) {
                vertices.clear();
                for (int j2 = 0; j2 < parent.numVertices(); ++j2) {
                    vertices.add((Object)parent.vertex(j2));
                }
                lastParent = parent;
            }
            int count = 0;
            for (int j3 = 0; j3 < child.numVertices(); ++j3) {
                if (vertices.count((Object)child.vertex(j3)) <= 0) continue;
                ++count;
            }
            if (count <= true) continue;
            return false;
        }
        return true;
    }

    boolean boundaryApproxEquals(S2Polygon b2, double maxError) {
        if (this.numLoops() != b2.numLoops()) {
            log.severe("!= loops: " + Integer.toString(this.numLoops()) + " vs. " + Integer.toString(b2.numLoops()));
            return false;
        }
        for (int i2 = 0; i2 < this.numLoops(); ++i2) {
            S2Loop aLoop = this.loop(i2);
            boolean success = false;
            for (int j2 = 0; j2 < this.numLoops(); ++j2) {
                S2Loop bLoop = b2.loop(j2);
                if (bLoop.depth() != aLoop.depth() || !bLoop.boundaryApproxEquals(aLoop, maxError)) continue;
                success = true;
                break;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    @Override
    public S2Cap getCapBound() {
        return this.bound.getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this.bound;
    }

    @Override
    public boolean contains(S2Cell cell) {
        if (this.numLoops() == 1) {
            return this.loop(0).contains(cell);
        }
        S2LatLngRect cellBound = cell.getRectBound();
        if (!this.bound.contains(cellBound)) {
            return false;
        }
        S2Loop cellLoop = new S2Loop(cell, cellBound);
        S2Polygon cellPoly = new S2Polygon(cellLoop);
        return this.contains(cellPoly);
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        if (this.numLoops() == 1) {
            return this.loop(0).mayIntersect(cell);
        }
        S2LatLngRect cellBound = cell.getRectBound();
        if (!this.bound.intersects(cellBound)) {
            return false;
        }
        S2Loop cellLoop = new S2Loop(cell, cellBound);
        S2Polygon cellPoly = new S2Polygon(cellLoop);
        return this.intersects(cellPoly);
    }

    public boolean contains(S2Point p2) {
        if (this.numLoops() == 1) {
            return this.loop(0).contains(p2);
        }
        if (!this.bound.contains(p2)) {
            return false;
        }
        boolean inside = false;
        for (int i2 = 0; i2 < this.numLoops() && (!(inside ^= this.loop(i2).contains(p2)) || this.hasHoles); ++i2) {
        }
        return inside;
    }

    private static void sortValueLoops(Map<S2Loop, List<S2Loop>> loopMap) {
        for (S2Loop key : loopMap.keySet()) {
            Collections.sort(loopMap.get(key));
        }
    }

    private static void insertLoop(S2Loop newLoop, S2Loop parent, Map<S2Loop, List<S2Loop>> loopMap) {
        ArrayList children = loopMap.get(parent);
        if (children == null) {
            children = Lists.newArrayList();
            loopMap.put(parent, children);
        }
        for (S2Loop child : children) {
            if (!child.containsNested(newLoop)) continue;
            S2Polygon.insertLoop(newLoop, child, loopMap);
            return;
        }
        ArrayList newChildren = loopMap.get(newLoop);
        int i2 = 0;
        while (i2 < children.size()) {
            S2Loop child = (S2Loop)children.get(i2);
            if (newLoop.containsNested(child)) {
                if (newChildren == null) {
                    newChildren = Lists.newArrayList();
                    loopMap.put(newLoop, newChildren);
                }
                newChildren.add(child);
                children.remove(i2);
                continue;
            }
            ++i2;
        }
        children.add(newLoop);
    }

    private void initLoop(S2Loop loop, int depth, Map<S2Loop, List<S2Loop>> loopMap) {
        List<S2Loop> children;
        if (loop != null) {
            loop.setDepth(depth);
            this.loops.add(loop);
        }
        if ((children = loopMap.get(loop)) != null) {
            for (S2Loop child : children) {
                this.initLoop(child, depth + 1, loopMap);
            }
        }
    }

    private int containsOrCrosses(S2Loop b2) {
        boolean inside = false;
        for (int i2 = 0; i2 < this.numLoops(); ++i2) {
            int result = this.loop(i2).containsOrCrosses(b2);
            if (result < 0) {
                return -1;
            }
            if (result <= 0) continue;
            inside ^= true;
        }
        return inside ? 1 : 0;
    }

    private boolean anyLoopContains(S2Loop b2) {
        for (int i2 = 0; i2 < this.numLoops(); ++i2) {
            if (!this.loop(i2).contains(b2)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAllShells(S2Polygon b2) {
        for (int j2 = 0; j2 < b2.numLoops(); ++j2) {
            if (b2.loop(j2).sign() < 0 || this.containsOrCrosses(b2.loop(j2)) > 0) continue;
            return false;
        }
        return true;
    }

    private boolean excludesAllHoles(S2Polygon b2) {
        for (int j2 = 0; j2 < b2.numLoops(); ++j2) {
            if (b2.loop(j2).sign() > 0 || this.containsOrCrosses(b2.loop(j2)) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean intersectsAnyShell(S2Polygon b2) {
        for (int j2 = 0; j2 < b2.numLoops(); ++j2) {
            if (b2.loop(j2).sign() < 0 || this.containsOrCrosses(b2.loop(j2)) == 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polygon: (").append(this.numLoops()).append(") loops:\n");
        for (int i2 = 0; i2 < this.numLoops(); ++i2) {
            S2Loop s2Loop = this.loop(i2);
            sb.append("loop <\n");
            for (int v = 0; v < s2Loop.numVertices(); ++v) {
                S2Point s2Point = s2Loop.vertex(v);
                sb.append(s2Point.toDegreesString());
                sb.append("\n");
            }
            sb.append(">\n");
        }
        return sb.toString();
    }

    private strictfp static final class ParametrizedS2Point
    implements Comparable<ParametrizedS2Point> {
        private final double time;
        private final S2Point point;

        public ParametrizedS2Point(double time, S2Point point) {
            this.time = time;
            this.point = point;
        }

        public double getTime() {
            return this.time;
        }

        public S2Point getPoint() {
            return this.point;
        }

        @Override
        public int compareTo(ParametrizedS2Point o2) {
            int compareTime = Double.compare(this.time, o2.time);
            if (compareTime != 0) {
                return compareTime;
            }
            return this.point.compareTo(o2.point);
        }
    }

    private strictfp static final class LoopVertexIndexPair {
        private final int loopIndex;
        private final int vertexIndex;

        public LoopVertexIndexPair(int loopIndex, int vertexIndex) {
            this.loopIndex = loopIndex;
            this.vertexIndex = vertexIndex;
        }

        public int getLoopIndex() {
            return this.loopIndex;
        }

        public int getVertexIndex() {
            return this.vertexIndex;
        }
    }

    private strictfp static final class UndirectedEdge {
        private final S2Point a;
        private final S2Point b;

        public UndirectedEdge(S2Point start, S2Point end) {
            this.a = start;
            this.b = end;
        }

        public S2Point getStart() {
            return this.a;
        }

        public S2Point getEnd() {
            return this.b;
        }

        public String toString() {
            return String.format("Edge: (%s <-> %s)\n   or [%s <-> %s]", this.a.toDegreesString(), this.b.toDegreesString(), this.a, this.b);
        }

        public boolean equals(Object o2) {
            if (o2 == null || !(o2 instanceof UndirectedEdge)) {
                return false;
            }
            UndirectedEdge other = (UndirectedEdge)o2;
            return this.getStart().equals(other.getStart()) && this.getEnd().equals(other.getEnd()) || this.getStart().equals(other.getEnd()) && this.getEnd().equals(other.getStart());
        }

        public int hashCode() {
            return this.getStart().hashCode() + this.getEnd().hashCode();
        }
    }

    private strictfp static final class S2PolygonIndex
    extends S2LoopSequenceIndex {
        private final S2Polygon poly;
        private final boolean reverse;

        private static int[] getVertices(S2Polygon poly) {
            int[] vertices = new int[poly.numLoops()];
            for (int i2 = 0; i2 < vertices.length; ++i2) {
                vertices[i2] = poly.loop(i2).numVertices();
            }
            return vertices;
        }

        public S2PolygonIndex(S2Polygon poly, boolean reverse) {
            super(S2PolygonIndex.getVertices(poly));
            this.poly = poly;
            this.reverse = reverse;
        }

        @Override
        public S2Edge edgeFromTo(int index) {
            int toIndex;
            int fromIndex;
            LoopVertexIndexPair indices = this.decodeIndex(index);
            int loopIndex = indices.getLoopIndex();
            int vertexInLoop = indices.getVertexIndex();
            S2Loop loop = this.poly.loop(loopIndex);
            if (loop.isHole() ^ this.reverse) {
                fromIndex = loop.numVertices() - 1 - vertexInLoop;
                toIndex = 2 * loop.numVertices() - 2 - vertexInLoop;
            } else {
                fromIndex = vertexInLoop;
                toIndex = vertexInLoop + 1;
            }
            S2Point from = loop.vertex(fromIndex);
            S2Point to = loop.vertex(toIndex);
            return new S2Edge(from, to);
        }
    }

    private strictfp static abstract class S2LoopSequenceIndex
    extends S2EdgeIndex {
        private final int[] indexToLoop;
        private final int[] loopToFirstIndex;

        public S2LoopSequenceIndex(int[] numVertices) {
            int totalEdges = 0;
            for (int edges : numVertices) {
                totalEdges += edges;
            }
            this.indexToLoop = new int[totalEdges];
            this.loopToFirstIndex = new int[numVertices.length];
            totalEdges = 0;
            for (int j2 = 0; j2 < numVertices.length; ++j2) {
                this.loopToFirstIndex[j2] = totalEdges;
                for (int i2 = 0; i2 < numVertices[j2]; ++i2) {
                    this.indexToLoop[totalEdges] = j2;
                    ++totalEdges;
                }
            }
        }

        public final LoopVertexIndexPair decodeIndex(int index) {
            int loopIndex = this.indexToLoop[index];
            int vertexInLoop = index - this.loopToFirstIndex[loopIndex];
            return new LoopVertexIndexPair(loopIndex, vertexInLoop);
        }

        public abstract S2Edge edgeFromTo(int var1);

        @Override
        public final int getNumEdges() {
            return this.indexToLoop.length;
        }

        @Override
        public S2Point edgeFrom(int index) {
            S2Edge fromTo = this.edgeFromTo(index);
            S2Point from = fromTo.getStart();
            return from;
        }

        @Override
        protected S2Point edgeTo(int index) {
            S2Edge fromTo = this.edgeFromTo(index);
            S2Point to = fromTo.getEnd();
            return to;
        }
    }
}

