/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

import com.baidu.common.geometry.R1Interval;
import com.baidu.common.geometry.S1Angle;
import com.baidu.common.geometry.S1Interval;
import com.baidu.common.geometry.S2;
import com.baidu.common.geometry.S2Cap;
import com.baidu.common.geometry.S2Cell;
import com.baidu.common.geometry.S2EdgeUtil;
import com.baidu.common.geometry.S2LatLng;
import com.baidu.common.geometry.S2Point;
import com.baidu.common.geometry.S2Region;
import com.google.common.base.Preconditions;

public strictfp class S2LatLngRect
implements S2Region {
    private final R1Interval lat;
    private final S1Interval lng;

    public S2LatLngRect(S2LatLng lo, S2LatLng hi) {
        this.lat = new R1Interval(lo.lat().radians(), hi.lat().radians());
        this.lng = new S1Interval(lo.lng().radians(), hi.lng().radians());
    }

    public S2LatLngRect(R1Interval lat, S1Interval lng) {
        this.lat = lat;
        this.lng = lng;
    }

    public static S2LatLngRect empty() {
        return new S2LatLngRect(R1Interval.empty(), S1Interval.empty());
    }

    public static S2LatLngRect full() {
        return new S2LatLngRect(S2LatLngRect.fullLat(), S2LatLngRect.fullLng());
    }

    public static R1Interval fullLat() {
        return new R1Interval(-1.5707963267948966, 1.5707963267948966);
    }

    public static S1Interval fullLng() {
        return S1Interval.full();
    }

    public static S2LatLngRect fromCenterSize(S2LatLng center, S2LatLng size) {
        return S2LatLngRect.fromPoint(center).expanded(size.mul(0.5));
    }

    public static S2LatLngRect fromPoint(S2LatLng p2) {
        return new S2LatLngRect(p2, p2);
    }

    public static S2LatLngRect fromPointPair(S2LatLng p1, S2LatLng p2) {
        return new S2LatLngRect(R1Interval.fromPointPair(p1.lat().radians(), p2.lat().radians()), S1Interval.fromPointPair(p1.lng().radians(), p2.lng().radians()));
    }

    public static S2LatLngRect fromEdge(S2Point a2, S2Point b2) {
        double db;
        S2LatLngRect r = S2LatLngRect.fromPointPair(new S2LatLng(a2), new S2LatLng(b2));
        S2Point ab = S2.robustCrossProd(a2, b2);
        S2Point dir = S2Point.crossProd(ab, new S2Point(0.0, 0.0, 1.0));
        double da = dir.dotProd(a2);
        if (da * (db = dir.dotProd(b2)) >= 0.0) {
            return r;
        }
        double absLat = Math.acos(Math.abs(ab.z / ab.norm()));
        if (da < 0.0) {
            return new S2LatLngRect(new R1Interval(r.lat().lo(), absLat), r.lng());
        }
        return new S2LatLngRect(new R1Interval(-absLat, r.lat().hi()), r.lng());
    }

    public boolean isValid() {
        return Math.abs(this.lat.lo()) <= 1.5707963267948966 && Math.abs(this.lat.hi()) <= 1.5707963267948966 && this.lng.isValid() && this.lat.isEmpty() == this.lng.isEmpty();
    }

    public S1Angle latLo() {
        return S1Angle.radians(this.lat.lo());
    }

    public S1Angle latHi() {
        return S1Angle.radians(this.lat.hi());
    }

    public S1Angle lngLo() {
        return S1Angle.radians(this.lng.lo());
    }

    public S1Angle lngHi() {
        return S1Angle.radians(this.lng.hi());
    }

    public R1Interval lat() {
        return this.lat;
    }

    public S1Interval lng() {
        return this.lng;
    }

    public S2LatLng lo() {
        return new S2LatLng(this.latLo(), this.lngLo());
    }

    public S2LatLng hi() {
        return new S2LatLng(this.latHi(), this.lngHi());
    }

    public boolean isEmpty() {
        return this.lat.isEmpty();
    }

    public boolean isFull() {
        return this.lat.equals(S2LatLngRect.fullLat()) && this.lng.isFull();
    }

    public boolean isInverted() {
        return this.lng.isInverted();
    }

    public S2LatLng getVertex(int k2) {
        switch (k2) {
            case 0: {
                return S2LatLng.fromRadians(this.lat.lo(), this.lng.lo());
            }
            case 1: {
                return S2LatLng.fromRadians(this.lat.lo(), this.lng.hi());
            }
            case 2: {
                return S2LatLng.fromRadians(this.lat.hi(), this.lng.hi());
            }
            case 3: {
                return S2LatLng.fromRadians(this.lat.hi(), this.lng.lo());
            }
        }
        throw new IllegalArgumentException("Invalid vertex index.");
    }

    public S2LatLng getCenter() {
        return S2LatLng.fromRadians(this.lat.getCenter(), this.lng.getCenter());
    }

    public S1Angle getDistance(S2LatLng p2) {
        S2LatLngRect a2 = this;
        Preconditions.checkState((!a2.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)p2.isValid());
        if (a2.lng().contains(p2.lng().radians())) {
            return S1Angle.radians(Math.max(0.0, Math.max(p2.lat().radians() - a2.lat().hi(), a2.lat().lo() - p2.lat().radians())));
        }
        S1Interval interval = new S1Interval(a2.lng().hi(), a2.lng().complement().getCenter());
        double aLng = a2.lng().lo();
        if (interval.contains(p2.lng().radians())) {
            aLng = a2.lng().hi();
        }
        S2Point lo = S2LatLng.fromRadians(a2.lat().lo(), aLng).toPoint();
        S2Point hi = S2LatLng.fromRadians(a2.lat().hi(), aLng).toPoint();
        S2Point loCrossHi = S2LatLng.fromRadians(0.0, aLng - 1.5707963267948966).normalized().toPoint();
        return S2EdgeUtil.getDistance(p2.toPoint(), lo, hi, loCrossHi);
    }

    public S1Angle getDistance(S2LatLngRect other) {
        S1Angle bLng;
        S1Angle aLng;
        S2LatLngRect a2 = this;
        S2LatLngRect b2 = other;
        Preconditions.checkState((!a2.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!b2.isEmpty() ? 1 : 0) != 0);
        if (a2.lng().intersects(b2.lng())) {
            S1Angle hi;
            S1Angle lo;
            if (a2.lat().intersects(b2.lat())) {
                return S1Angle.radians(0.0);
            }
            if (a2.lat().lo() > b2.lat().hi()) {
                lo = b2.latHi();
                hi = a2.latLo();
            } else {
                lo = a2.latHi();
                hi = b2.latLo();
            }
            return S1Angle.radians(hi.radians() - lo.radians());
        }
        S1Interval loHi = S1Interval.fromPointPair(a2.lng().lo(), b2.lng().hi());
        S1Interval hiLo = S1Interval.fromPointPair(a2.lng().hi(), b2.lng().lo());
        if (loHi.getLength() < hiLo.getLength()) {
            aLng = a2.lngLo();
            bLng = b2.lngHi();
        } else {
            aLng = a2.lngHi();
            bLng = b2.lngLo();
        }
        S2Point aLo = new S2LatLng(a2.latLo(), aLng).toPoint();
        S2Point aHi = new S2LatLng(a2.latHi(), aLng).toPoint();
        S2Point aLoCrossHi = S2LatLng.fromRadians(0.0, aLng.radians() - 1.5707963267948966).normalized().toPoint();
        S2Point bLo = new S2LatLng(b2.latLo(), bLng).toPoint();
        S2Point bHi = new S2LatLng(b2.latHi(), bLng).toPoint();
        S2Point bLoCrossHi = S2LatLng.fromRadians(0.0, bLng.radians() - 1.5707963267948966).normalized().toPoint();
        return S1Angle.min(S2EdgeUtil.getDistance(aLo, bLo, bHi, bLoCrossHi), S1Angle.min(S2EdgeUtil.getDistance(aHi, bLo, bHi, bLoCrossHi), S1Angle.min(S2EdgeUtil.getDistance(bLo, aLo, aHi, aLoCrossHi), S2EdgeUtil.getDistance(bHi, aLo, aHi, aLoCrossHi))));
    }

    public S2LatLng getSize() {
        return S2LatLng.fromRadians(this.lat.getLength(), this.lng.getLength());
    }

    public boolean contains(S2LatLng ll) {
        return this.lat.contains(ll.lat().radians()) && this.lng.contains(ll.lng().radians());
    }

    public boolean interiorContains(S2Point p2) {
        return this.interiorContains(new S2LatLng(p2));
    }

    public boolean interiorContains(S2LatLng ll) {
        return this.lat.interiorContains(ll.lat().radians()) && this.lng.interiorContains(ll.lng().radians());
    }

    public boolean contains(S2LatLngRect other) {
        return this.lat.contains(other.lat) && this.lng.contains(other.lng);
    }

    public boolean interiorContains(S2LatLngRect other) {
        return this.lat.interiorContains(other.lat) && this.lng.interiorContains(other.lng);
    }

    public boolean intersects(S2LatLngRect other) {
        return this.lat.intersects(other.lat) && this.lng.intersects(other.lng);
    }

    public boolean intersects(S2Cell cell) {
        int i2;
        if (this.isEmpty()) {
            return false;
        }
        if (this.contains(cell.getCenter())) {
            return true;
        }
        if (cell.contains(this.getCenter().toPoint())) {
            return true;
        }
        if (!this.intersects(cell.getRectBound())) {
            return false;
        }
        S2Point[] cellV = new S2Point[4];
        S2LatLng[] cellLl = new S2LatLng[4];
        for (i2 = 0; i2 < 4; ++i2) {
            cellV[i2] = cell.getVertex(i2);
            cellLl[i2] = new S2LatLng(cellV[i2]);
            if (!this.contains(cellLl[i2])) continue;
            return true;
        }
        for (i2 = 0; i2 < 4; ++i2) {
            S1Interval edgeLng = S1Interval.fromPointPair(cellLl[i2].lng().radians(), cellLl[i2 + 1 & 3].lng().radians());
            if (!this.lng.intersects(edgeLng)) continue;
            S2Point a2 = cellV[i2];
            S2Point b2 = cellV[i2 + 1 & 3];
            if (edgeLng.contains(this.lng.lo()) && S2LatLngRect.intersectsLngEdge(a2, b2, this.lat, this.lng.lo())) {
                return true;
            }
            if (edgeLng.contains(this.lng.hi()) && S2LatLngRect.intersectsLngEdge(a2, b2, this.lat, this.lng.hi())) {
                return true;
            }
            if (S2LatLngRect.intersectsLatEdge(a2, b2, this.lat.lo(), this.lng)) {
                return true;
            }
            if (!S2LatLngRect.intersectsLatEdge(a2, b2, this.lat.hi(), this.lng)) continue;
            return true;
        }
        return false;
    }

    public boolean interiorIntersects(S2LatLngRect other) {
        return this.lat.interiorIntersects(other.lat) && this.lng.interiorIntersects(other.lng);
    }

    public S2LatLngRect addPoint(S2Point p2) {
        return this.addPoint(new S2LatLng(p2));
    }

    public S2LatLngRect addPoint(S2LatLng ll) {
        R1Interval newLat = this.lat.addPoint(ll.lat().radians());
        S1Interval newLng = this.lng.addPoint(ll.lng().radians());
        return new S2LatLngRect(newLat, newLng);
    }

    public S2LatLngRect expanded(S2LatLng margin) {
        if (this.isEmpty()) {
            return this;
        }
        return new S2LatLngRect(this.lat.expanded(margin.lat().radians()).intersection(S2LatLngRect.fullLat()), this.lng.expanded(margin.lng().radians()));
    }

    public S2LatLngRect union(S2LatLngRect other) {
        return new S2LatLngRect(this.lat.union(other.lat), this.lng.union(other.lng));
    }

    public S2LatLngRect intersection(S2LatLngRect other) {
        R1Interval intersectLat = this.lat.intersection(other.lat);
        S1Interval intersectLng = this.lng.intersection(other.lng);
        if (intersectLat.isEmpty() || intersectLng.isEmpty()) {
            return S2LatLngRect.empty();
        }
        return new S2LatLngRect(intersectLat, intersectLng);
    }

    public S2LatLngRect convolveWithCap(S1Angle angle) {
        S2Cap cap = S2Cap.fromAxisAngle(new S2Point(1.0, 0.0, 0.0), angle);
        S2LatLngRect r = this;
        for (int k2 = 0; k2 < 4; ++k2) {
            S2Cap vertexCap = S2Cap.fromAxisHeight(this.getVertex(k2).toPoint(), cap.height());
            r = r.union(vertexCap.getRectBound());
        }
        return r;
    }

    public double area() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return this.lng().getLength() * Math.abs(Math.sin(this.latHi().radians()) - Math.sin(this.latLo().radians()));
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2LatLngRect)) {
            return false;
        }
        S2LatLngRect otherRect = (S2LatLngRect)that;
        return this.lat().equals(otherRect.lat()) && this.lng().equals(otherRect.lng());
    }

    public boolean approxEquals(S2LatLngRect other, double maxError) {
        return this.lat.approxEquals(other.lat, maxError) && this.lng.approxEquals(other.lng, maxError);
    }

    public boolean approxEquals(S2LatLngRect other) {
        return this.approxEquals(other, 1.0E-15);
    }

    public int hashCode() {
        int value = 17;
        value = 37 * value + this.lat.hashCode();
        return 37 * value + this.lng.hashCode();
    }

    public S2Region clone() {
        return new S2LatLngRect(this.lo(), this.hi());
    }

    @Override
    public S2Cap getCapBound() {
        double poleAngle;
        double poleZ;
        if (this.isEmpty()) {
            return S2Cap.empty();
        }
        if (this.lat.lo() + this.lat.hi() < 0.0) {
            poleZ = -1.0;
            poleAngle = 1.5707963267948966 + this.lat.hi();
        } else {
            poleZ = 1.0;
            poleAngle = 1.5707963267948966 - this.lat.lo();
        }
        S2Cap poleCap = S2Cap.fromAxisAngle(new S2Point(0.0, 0.0, poleZ), S1Angle.radians(poleAngle));
        double lngSpan = this.lng.hi() - this.lng.lo();
        if (Math.IEEEremainder(lngSpan, Math.PI * 2) >= 0.0 && lngSpan < Math.PI * 2) {
            S2Cap midCap = S2Cap.fromAxisAngle(this.getCenter().toPoint(), S1Angle.radians(0.0));
            for (int k2 = 0; k2 < 4; ++k2) {
                midCap = midCap.addPoint(this.getVertex(k2).toPoint());
            }
            if (midCap.height() < poleCap.height()) {
                return midCap;
            }
        }
        return poleCap;
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this;
    }

    @Override
    public boolean contains(S2Cell cell) {
        return this.contains(cell.getRectBound());
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        return this.intersects(cell.getRectBound());
    }

    public boolean contains(S2Point p2) {
        return this.contains(new S2LatLng(p2));
    }

    private static boolean intersectsLngEdge(S2Point a2, S2Point b2, R1Interval lat, double lng) {
        return S2.simpleCrossing(a2, b2, S2LatLng.fromRadians(lat.lo(), lng).toPoint(), S2LatLng.fromRadians(lat.hi(), lng).toPoint());
    }

    private static boolean intersectsLatEdge(S2Point a2, S2Point b2, double lat, S1Interval lng) {
        S2Point z2 = S2Point.normalize(S2.robustCrossProd(a2, b2));
        if (z2.z < 0.0) {
            z2 = S2Point.neg(z2);
        }
        S2Point y = S2Point.normalize(S2.robustCrossProd(z2, new S2Point(0.0, 0.0, 1.0)));
        S2Point x = S2Point.crossProd(y, z2);
        double sinLat = Math.sin(lat);
        if (Math.abs(sinLat) >= x.z) {
            return false;
        }
        double cosTheta = sinLat / x.z;
        double sinTheta = Math.sqrt(1.0 - cosTheta * cosTheta);
        double theta = Math.atan2(sinTheta, cosTheta);
        S1Interval abTheta = S1Interval.fromPointPair(Math.atan2(a2.dotProd(y), a2.dotProd(x)), Math.atan2(b2.dotProd(y), b2.dotProd(x)));
        if (abTheta.contains(theta)) {
            S2Point isect = S2Point.add(S2Point.mul(x, cosTheta), S2Point.mul(y, sinTheta));
            if (lng.contains(Math.atan2(isect.y, isect.x))) {
                return true;
            }
        }
        if (abTheta.contains(-theta)) {
            S2Point intersection = S2Point.sub(S2Point.mul(x, cosTheta), S2Point.mul(y, sinTheta));
            if (lng.contains(Math.atan2(intersection.y, intersection.x))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "[Lo=" + this.lo() + ", Hi=" + this.hi() + "]";
    }
}

