/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

import com.baidu.common.geometry.R1Interval;
import com.baidu.common.geometry.S1Angle;
import com.baidu.common.geometry.S1Interval;
import com.baidu.common.geometry.S2;
import com.baidu.common.geometry.S2LatLng;
import com.baidu.common.geometry.S2LatLngRect;
import com.baidu.common.geometry.S2Point;
import com.google.common.base.Preconditions;

public strictfp class S2EdgeUtil {
    public static final S1Angle DEFAULT_INTERSECTION_TOLERANCE = S1Angle.radians(1.5E-15);

    public static boolean simpleCrossing(S2Point a2, S2Point b2, S2Point c2, S2Point d2) {
        double bda;
        S2Point ab = S2Point.crossProd(a2, b2);
        double acb = -ab.dotProd(c2);
        if (acb * (bda = ab.dotProd(d2)) <= 0.0) {
            return false;
        }
        S2Point cd = S2Point.crossProd(c2, d2);
        double cbd = -cd.dotProd(b2);
        double dac = cd.dotProd(a2);
        return acb * cbd > 0.0 && acb * dac > 0.0;
    }

    public static int robustCrossing(S2Point a2, S2Point b2, S2Point c2, S2Point d2) {
        S2Point aCrossB = S2Point.crossProd(a2, b2);
        int acb = -S2.robustCCW(a2, b2, c2, aCrossB);
        int bda = S2.robustCCW(a2, b2, d2, aCrossB);
        if ((bda & acb) == 0) {
            return 0;
        }
        if (bda != acb) {
            return -1;
        }
        S2Point cCrossD = S2Point.crossProd(c2, d2);
        int cbd = -S2.robustCCW(c2, d2, b2, cCrossD);
        if (cbd != acb) {
            return -1;
        }
        int dac = S2.robustCCW(c2, d2, a2, cCrossD);
        return dac == acb ? 1 : -1;
    }

    public static boolean vertexCrossing(S2Point a2, S2Point b2, S2Point c2, S2Point d2) {
        if (a2.equals(b2) || c2.equals(d2)) {
            return false;
        }
        if (a2.equals(d2)) {
            return S2.orderedCCW(S2.ortho(a2), c2, b2, a2);
        }
        if (b2.equals(c2)) {
            return S2.orderedCCW(S2.ortho(b2), d2, a2, b2);
        }
        if (a2.equals(c2)) {
            return S2.orderedCCW(S2.ortho(a2), d2, b2, a2);
        }
        if (b2.equals(d2)) {
            return S2.orderedCCW(S2.ortho(b2), c2, a2, b2);
        }
        return false;
    }

    public static boolean edgeOrVertexCrossing(S2Point a2, S2Point b2, S2Point c2, S2Point d2) {
        int crossing = S2EdgeUtil.robustCrossing(a2, b2, c2, d2);
        if (crossing < 0) {
            return false;
        }
        if (crossing > 0) {
            return true;
        }
        return S2EdgeUtil.vertexCrossing(a2, b2, c2, d2);
    }

    public static S2Point getIntersection(S2Point a0, S2Point a1, S2Point b0, S2Point b1) {
        Preconditions.checkArgument((S2EdgeUtil.robustCrossing(a0, a1, b0, b1) > 0 ? 1 : 0) != 0, (Object)"Input edges a0a1 and b0b1 muct have a true robustCrossing.");
        S2Point aNorm = S2Point.normalize(S2.robustCrossProd(a0, a1));
        S2Point bNorm = S2Point.normalize(S2.robustCrossProd(b0, b1));
        S2Point x = S2Point.normalize(S2.robustCrossProd(aNorm, bNorm));
        if (x.dotProd(S2Point.add(S2Point.add(a0, a1), S2Point.add(b0, b1))) < 0.0) {
            x = S2Point.neg(x);
        }
        if (S2.orderedCCW(a0, x, a1, aNorm) && S2.orderedCCW(b0, x, b1, bNorm)) {
            return x;
        }
        CloserResult r = new CloserResult(10.0, x);
        if (S2.orderedCCW(b0, a0, b1, bNorm)) {
            r.replaceIfCloser(x, a0);
        }
        if (S2.orderedCCW(b0, a1, b1, bNorm)) {
            r.replaceIfCloser(x, a1);
        }
        if (S2.orderedCCW(a0, b0, a1, aNorm)) {
            r.replaceIfCloser(x, b0);
        }
        if (S2.orderedCCW(a0, b1, a1, aNorm)) {
            r.replaceIfCloser(x, b1);
        }
        return r.getVmin();
    }

    public static double getDistanceFraction(S2Point x, S2Point a0, S2Point a1) {
        Preconditions.checkArgument((!a0.equals(a1) ? 1 : 0) != 0);
        double d0 = x.angle(a0);
        double d1 = x.angle(a1);
        return d0 / (d0 + d1);
    }

    public static S1Angle getDistance(S2Point x, S2Point a2, S2Point b2) {
        return S2EdgeUtil.getDistance(x, a2, b2, S2.robustCrossProd(a2, b2));
    }

    public static S1Angle getDistance(S2Point x, S2Point a2, S2Point b2, S2Point aCrossB) {
        Preconditions.checkArgument((boolean)S2.isUnitLength(x));
        Preconditions.checkArgument((boolean)S2.isUnitLength(a2));
        Preconditions.checkArgument((boolean)S2.isUnitLength(b2));
        if (S2.simpleCCW(aCrossB, a2, x) && S2.simpleCCW(x, b2, aCrossB)) {
            double sinDist = Math.abs(x.dotProd(aCrossB)) / aCrossB.norm();
            return S1Angle.radians(Math.asin(Math.min(1.0, sinDist)));
        }
        double linearDist2 = Math.min(S2Point.minus(x, a2).norm2(), S2Point.minus(x, b2).norm2());
        return S1Angle.radians(2.0 * Math.asin(Math.min(1.0, 0.5 * Math.sqrt(linearDist2))));
    }

    public static S2Point getClosestPoint(S2Point x, S2Point a2, S2Point b2) {
        Preconditions.checkArgument((boolean)S2.isUnitLength(x));
        Preconditions.checkArgument((boolean)S2.isUnitLength(a2));
        Preconditions.checkArgument((boolean)S2.isUnitLength(b2));
        S2Point crossProd = S2.robustCrossProd(a2, b2);
        S2Point p2 = S2Point.minus(x, S2Point.mul(crossProd, x.dotProd(crossProd) / crossProd.norm2()));
        if (S2.simpleCCW(crossProd, a2, p2) && S2.simpleCCW(p2, b2, crossProd)) {
            return S2Point.normalize(p2);
        }
        return S2Point.minus(x, a2).norm2() <= S2Point.minus(x, b2).norm2() ? a2 : b2;
    }

    private S2EdgeUtil() {
    }

    strictfp static class CloserResult {
        private double dmin2;
        private S2Point vmin;

        public double getDmin2() {
            return this.dmin2;
        }

        public S2Point getVmin() {
            return this.vmin;
        }

        public CloserResult(double dmin2, S2Point vmin) {
            this.dmin2 = dmin2;
            this.vmin = vmin;
        }

        public void replaceIfCloser(S2Point x, S2Point y) {
            double d2 = S2Point.minus(x, y).norm2();
            if (d2 < this.dmin2 || d2 == this.dmin2 && y.lessThan(this.vmin)) {
                this.dmin2 = d2;
                this.vmin = y;
            }
        }
    }

    public strictfp static class WedgeContainsOrCrosses
    implements WedgeRelation {
        @Override
        public int test(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            if (S2.orderedCCW(a0, a2, b2, ab1)) {
                if (S2.orderedCCW(b2, b0, a0, ab1)) {
                    return 1;
                }
                return a2.equals(b2) ? 0 : -1;
            }
            return S2.orderedCCW(a0, b0, a2, ab1) ? 0 : -1;
        }
    }

    public strictfp static class WedgeContainsOrIntersects
    implements WedgeRelation {
        @Override
        public int test(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            if (S2.orderedCCW(a0, a2, b2, ab1)) {
                return S2.orderedCCW(b2, b0, a0, ab1) ? 1 : -1;
            }
            if (!S2.orderedCCW(a2, b0, b2, ab1)) {
                return 0;
            }
            return a2.equals(b0) ? 0 : -1;
        }
    }

    public strictfp static class WedgeIntersects
    implements WedgeRelation {
        @Override
        public int test(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            return S2.orderedCCW(a0, b2, b0, ab1) && S2.orderedCCW(b0, a2, a0, ab1) ? 0 : -1;
        }
    }

    public strictfp static class WedgeContains
    implements WedgeRelation {
        @Override
        public int test(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            return S2.orderedCCW(a2, b2, b0, ab1) && S2.orderedCCW(b0, a0, a2, ab1) ? 1 : 0;
        }
    }

    public static interface WedgeRelation {
        public int test(S2Point var1, S2Point var2, S2Point var3, S2Point var4, S2Point var5);
    }

    public strictfp static class LongitudePruner {
        private S1Interval interval;
        private double lng0;

        public LongitudePruner(S1Interval interval, S2Point v0) {
            this.interval = interval;
            this.lng0 = S2LatLng.longitude(v0).radians();
        }

        public boolean intersects(S2Point v1) {
            double lng1 = S2LatLng.longitude(v1).radians();
            boolean result = this.interval.intersects(S1Interval.fromPointPair(this.lng0, lng1));
            this.lng0 = lng1;
            return result;
        }
    }

    public strictfp static class XYZPruner {
        private S2Point lastVertex;
        private boolean boundSet = false;
        private double xmin;
        private double ymin;
        private double zmin;
        private double xmax;
        private double ymax;
        private double zmax;
        private double maxDeformation;

        public void addEdgeToBounds(S2Point from, S2Point to) {
            if (!this.boundSet) {
                this.boundSet = true;
                this.xmin = this.xmax = from.x;
                this.ymin = this.ymax = from.y;
                this.zmin = this.zmax = from.z;
            }
            this.xmin = Math.min(this.xmin, Math.min(to.x, from.x));
            this.ymin = Math.min(this.ymin, Math.min(to.y, from.y));
            this.zmin = Math.min(this.zmin, Math.min(to.z, from.z));
            this.xmax = Math.max(this.xmax, Math.max(to.x, from.x));
            this.ymax = Math.max(this.ymax, Math.max(to.y, from.y));
            this.zmax = Math.max(this.zmax, Math.max(to.z, from.z));
            double approxArcLen = Math.abs(from.x - to.x) + Math.abs(from.y - to.y) + Math.abs(from.z - to.z);
            this.maxDeformation = approxArcLen < 0.025 ? Math.max(this.maxDeformation, approxArcLen * 0.0025) : (approxArcLen < 1.0 ? Math.max(this.maxDeformation, approxArcLen * 0.11) : approxArcLen * 0.5);
        }

        public void setFirstIntersectPoint(S2Point v0) {
            this.xmin -= this.maxDeformation;
            this.ymin -= this.maxDeformation;
            this.zmin -= this.maxDeformation;
            this.xmax += this.maxDeformation;
            this.ymax += this.maxDeformation;
            this.zmax += this.maxDeformation;
            this.lastVertex = v0;
        }

        public boolean intersects(S2Point v1) {
            boolean result = true;
            if (v1.x < this.xmin && this.lastVertex.x < this.xmin || v1.x > this.xmax && this.lastVertex.x > this.xmax) {
                result = false;
            } else if (v1.y < this.ymin && this.lastVertex.y < this.ymin || v1.y > this.ymax && this.lastVertex.y > this.ymax) {
                result = false;
            } else if (v1.z < this.zmin && this.lastVertex.z < this.zmin || v1.z > this.zmax && this.lastVertex.z > this.zmax) {
                result = false;
            }
            this.lastVertex = v1;
            return result;
        }
    }

    public strictfp static class RectBounder {
        private S2Point a;
        private S2LatLng aLatLng;
        private S2LatLngRect bound = S2LatLngRect.empty();

        public void addPoint(S2Point b2) {
            S2LatLng bLatLng = new S2LatLng(b2);
            if (this.bound.isEmpty()) {
                this.bound = this.bound.addPoint(bLatLng);
            } else {
                double db;
                this.bound = this.bound.union(S2LatLngRect.fromPointPair(this.aLatLng, bLatLng));
                S2Point aCrossB = S2.robustCrossProd(this.a, b2);
                S2Point dir = S2Point.crossProd(aCrossB, new S2Point(0.0, 0.0, 1.0));
                double da = dir.dotProd(this.a);
                if (da * (db = dir.dotProd(b2)) < 0.0) {
                    double absLat = Math.acos(Math.abs(aCrossB.get(2) / aCrossB.norm()));
                    R1Interval lat = this.bound.lat();
                    lat = da < 0.0 ? new R1Interval(lat.lo(), Math.max(absLat, this.bound.lat().hi())) : new R1Interval(Math.min(-absLat, this.bound.lat().lo()), lat.hi());
                    this.bound = new S2LatLngRect(lat, this.bound.lng());
                }
            }
            this.a = b2;
            this.aLatLng = bLatLng;
        }

        public S2LatLngRect getBound() {
            return this.bound;
        }
    }

    public strictfp static class EdgeCrosser {
        private final S2Point a;
        private final S2Point b;
        private final S2Point aCrossB;
        private S2Point c;
        private int acb;

        public EdgeCrosser(S2Point a2, S2Point b2, S2Point c2) {
            this.a = a2;
            this.b = b2;
            this.aCrossB = S2Point.crossProd(a2, b2);
            this.restartAt(c2);
        }

        public void restartAt(S2Point c2) {
            this.c = c2;
            this.acb = -S2.robustCCW(this.a, this.b, c2, this.aCrossB);
        }

        public int robustCrossing(S2Point d2) {
            int bda = S2.robustCCW(this.a, this.b, d2, this.aCrossB);
            int result = bda == -this.acb && bda != 0 ? -1 : ((bda & this.acb) == 0 ? 0 : this.robustCrossingInternal(d2));
            this.c = d2;
            this.acb = -bda;
            return result;
        }

        public boolean edgeOrVertexCrossing(S2Point d2) {
            S2Point c2 = new S2Point(this.c.get(0), this.c.get(1), this.c.get(2));
            int crossing = this.robustCrossing(d2);
            if (crossing < 0) {
                return false;
            }
            if (crossing > 0) {
                return true;
            }
            return S2EdgeUtil.vertexCrossing(this.a, this.b, c2, d2);
        }

        private int robustCrossingInternal(S2Point d2) {
            S2Point cCrossD = S2Point.crossProd(this.c, d2);
            int cbd = -S2.robustCCW(this.c, d2, this.b, cCrossD);
            if (cbd != this.acb) {
                return -1;
            }
            int dac = S2.robustCCW(this.c, d2, this.a, cCrossD);
            return dac == this.acb ? 1 : -1;
        }
    }
}

