/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

import com.baidu.common.geometry.MutableInteger;
import com.baidu.common.geometry.R1Interval;
import com.baidu.common.geometry.R2Vector;
import com.baidu.common.geometry.S1Interval;
import com.baidu.common.geometry.S2;
import com.baidu.common.geometry.S2Cap;
import com.baidu.common.geometry.S2CellId;
import com.baidu.common.geometry.S2LatLng;
import com.baidu.common.geometry.S2LatLngRect;
import com.baidu.common.geometry.S2Point;
import com.baidu.common.geometry.S2Projections;
import com.baidu.common.geometry.S2Region;

public strictfp final class S2Cell
implements S2Region {
    private static final int MAX_CELL_SIZE = 0x40000000;
    byte face;
    byte level;
    byte orientation;
    S2CellId cellId;
    double[][] uv = new double[2][2];
    private static final double MAX_ERROR = 4.440892098500626E-16;
    private static final double POLE_MIN_LAT = Math.asin(Math.sqrt(0.3333333333333333)) - 4.440892098500626E-16;

    S2Cell() {
    }

    public S2Cell(S2CellId id) {
        this.init(id);
    }

    public static S2Cell fromFacePosLevel(int face, byte pos, int level) {
        return new S2Cell(S2CellId.fromFacePosLevel(face, pos, level));
    }

    public S2Cell(S2Point p2) {
        this.init(S2CellId.fromPoint(p2));
    }

    public S2Cell(S2LatLng ll) {
        this.init(S2CellId.fromLatLng(ll));
    }

    public S2CellId id() {
        return this.cellId;
    }

    public int face() {
        return this.face;
    }

    public byte level() {
        return this.level;
    }

    public byte orientation() {
        return this.orientation;
    }

    public boolean isLeaf() {
        return this.level == 30;
    }

    public S2Point getVertex(int k2) {
        return S2Point.normalize(this.getVertexRaw(k2));
    }

    public S2Point getVertexRaw(int k2) {
        return S2Projections.faceUvToXyz(this.face, this.uv[0][k2 >> 1 ^ k2 & 1], this.uv[1][k2 >> 1]);
    }

    public S2Point getEdge(int k2) {
        return S2Point.normalize(this.getEdgeRaw(k2));
    }

    public S2Point getEdgeRaw(int k2) {
        switch (k2) {
            case 0: {
                return S2Projections.getVNorm(this.face, this.uv[1][0]);
            }
            case 1: {
                return S2Projections.getUNorm(this.face, this.uv[0][1]);
            }
            case 2: {
                return S2Point.neg(S2Projections.getVNorm(this.face, this.uv[1][1]));
            }
        }
        return S2Point.neg(S2Projections.getUNorm(this.face, this.uv[0][0]));
    }

    public boolean subdivide(S2Cell[] children) {
        if (this.cellId.isLeaf()) {
            return false;
        }
        R2Vector uvMid = this.getCenterUV();
        S2CellId id = this.cellId.childBegin();
        int pos = 0;
        while (pos < 4) {
            S2Cell child = children[pos];
            child.face = this.face;
            child.level = (byte)(this.level + 1);
            child.orientation = (byte)(this.orientation ^ S2.posToOrientation(pos));
            child.cellId = id;
            int ij = S2.posToIJ(this.orientation, pos);
            for (int d2 = 0; d2 < 2; ++d2) {
                int m2 = 1 - (ij >> 1 - d2 & 1);
                child.uv[d2][m2] = uvMid.get(d2);
                child.uv[d2][1 - m2] = this.uv[d2][1 - m2];
            }
            ++pos;
            id = id.next();
        }
        return true;
    }

    public S2Point getCenter() {
        return S2Point.normalize(this.getCenterRaw());
    }

    public S2Point getCenterRaw() {
        return this.cellId.toPointRaw();
    }

    public R2Vector getCenterUV() {
        MutableInteger i2 = new MutableInteger(0);
        MutableInteger j2 = new MutableInteger(0);
        this.cellId.toFaceIJOrientation(i2, j2, null);
        int cellSize = 1 << 30 - this.level;
        int si = (i2.intValue() & -cellSize) * 2 + cellSize - 0x40000000;
        double x = S2Projections.stToUV(9.313225746154785E-10 * (double)si);
        int sj = (j2.intValue() & -cellSize) * 2 + cellSize - 0x40000000;
        double y = S2Projections.stToUV(9.313225746154785E-10 * (double)sj);
        return new R2Vector(x, y);
    }

    public static double averageArea(int level) {
        return S2Projections.AVG_AREA.getValue(level);
    }

    public double averageArea() {
        return S2Cell.averageArea(this.level);
    }

    public double approxArea() {
        if (this.level < 2) {
            return S2Cell.averageArea(this.level);
        }
        double flatArea = 0.5 * S2Point.crossProd(S2Point.sub(this.getVertex(2), this.getVertex(0)), S2Point.sub(this.getVertex(3), this.getVertex(1))).norm();
        return flatArea * 2.0 / (1.0 + Math.sqrt(1.0 - Math.min(0.3183098861837907 * flatArea, 1.0)));
    }

    public double exactArea() {
        S2Point v0 = this.getVertex(0);
        S2Point v1 = this.getVertex(1);
        S2Point v2 = this.getVertex(2);
        S2Point v3 = this.getVertex(3);
        return S2.area(v0, v1, v2) + S2.area(v0, v2, v3);
    }

    public S2Region clone() {
        S2Cell clone = new S2Cell();
        clone.face = this.face;
        clone.level = this.level;
        clone.orientation = this.orientation;
        clone.uv = (double[][])this.uv.clone();
        return clone;
    }

    @Override
    public S2Cap getCapBound() {
        double u2 = 0.5 * (this.uv[0][0] + this.uv[0][1]);
        double v = 0.5 * (this.uv[1][0] + this.uv[1][1]);
        S2Cap cap = S2Cap.fromAxisHeight(S2Point.normalize(S2Projections.faceUvToXyz(this.face, u2, v)), 0.0);
        for (int k2 = 0; k2 < 4; ++k2) {
            cap = cap.addPoint(this.getVertex(k2));
        }
        return cap;
    }

    @Override
    public S2LatLngRect getRectBound() {
        if (this.level > 0) {
            int i2;
            double u2 = this.uv[0][0] + this.uv[0][1];
            double v = this.uv[1][0] + this.uv[1][1];
            int n2 = S2Projections.getUAxis((int)this.face).z == 0.0 ? (u2 < 0.0 ? 1 : 0) : (i2 = u2 > 0.0 ? 1 : 0);
            int j2 = S2Projections.getVAxis((int)this.face).z == 0.0 ? (v < 0.0 ? 1 : 0) : (v > 0.0 ? 1 : 0);
            R1Interval lat = R1Interval.fromPointPair(this.getLatitude(i2, j2), this.getLatitude(1 - i2, 1 - j2));
            lat = lat.expanded(4.440892098500626E-16).intersection(S2LatLngRect.fullLat());
            if (lat.lo() == -1.5707963267948966 || lat.hi() == 1.5707963267948966) {
                return new S2LatLngRect(lat, S1Interval.full());
            }
            S1Interval lng = S1Interval.fromPointPair(this.getLongitude(i2, 1 - j2), this.getLongitude(1 - i2, j2));
            return new S2LatLngRect(lat, lng.expanded(4.440892098500626E-16));
        }
        switch (this.face) {
            case 0: {
                return new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(-0.7853981633974483, 0.7853981633974483));
            }
            case 1: {
                return new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(0.7853981633974483, 2.356194490192345));
            }
            case 2: {
                return new S2LatLngRect(new R1Interval(POLE_MIN_LAT, 1.5707963267948966), new S1Interval(-Math.PI, Math.PI));
            }
            case 3: {
                return new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(2.356194490192345, -2.356194490192345));
            }
            case 4: {
                return new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(-2.356194490192345, -0.7853981633974483));
            }
        }
        return new S2LatLngRect(new R1Interval(-1.5707963267948966, -POLE_MIN_LAT), new S1Interval(-Math.PI, Math.PI));
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        return this.cellId.intersects(cell.cellId);
    }

    public boolean contains(S2Point p2) {
        R2Vector uvPoint = S2Projections.faceXyzToUv(this.face, p2);
        if (uvPoint == null) {
            return false;
        }
        return uvPoint.x() >= this.uv[0][0] && uvPoint.x() <= this.uv[0][1] && uvPoint.y() >= this.uv[1][0] && uvPoint.y() <= this.uv[1][1];
    }

    @Override
    public boolean contains(S2Cell cell) {
        return this.cellId.contains(cell.cellId);
    }

    private void init(S2CellId id) {
        this.cellId = id;
        MutableInteger[] ij = new MutableInteger[2];
        MutableInteger mOrientation = new MutableInteger(0);
        for (int d2 = 0; d2 < 2; ++d2) {
            ij[d2] = new MutableInteger(0);
        }
        this.face = (byte)id.toFaceIJOrientation(ij[0], ij[1], mOrientation);
        this.orientation = (byte)mOrientation.intValue();
        this.level = (byte)id.level();
        int cellSize = 1 << 30 - this.level;
        for (int d3 = 0; d3 < 2; ++d3) {
            int sijLo = (ij[d3].intValue() & -cellSize) * 2 - 0x40000000;
            int sijHi = sijLo + cellSize * 2;
            this.uv[d3][0] = S2Projections.stToUV(9.313225746154785E-10 * (double)sijLo);
            this.uv[d3][1] = S2Projections.stToUV(9.313225746154785E-10 * (double)sijHi);
        }
    }

    private double getLatitude(int i2, int j2) {
        S2Point p2 = S2Projections.faceUvToXyz(this.face, this.uv[0][i2], this.uv[1][j2]);
        return Math.atan2(p2.z, Math.sqrt(p2.x * p2.x + p2.y * p2.y));
    }

    private double getLongitude(int i2, int j2) {
        S2Point p2 = S2Projections.faceUvToXyz(this.face, this.uv[0][i2], this.uv[1][j2]);
        return Math.atan2(p2.y, p2.x);
    }

    public String toString() {
        return "[" + this.face + ", " + this.level + ", " + this.orientation + ", " + this.cellId + "]";
    }

    public int hashCode() {
        int value = 17;
        value = 37 * (37 * (37 * value + this.face) + this.orientation) + this.level;
        return 37 * value + this.id().hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof S2Cell) {
            S2Cell thatCell = (S2Cell)that;
            return this.face == thatCell.face && this.level == thatCell.level && this.orientation == thatCell.orientation && this.cellId.equals(thatCell.cellId);
        }
        return false;
    }
}

