/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

import com.baidu.common.geometry.R2Vector;
import com.baidu.common.geometry.S2Point;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public strictfp final class S2 {
    public static final double M_PI = Math.PI;
    public static final double M_1_PI = 0.3183098861837907;
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_PI_4 = 0.7853981633974483;
    public static final double M_SQRT2 = Math.sqrt(2.0);
    public static final double M_E = Math.E;
    public static final int SWAP_MASK = 1;
    public static final int INVERT_MASK = 2;
    private static final int EXPONENT_SHIFT = 52;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final int[] POS_TO_ORIENTATION = new int[]{1, 0, 0, 3};
    private static final int[][] POS_TO_IJ = new int[][]{{0, 1, 3, 2}, {0, 2, 3, 1}, {3, 2, 0, 1}, {3, 1, 0, 2}};
    private static final int[][] IJ_TO_POS = new int[][]{{0, 1, 3, 2}, {0, 3, 1, 2}, {2, 3, 1, 0}, {2, 1, 3, 0}};

    @VisibleForTesting
    static int exp(double v) {
        if (v == 0.0) {
            return 0;
        }
        long bits = Double.doubleToLongBits(v);
        return (int)((0x7FF0000000000000L & bits) >> 52) - 1022;
    }

    public static int posToOrientation(int position) {
        Preconditions.checkArgument((0 <= position && position < 4 ? 1 : 0) != 0);
        return POS_TO_ORIENTATION[position];
    }

    public static int posToIJ(int orientation, int position) {
        Preconditions.checkArgument((0 <= orientation && orientation < 4 ? 1 : 0) != 0);
        Preconditions.checkArgument((0 <= position && position < 4 ? 1 : 0) != 0);
        return POS_TO_IJ[orientation][position];
    }

    public static final int ijToPos(int orientation, int ijIndex) {
        Preconditions.checkArgument((0 <= orientation && orientation < 4 ? 1 : 0) != 0);
        Preconditions.checkArgument((0 <= ijIndex && ijIndex < 4 ? 1 : 0) != 0);
        return IJ_TO_POS[orientation][ijIndex];
    }

    public static S2Point origin() {
        return new S2Point(0.0, 1.0, 0.0);
    }

    public static boolean isUnitLength(S2Point p2) {
        return Math.abs(p2.norm2() - 1.0) <= 1.0E-15;
    }

    public static boolean simpleCrossing(S2Point a2, S2Point b2, S2Point c2, S2Point d2) {
        S2Point ab = S2Point.crossProd(a2, b2);
        S2Point cd = S2Point.crossProd(c2, d2);
        double acb = -ab.dotProd(c2);
        double cbd = -cd.dotProd(b2);
        double bda = ab.dotProd(d2);
        double dac = cd.dotProd(a2);
        return acb * cbd > 0.0 && cbd * bda > 0.0 && bda * dac > 0.0;
    }

    public static S2Point robustCrossProd(S2Point a2, S2Point b2) {
        S2Point x = S2Point.crossProd(S2Point.add(b2, a2), S2Point.sub(b2, a2));
        if (!x.equals(new S2Point(0.0, 0.0, 0.0))) {
            return x;
        }
        return S2.ortho(a2);
    }

    public static S2Point ortho(S2Point a2) {
        return a2.ortho();
    }

    static double area(S2Point a2, S2Point b2, S2Point c2) {
        double sc;
        double sb;
        double sa = b2.angle(c2);
        double s2 = 0.5 * (sa + (sb = c2.angle(a2)) + (sc = a2.angle(b2)));
        if (s2 >= 3.0E-4) {
            double area;
            double s22 = s2 * s2;
            double dmin = s2 - Math.max(sa, Math.max(sb, sc));
            if (dmin < 0.01 * s2 * s22 * s22 && dmin < s2 * (0.1 * (area = S2.girardArea(a2, b2, c2)))) {
                return area;
            }
        }
        return 4.0 * Math.atan(Math.sqrt(Math.max(0.0, Math.tan(0.5 * s2) * Math.tan(0.5 * (s2 - sa)) * Math.tan(0.5 * (s2 - sb)) * Math.tan(0.5 * (s2 - sc)))));
    }

    public static double girardArea(S2Point a2, S2Point b2, S2Point c2) {
        S2Point ab = S2Point.crossProd(a2, b2);
        S2Point bc = S2Point.crossProd(b2, c2);
        S2Point ac = S2Point.crossProd(a2, c2);
        return Math.max(0.0, ab.angle(ac) - ab.angle(bc) + bc.angle(ac));
    }

    public static double signedArea(S2Point a2, S2Point b2, S2Point c2) {
        return S2.area(a2, b2, c2) * (double)S2.robustCCW(a2, b2, c2);
    }

    public static S2Point planarCentroid(S2Point a2, S2Point b2, S2Point c2) {
        return new S2Point((a2.x + b2.x + c2.x) / 3.0, (a2.y + b2.y + c2.y) / 3.0, (a2.z + b2.z + c2.z) / 3.0);
    }

    public static S2Point trueCentroid(S2Point a2, S2Point b2, S2Point c2) {
        double sina = S2Point.crossProd(b2, c2).norm();
        double sinb = S2Point.crossProd(c2, a2).norm();
        double sinc = S2Point.crossProd(a2, b2).norm();
        double ra = sina == 0.0 ? 1.0 : Math.asin(sina) / sina;
        double rb = sinb == 0.0 ? 1.0 : Math.asin(sinb) / sinb;
        double rc = sinc == 0.0 ? 1.0 : Math.asin(sinc) / sinc;
        S2Point x = new S2Point(a2.x, b2.x, c2.x);
        S2Point y = new S2Point(a2.y, b2.y, c2.y);
        S2Point z2 = new S2Point(a2.z, b2.z, c2.z);
        S2Point r = new S2Point(ra, rb, rc);
        return new S2Point(0.5 * S2Point.crossProd(y, z2).dotProd(r), 0.5 * S2Point.crossProd(z2, x).dotProd(r), 0.5 * S2Point.crossProd(x, y).dotProd(r));
    }

    public static boolean simpleCCW(S2Point a2, S2Point b2, S2Point c2) {
        return S2Point.crossProd(c2, a2).dotProd(b2) > 0.0;
    }

    public static int robustCCW(S2Point a2, S2Point b2, S2Point c2) {
        return S2.robustCCW(a2, b2, c2, S2Point.crossProd(a2, b2));
    }

    public static int robustCCW(S2Point a2, S2Point b2, S2Point c2, S2Point aCrossB) {
        double kMinAbsValue = 1.6E-15;
        double det = aCrossB.dotProd(c2);
        if (det > 1.6E-15) {
            return 1;
        }
        if (det < -1.6E-15) {
            return -1;
        }
        return S2.expensiveCCW(a2, b2, c2);
    }

    private static int expensiveCCW(S2Point a2, S2Point b2, S2Point c2) {
        if (a2.equals(b2) || b2.equals(c2) || c2.equals(a2)) {
            return 0;
        }
        double sab = a2.dotProd(b2) > 0.0 ? -1.0 : 1.0;
        double sbc = b2.dotProd(c2) > 0.0 ? -1.0 : 1.0;
        double sca = c2.dotProd(a2) > 0.0 ? -1.0 : 1.0;
        S2Point vab = S2Point.add(a2, S2Point.mul(b2, sab));
        S2Point vbc = S2Point.add(b2, S2Point.mul(c2, sbc));
        S2Point vca = S2Point.add(c2, S2Point.mul(a2, sca));
        double dab = vab.norm2();
        double dbc = vbc.norm2();
        double dca = vca.norm2();
        double sign = dca < dbc || dca == dbc && a2.lessThan(b2) ? (dab < dbc || dab == dbc && a2.lessThan(c2) ? S2Point.crossProd(vab, vca).dotProd(a2) * sab : S2Point.crossProd(vca, vbc).dotProd(c2) * sca) : (dab < dca || dab == dca && b2.lessThan(c2) ? S2Point.crossProd(vbc, vab).dotProd(b2) * sbc : S2Point.crossProd(vca, vbc).dotProd(c2) * sca);
        if (sign > 0.0) {
            return 1;
        }
        if (sign < 0.0) {
            return -1;
        }
        int ccw = S2.planarOrderedCCW(new R2Vector(a2.y, a2.z), new R2Vector(b2.y, b2.z), new R2Vector(c2.y, c2.z));
        if (ccw == 0 && (ccw = S2.planarOrderedCCW(new R2Vector(a2.z, a2.x), new R2Vector(b2.z, b2.x), new R2Vector(c2.z, c2.x))) == 0) {
            ccw = S2.planarOrderedCCW(new R2Vector(a2.x, a2.y), new R2Vector(b2.x, b2.y), new R2Vector(c2.x, c2.y));
        }
        return ccw;
    }

    public static int planarCCW(R2Vector a2, R2Vector b2) {
        double db;
        double sab = a2.dotProd(b2) > 0.0 ? -1.0 : 1.0;
        R2Vector vab = R2Vector.add(a2, R2Vector.mul(b2, sab));
        double da = a2.norm2();
        double sign = da < (db = b2.norm2()) || da == db && a2.lessThan(b2) ? a2.crossProd(vab) * sab : vab.crossProd(b2);
        if (sign > 0.0) {
            return 1;
        }
        if (sign < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int planarOrderedCCW(R2Vector a2, R2Vector b2, R2Vector c2) {
        int sum = 0;
        sum += S2.planarCCW(a2, b2);
        sum += S2.planarCCW(b2, c2);
        if ((sum += S2.planarCCW(c2, a2)) > 0) {
            return 1;
        }
        if (sum < 0) {
            return -1;
        }
        return 0;
    }

    public static boolean orderedCCW(S2Point a2, S2Point b2, S2Point c2, S2Point o2) {
        int sum = 0;
        if (S2.robustCCW(b2, o2, a2) >= 0) {
            ++sum;
        }
        if (S2.robustCCW(c2, o2, b2) >= 0) {
            ++sum;
        }
        if (S2.robustCCW(a2, o2, c2) > 0) {
            ++sum;
        }
        return sum >= 2;
    }

    public static double angle(S2Point a2, S2Point b2, S2Point c2) {
        return S2Point.crossProd(a2, b2).angle(S2Point.crossProd(c2, b2));
    }

    public static double turnAngle(S2Point a2, S2Point b2, S2Point c2) {
        double outAngle = S2Point.crossProd(b2, a2).angle(S2Point.crossProd(c2, b2));
        return S2.robustCCW(a2, b2, c2) > 0 ? outAngle : -outAngle;
    }

    public static boolean approxEquals(S2Point a2, S2Point b2, double maxError) {
        return a2.angle(b2) <= maxError;
    }

    public static boolean approxEquals(S2Point a2, S2Point b2) {
        return S2.approxEquals(a2, b2, 1.0E-15);
    }

    public static boolean approxEquals(double a2, double b2, double maxError) {
        return Math.abs(a2 - b2) <= maxError;
    }

    public static boolean approxEquals(double a2, double b2) {
        return S2.approxEquals(a2, b2, 1.0E-15);
    }

    private S2() {
    }

    public strictfp static class Metric {
        private final double deriv;
        private final int dim;

        public Metric(int dim, double deriv) {
            this.deriv = deriv;
            this.dim = dim;
        }

        public double deriv() {
            return this.deriv;
        }

        public double getValue(int level) {
            return StrictMath.scalb(this.deriv, this.dim * (1 - level));
        }

        public int getClosestLevel(double value) {
            return this.getMinLevel(M_SQRT2 * value);
        }

        public int getMinLevel(double value) {
            if (value <= 0.0) {
                return 30;
            }
            int exponent = S2.exp(value / ((double)(1 << this.dim) * this.deriv));
            int level = Math.max(0, Math.min(30, -(exponent - 1 >> this.dim - 1)));
            return level;
        }

        public int getMaxLevel(double value) {
            if (value <= 0.0) {
                return 30;
            }
            int exponent = S2.exp((double)(1 << this.dim) * this.deriv / value);
            int level = Math.max(0, Math.min(30, exponent - 1 >> this.dim - 1));
            return level;
        }
    }
}

