/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.DailyActivity;
import com.ipinyou.rpc.dependency.Input;
import com.netflix.config.DynamicPropertyFactory;
import convert.DAConverter;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.zhenchuan.db.history.DailyModel;
import me.zhenchuan.uid.UidConfig;
import store.CassandraStore;
import store.KVStore;

public class HistoryClient {
    private KVStore<List<byte[]>> store;
    private DynamicPropertyFactory propertyFactory = DynamicPropertyFactory.getInstance();
    private static final HistoryClient historyClient = new HistoryClient();

    public static final HistoryClient getInstance() {
        return historyClient;
    }

    private HistoryClient() {
        String keyspace = this.propertyFactory.getStringProperty("keyspace", "se7en").get();
        this.store = new CassandraStore(keyspace);
        this.store.connect();
    }

    public List<DailyActivity> get(String pyid, long startDay, long endDay) {
        long uid = UidConfig.uid(pyid);
        long shard = UidConfig.shard(pyid);
        List<byte[]> result = this.store.get(shard, uid, startDay, endDay);
        return result.stream().map(bytes -> DAConverter.convert(new DailyModel().decode(new Input((byte[])bytes)))).collect(Collectors.toList());
    }

    public void asyncGet(String pyid, long startDay, long endDay, Consumer<List<DailyActivity>> onMessage) {
        long uid = UidConfig.uid(pyid);
        long shard = UidConfig.shard(pyid);
        this.store.asyncGet(shard, uid, startDay, endDay, result -> {
            List tmp = result.stream().map(bytes -> DAConverter.convert(new DailyModel().decode(new Input((byte[])bytes)))).collect(Collectors.toList());
            onMessage.accept(tmp);
        });
    }

    public void close() {
        this.store.shutdown();
    }
}

