/*
 * Decompiled with CFR 0.152.
 */
package me.vlobanov.mustache;

public class Scanner {
    public static final String TAGS = "#^>!/{&?";
    String template;
    int idx;
    int currLine;

    public Scanner(String template) {
        this.template = template;
        this.idx = 0;
        this.currLine = 1;
    }

    public boolean eos() {
        return this.idx == this.template.length() - 1;
    }

    private void addNewLines(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            ++this.currLine;
        }
    }

    public String scanUtil(String patten) {
        int pos = this.template.indexOf(patten, this.idx);
        if (pos == -1) {
            String match = this.template.substring(this.idx);
            this.idx = this.template.length() - 1;
            this.addNewLines(match);
            return match;
        }
        if (pos == 0) {
            this.idx += patten.length();
            return null;
        }
        String match = this.template.substring(this.idx, pos);
        this.idx = pos + patten.length();
        this.addNewLines(match);
        return match;
    }

    public void skipeWhiteSpace() {
        while (Character.isWhitespace(this.next()) && !this.eos()) {
            ++this.idx;
        }
    }

    private char next() {
        return this.template.charAt(this.idx);
    }

    public void pushBack(int count) {
        this.idx -= count;
    }

    public int getCurrentLine() {
        return this.currLine;
    }

    public char nextType() {
        this.skipeWhiteSpace();
        if (!this.eos()) {
            char c = this.next();
            if (TAGS.indexOf(c) != -1) {
                ++this.idx;
                if (c == '?') {
                    System.err.println("WARN: use nonstandard ?");
                }
                return c;
            }
            return 'n';
        }
        return '\u0000';
    }
}

