/*
 * Decompiled with CFR 0.152.
 */
package me.vlobanov.mustache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceList {
    public static List<String> getResources(String folder, List<String> extensions) throws IOException {
        String[] paths;
        ArrayList<String> files = new ArrayList<String>(32);
        for (String path : paths = System.getProperty("java.class.path", ".").split(":")) {
            File file = new File(path);
            if (file.isDirectory()) {
                files.addAll(ResourceList.getFromDir(file, folder, extensions));
                continue;
            }
            if (!file.exists()) continue;
            files.addAll(ResourceList.getFromJar(file, folder, extensions));
        }
        return files;
    }

    private static boolean accpet(String path, String folder, List<String> extensions) throws IOException {
        boolean b = false;
        for (String e : extensions) {
            if (!path.endsWith(e)) continue;
            b = true;
            break;
        }
        return b && path.contains(folder);
    }

    public static List<String> getFromJar(File file, String folder, List<String> extensions) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        ZipFile zf = new ZipFile(file);
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            if (!ResourceList.accpet(fileName, folder, extensions)) continue;
            files.add(fileName);
        }
        zf.close();
        return files;
    }

    public static List<String> getFromDir(File dir, String folder, List<String> extensions) throws IOException {
        ArrayList<String> files = new ArrayList<String>(16);
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                files.addAll(ResourceList.getFromDir(f, folder, extensions));
                continue;
            }
            String path = f.getAbsolutePath();
            if (!ResourceList.accpet(path, folder, extensions)) continue;
            files.add(path);
        }
        return files;
    }
}

