/*
 * Decompiled with CFR 0.152.
 */
package me.vlobanov.mustache;

import clojure.lang.Keyword;
import java.util.List;
import java.util.Map;
import me.vlobanov.mustache.Context;
import me.vlobanov.mustache.KeyFactory;
import me.vlobanov.mustache.Mustache;
import me.vlobanov.mustache.ParserException;

public class Token {
    public static final char TEXT = 't';
    public static final char NAME = 'n';
    public static final char NO_ESCAPE1 = '{';
    public static final char NO_ESCAPE2 = '&';
    public static final char SECTION = '#';
    public static final char TRUE = '?';
    public static final char INVERTED = '^';
    public static final char PARTIAL = '>';
    final char type;
    final Object value;
    List<Token> tokens;

    public Token(char type, String value) throws ParserException {
        this.type = type;
        if (type != 't') {
            value = value.trim();
            this.value = KeyFactory.createKey(value);
        } else {
            this.value = value;
        }
    }

    public static String renderTokens(List<Token> tokens, Context c, Map<Keyword, String> partials) throws ParserException {
        StringBuilder sb = new StringBuilder();
        for (Token t : tokens) {
            sb.append(t.render(c, partials));
        }
        return sb.toString();
    }

    public static String escapeHtml(String html) {
        StringBuilder sb = new StringBuilder(html.length() + 10);
        block7: for (int i = 0; i < html.length(); ++i) {
            char c = html.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String render(Context c, Map<Keyword, String> partials) throws ParserException {
        switch (this.type) {
            case 't': {
                return this.value.toString();
            }
            case 'n': {
                Object v = c.lookup(this.value);
                if (v == null) break;
                return Token.escapeHtml(v.toString());
            }
            case '&': 
            case '{': {
                Object r = c.lookup(this.value);
                if (r == null) break;
                return r.toString();
            }
            case '?': {
                if (this.tokens == null || Context.isFalse(c.lookup(this.value))) break;
                return Token.renderTokens(this.tokens, c, partials);
            }
            case '#': {
                if (this.tokens == null) break;
                Object n = c.lookup(this.value);
                if (Context.isArray(n)) {
                    StringBuilder sb = new StringBuilder();
                    List list = (List)n;
                    for (Object o : list) {
                        Context nested = new Context(o, c);
                        for (Token t : this.tokens) {
                            sb.append(t.render(nested, partials));
                        }
                    }
                    return sb.toString();
                }
                if (Context.isFalse(n)) break;
                return Token.renderTokens(this.tokens, new Context(n, c), partials);
            }
            case '^': {
                if (this.tokens == null || !Context.isFalse(c.lookup(this.value))) break;
                return Token.renderTokens(this.tokens, c, partials);
            }
            case '>': {
                String template;
                if (partials == null || (template = partials.get(this.value)) == null) break;
                return Mustache.preprocess(template).render(c, partials);
            }
        }
        return "";
    }

    public String toString() {
        if (this.tokens != null) {
            return this.type + " " + this.value + "\t" + this.tokens;
        }
        return this.type + " " + this.value;
    }
}

