/*
 * Decompiled with CFR 0.152.
 */
package me.vlobanov.mustache;

import java.util.Map;
import me.vlobanov.mustache.NestedKey;
import me.vlobanov.mustache.ParserException;

public class ParameterizedKey {
    NestedKey key;
    NestedKey[] argsKeys;

    public ParameterizedKey(String value) throws ParserException {
        String[] openParensParts = value.split("\\(");
        if (openParensParts.length != 2) {
            throw new ParserException("Expected to find exactly 1 open parenthesis in " + value);
        }
        if (!value.endsWith(")")) {
            throw new ParserException("Expected to find close parenthesis in " + value);
        }
        String formattedKey = openParensParts[0];
        String argumentsStr = openParensParts[1].substring(0, openParensParts[1].length() - 1);
        if (argumentsStr.indexOf(")") >= 0) {
            throw new ParserException("Expected to find exactly 1 close parenthesis in " + value);
        }
        String[] arguments = argumentsStr.split("\\W*,\\W*");
        this.argsKeys = new NestedKey[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            this.argsKeys[i] = new NestedKey(arguments[i]);
        }
        this.key = new NestedKey(formattedKey);
    }

    public Object getIn(Map m, Object notFound) {
        Object[] argsResults = new Object[this.argsKeys.length];
        String notFoundArg = "";
        for (int i = 0; i < this.argsKeys.length; ++i) {
            argsResults[i] = this.argsKeys[i].getIn(m, notFoundArg);
        }
        Object keyValue = this.key.getIn(m, notFound);
        if (keyValue == notFound) {
            return notFound;
        }
        return String.format((String)keyValue, argsResults);
    }

    public static boolean isParameterizedKey(String value) {
        return value.indexOf("(") >= 0;
    }
}

