/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.mmseg;

import java.math.BigInteger;
import java.util.Arrays;
import me.shenfeng.mmseg.Counter;
import me.shenfeng.mmseg.Word;

class HashSet {
    private Object[] data;
    final int prime;

    public HashSet(int count) {
        this.prime = this.getPrime(count);
        this.data = new Object[this.prime];
    }

    public void insert(Word w) {
        int i = w.hashCode() % this.prime;
        Object val = this.data[i];
        if (val == null) {
            this.data[i] = w;
        } else {
            Word[] arr = val instanceof Word ? new Word[]{(Word)val} : (Word[])val;
            arr = Arrays.copyOf(arr, arr.length + 1);
            arr[arr.length - 1] = w;
            this.data[i] = arr;
        }
    }

    public Counter getLoad() {
        Counter c = new Counter();
        for (Object slot : this.data) {
            if (slot == null) {
                c.add(0);
                continue;
            }
            if (slot instanceof Word) {
                c.add(1);
                continue;
            }
            c.add(((Word[])slot).length);
        }
        return c;
    }

    public boolean contains(Word w) {
        int i = w.hashCode() % this.prime;
        Object val = this.data[i];
        if (val instanceof Word) {
            return w.equals(val);
        }
        if (val instanceof Word[]) {
            Word[] arr;
            for (Word word : arr = (Word[])val) {
                if (!word.equals(w)) continue;
                return true;
            }
        }
        return false;
    }

    private int getPrime(int n) {
        int prev = 0;
        BigInteger b = BigInteger.valueOf(n);
        int prime = 0;
        int max = n + n / 2;
        while ((prime = b.nextProbablePrime().intValue()) < max) {
            prev = prime;
            b = BigInteger.valueOf(prime);
        }
        return prev;
    }
}

